/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SelectionUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006$"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "wrapActionBaseName", "", "getWrapActionBaseName", "()Ljava/lang/String;", "unwrapActionName", "getUnwrapActionName", "obtainWrapActionName", "Lorg/jetbrains/annotations/Nls;", "place", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "wrapSelectionWithLink", "caret", "Lcom/intellij/openapi/editor/Caret;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getLinkDestinationInClipboard", "unwrapLink", "linkElement", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownCreateLinkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCreateLinkAction.kt\norg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1834#2,4:215\n1068#2:219\n1586#2:220\n1661#2,3:221\n1696#2,8:224\n1915#2,2:232\n1#3:234\n*S KotlinDebug\n*F\n+ 1 MarkdownCreateLinkAction.kt\norg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction\n*L\n55#1:215,4\n89#1:219\n90#1:220\n90#1:221,3\n91#1:224,8\n92#1:232,2\n*E\n"})
public final class MarkdownCreateLinkAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getWrapActionBaseName() {
        String string = MarkdownBundle.message("action.Markdown.Styling.CreateLink.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getUnwrapActionName() {
        String string = MarkdownBundle.message("action.Markdown.Styling.CreateLink.unwrap.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String obtainWrapActionName(String place) {
        String string;
        if (Intrinsics.areEqual((Object)place, (Object)MarkdownActionPlaces.getINSERT_POPUP())) {
            String string2 = MarkdownBundle.message("action.Markdown.Styling.CreateLink.insert.popup.text", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = this.getWrapActionBaseName();
        }
        return string;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        boolean bl;
        int n;
        Collection<SelectionUtil.CaretSnapshot> caretSnapshots;
        PsiFile file;
        Editor editor2;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                editor2 = MarkdownActionUtil.findMarkdownEditor$default(event, false, 2, null);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                if (editor2 == null || file == null) break block12;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block13;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return false;
        }
        event.getPresentation().setEnabledAndVisible(true);
        Collection<SelectionUtil.CaretSnapshot> collection = caretSnapshots = SelectionUtil.obtainCaretSnapshots((AnAction)this, event);
        if (collection != null) {
            Iterable $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    SelectionUtil.CaretSnapshot it = (SelectionUtil.CaretSnapshot)element$iv;
                    boolean bl2 = false;
                    if (!(MarkdownCreateLinkAction.Companion.obtainSelectedLinkElement(it, file) != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        int caretsWithLinksCount = n;
        if (caretsWithLinksCount == 0 || Intrinsics.areEqual((Object)event.getPlace(), (Object)"EditorPopup")) {
            event.getPresentation().setEnabled(!editor2.isViewer());
            Presentation presentation = event.getPresentation();
            String string = event.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            presentation.setText(this.obtainWrapActionName(string));
            event.getPresentation().setDescription(MarkdownBundle.message("action.Markdown.Styling.CreateLink.description", new Object[0]));
            bl = false;
        } else if (caretsWithLinksCount == editor2.getCaretModel().getCaretCount()) {
            event.getPresentation().setEnabled(!editor2.isViewer());
            event.getPresentation().setText(this.getUnwrapActionName());
            event.getPresentation().setDescription(MarkdownBundle.message("action.Markdown.Styling.CreateLink.unwrap.description", new Object[0]));
            bl = true;
        } else {
            event.getPresentation().setEnabled(false);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor$default(event, false, 2, null);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        if (state) {
            for (Caret caret : editor3.getCaretModel().getAllCarets()) {
                Intrinsics.checkNotNull((Object)caret);
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                this.wrapSelectionWithLink(caret, editor3, project);
            }
        } else {
            void $this$forEach$iv;
            Iterable $this$distinctBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable $this$sortedBy$iv;
            List list2 = editor3.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
            Iterable iterable = list2;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-it.getOffset());
                    it = (Caret)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getOffset()));
                }
            });
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void caret;
                Caret caret2 = (Caret)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)caret);
                collection.add(TuplesKt.to((Object)caret, (Object)MarkdownCreateLinkAction.Companion.getSelectedLinkElement((Caret)caret, file)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<PsiElement> set$iv = new HashSet<PsiElement>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Object item$iv$iv;
                item$iv$iv = (Pair)e$iv;
                boolean bl = false;
                PsiElement element2 = (PsiElement)item$iv$iv.component2();
                PsiElement key$iv = element2;
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                Caret caret = (Caret)pair.component1();
                PsiElement element3 = (PsiElement)pair.component2();
                boolean bl3 = bl = element3 != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (element3 == null) continue;
                Intrinsics.checkNotNull((Object)caret);
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                this.unwrapLink(element3, caret, editor3, project);
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Icon originalIcon = event.getPresentation().getIcon();
        super.update(event);
        if (event.isFromContextMenu()) {
            event.getPresentation().setIcon(originalIcon);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void wrapSelectionWithLink(Caret caret, Editor editor2, Project project) {
        PsiFile[] psiFileArray;
        PsiFile file;
        String string = caret.getSelectedText();
        if (string == null) {
            string = "";
        }
        String selected = string;
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            PsiFile[] psiFileArray2 = new PsiFile[]{it};
            psiFileArray = psiFileArray2;
        } else {
            psiFileArray = new PsiFile[]{};
        }
        PsiFile[] fileArray = psiFileArray;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(fileArray, fileArray.length)).withName(this.getWrapActionBaseName()).run(() -> MarkdownCreateLinkAction.wrapSelectionWithLink$lambda$1(caret, editor2, selectionStart, selectionEnd, selected, this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getLinkDestinationInClipboard(Editor editor2) {
        boolean bl;
        String string;
        String string2 = ClipboardUtil.getTextInClipboard();
        if (string2 == null) return null;
        String path = string = string2;
        boolean bl2 = false;
        Url url = Urls.parse((String)path, (boolean)true);
        if (url == null) {
            return null;
        }
        if (url instanceof LocalFileUrl) {
            Path absolutePath;
            VirtualFile virtualFile;
            Path path2;
            try {
                path2 = Path.of(path, new String[0]);
            }
            catch (InvalidPathException e) {
                return null;
            }
            Path relativePath = path2;
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (virtualFile2 == null) return null;
            VirtualFile virtualFile3 = virtualFile2.getParent();
            VirtualFile virtualFile4 = virtualFile = virtualFile3;
            Object object = virtualFile4;
            if (virtualFile4 == null) return null;
            VirtualFile it = object;
            boolean bl3 = false;
            Path path3 = Path.of(it.getPath(), new String[0]);
            object = path3;
            if (path3 == null) return null;
            Path path4 = object.resolve(relativePath);
            Path path5 = absolutePath = path4;
            if (path5 == null) return null;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = true;
        }
        if (!bl) return null;
        String string3 = string;
        return string3;
    }

    private final void unwrapLink(PsiElement linkElement, Caret caret, Editor editor2, Project project) {
        PsiFile[] psiFileArray;
        PsiFile file;
        String string;
        String string2;
        Object object;
        Object object2;
        block3: {
            PsiElement[] psiElementArray = linkElement.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            object2 = psiElementArray;
            int n = ((Object[])object2).length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object2[i];
                PsiElement it = (PsiElement)object3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                object = object3;
                break block3;
            }
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        String linkText = psiElement != null && (string2 = psiElement.getText()) != null && (object2 = StringsKt.drop((String)string2, (int)1)) != null && (string = StringsKt.dropLast((String)object2, (int)1)) != null ? string : "";
        int start = PsiTreeUtilKt.getStartOffset((PsiElement)linkElement);
        int newEnd = start + linkText.length();
        int selectionStart = Math.max(start, Math.min(newEnd, caret.getSelectionStart() - 1));
        int selectionEnd = Math.max(start, Math.min(newEnd, caret.getSelectionEnd() - 1));
        PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            PsiFile[] psiFileArray2 = new PsiFile[]{it};
            psiFileArray = psiFileArray2;
        } else {
            psiFileArray = new PsiFile[]{};
        }
        PsiFile[] fileArray = psiFileArray;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(fileArray, fileArray.length)).withName(this.getUnwrapActionName()).run(() -> MarkdownCreateLinkAction.unwrapLink$lambda$2(selectionStart, selectionEnd, caret, editor2, start, linkElement, linkText));
    }

    private static final void wrapSelectionWithLink$lambda$1(Caret $caret, Editor $editor, int $selectionStart, int $selectionEnd, String $selected, MarkdownCreateLinkAction this$0) {
        block0: {
            $caret.removeSelection();
            $editor.getDocument().replaceString($selectionStart, $selectionEnd, (CharSequence)("[" + $selected + "]()"));
            $caret.moveToOffset($selectionEnd + 3);
            String string = this$0.getLinkDestinationInClipboard($editor);
            if (string == null) break block0;
            String linkDestination = string;
            boolean bl = false;
            int linkStartOffset = $caret.getOffset();
            $editor.getDocument().insertString(linkStartOffset, (CharSequence)linkDestination);
            $caret.setSelection(linkStartOffset, linkStartOffset + linkDestination.length());
        }
    }

    private static final void unwrapLink$lambda$2(int $selectionStart, int $selectionEnd, Caret $caret, Editor $editor, int $start, PsiElement $linkElement, String $linkText) {
        if ($selectionStart == $selectionEnd) {
            $caret.removeSelection();
            $caret.moveCaretRelatively(-1, 0, false, false);
        }
        $editor.getDocument().replaceString($start, PsiTreeUtilKt.getEndOffset((PsiElement)$linkElement), (CharSequence)$linkText);
        if ($selectionStart != $selectionEnd) {
            $caret.setSelection($selectionStart, $selectionEnd);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction$Companion;", "", "<init>", "()V", "obtainSelectedLinkElement", "Lcom/intellij/psi/PsiElement;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil$CaretSnapshot;", "file", "Lcom/intellij/psi/PsiFile;", "getSelectedLinkElement", "Lcom/intellij/openapi/editor/Caret;", "offset", "", "hasSelection", "", "selectionStart", "selectionEnd", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownCreateLinkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCreateLinkAction.kt\norg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiElement obtainSelectedLinkElement(SelectionUtil.CaretSnapshot $this$obtainSelectedLinkElement, PsiFile file) {
            return this.obtainSelectedLinkElement(file, $this$obtainSelectedLinkElement.getOffset(), $this$obtainSelectedLinkElement.getHasSelection(), $this$obtainSelectedLinkElement.getSelectionStart(), $this$obtainSelectedLinkElement.getSelectionEnd());
        }

        private final PsiElement getSelectedLinkElement(Caret $this$getSelectedLinkElement, PsiFile file) {
            return this.obtainSelectedLinkElement(file, $this$getSelectedLinkElement.getOffset(), $this$getSelectedLinkElement.hasSelection(), $this$getSelectedLinkElement.getSelectionStart(), $this$getSelectedLinkElement.getSelectionEnd());
        }

        private final PsiElement obtainSelectedLinkElement(PsiFile file, int offset, boolean hasSelection, int selectionStart, int selectionEnd) {
            PsiElement element2;
            PsiElement psiElement;
            Object v1;
            block2: {
                Sequence elements2;
                Sequence sequence = elements2 = SequencesKt.asSequence((Iterator)PsiTreeUtilKt.elementsAtOffsetUp((PsiFile)file, (int)selectionStart));
                for (Object e : sequence) {
                    Pair pair = (Pair)e;
                    boolean bl = false;
                    PsiElement element3 = (PsiElement)pair.component1();
                    IElementType iElementType = MarkdownElementTypes.INLINE_LINK;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"INLINE_LINK");
                    if (!PsiUtilsKt.hasType(element3, iElementType)) continue;
                    v1 = e;
                    break block2;
                }
                v1 = null;
            }
            Pair pair = v1;
            if (pair == null) {
                return null;
            }
            PsiElement it = psiElement = (element2 = (PsiElement)pair.component1());
            boolean bl = false;
            return (hasSelection ? selectionEnd <= PsiTreeUtilKt.getEndOffset((PsiElement)element2) : offset > PsiTreeUtilKt.getStartOffset((PsiElement)element2)) ? psiElement : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

