/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.ui.preview.html.ASTUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/HeaderGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "headerTag", "", "<init>", "(Ljava/lang/String;)V", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "Companion", "intellij.markdown"})
@ApiStatus.Internal
public final class HeaderGeneratingProvider
extends SimpleTagProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> whitespaces;

    public HeaderGeneratingProvider(@NotNull String headerTag) {
        Intrinsics.checkNotNullParameter((Object)headerTag, (String)"headerTag");
        super(headerTag);
    }

    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String anchorText = HeaderGeneratingProvider.Companion.buildUniqueAnchorText(node, text2);
        if (anchorText == null) {
            super.openTag(visitor2, text2, node);
            return;
        }
        CharSequence[] charSequenceArray = new CharSequence[]{"id=\"" + anchorText + "\""};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor2, (ASTNode)node, (CharSequence)this.getTagName(), (CharSequence[])charSequenceArray, (boolean)false, (int)8, null);
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.EOL, MarkdownTokenTypes.WHITE_SPACE};
        whitespaces = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\u0014*\u00060\u0015j\u0002`\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/HeaderGeneratingProvider$Companion;", "", "<init>", "()V", "whitespaces", "", "Lorg/intellij/markdown/IElementType;", "findContentHolder", "Lorg/intellij/markdown/ast/ASTNode;", "node", "buildAnchorText", "", "fileText", "buildUniqueAnchorText", "calculateUniqueNumber", "", "rawAnchorText", "obtainLinkTextElements", "Lkotlin/sequences/Sequence;", "processInlineLink", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nHeaderGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderGeneratingProvider.kt\norg/intellij/plugins/markdown/ui/preview/html/HeaderGeneratingProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ASTNode findContentHolder(ASTNode node) {
            Object v0;
            block1: {
                Sequence<ASTNode> sequence = ASTUtilsKt.children(node);
                for (Object e : sequence) {
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.ATX_CONTENT) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.SETEXT_CONTENT))) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final String buildAnchorText(@NotNull ASTNode node, @NotNull String fileText) {
            String string;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
            ASTNode aSTNode = this.findContentHolder(node);
            if (aSTNode == null) {
                return null;
            }
            ASTNode contentHolder = aSTNode;
            Sequence children2 = SequencesKt.dropWhile(ASTUtilsKt.children(contentHolder), Companion::buildAnchorText$lambda$0);
            StringBuilder $this$buildAnchorText_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int count = 0;
            for (ASTNode child : children2) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
                    $this$buildAnchorText_u24lambda_u241.append(" ");
                    continue;
                }
                IElementType iElementType = child.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE)) {
                    v1 = $this$buildAnchorText_u24lambda_u241.append("");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    Companion.processInlineLink($this$buildAnchorText_u24lambda_u241, child, fileText);
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = $this$buildAnchorText_u24lambda_u241.append(ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)fileText));
                }
                ++count;
            }
            String text2 = stringBuilder.toString();
            String string2 = MarkdownHeader.Companion.replaceEntities(text2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            Regex regex = MarkdownHeader.Companion.getGarbageRegex$intellij_markdown();
            String string3 = "";
            String replaced = StringsKt.replace$default((String)regex.replace(charSequence, string3), (String)" ", (String)"-", (boolean)false, (int)4, null);
            if (AdvancedSettings.Companion.getBoolean("markdown.squash.multiple.dashes.in.header.anchors")) {
                charSequence = replaced;
                regex = new Regex("-{2,}");
                string3 = "-";
                string = regex.replace(charSequence, string3);
            } else {
                string = replaced;
            }
            return string;
        }

        private final String buildUniqueAnchorText(ASTNode node, String fileText) {
            String string = this.buildAnchorText(node, fileText);
            if (string == null) {
                return null;
            }
            String anchorText = string;
            int number = this.calculateUniqueNumber(node, fileText, anchorText);
            return MarkdownHeader.Companion.createUniqueAnchorText(anchorText, number);
        }

        private final int calculateUniqueNumber(ASTNode node, String fileText, String rawAnchorText) {
            IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE};
            ASTNode aSTNode = ASTUtilKt.getParentOfType((ASTNode)node, (IElementType[])iElementTypeArray);
            if (aSTNode == null) {
                return 0;
            }
            ASTNode file = aSTNode;
            Sequence headers = SequencesKt.filter(ASTUtilsKt.traverse(file), Companion::calculateUniqueNumber$lambda$0);
            Sequence sameHeaders = SequencesKt.filter((Sequence)headers, arg_0 -> Companion.calculateUniqueNumber$lambda$1(fileText, rawAnchorText, arg_0));
            return SequencesKt.count((Sequence)SequencesKt.takeWhile((Sequence)sameHeaders, arg_0 -> Companion.calculateUniqueNumber$lambda$2(node, arg_0)));
        }

        private final Sequence<ASTNode> obtainLinkTextElements(ASTNode node) {
            Iterator iterator;
            Object object;
            Object v0;
            Iterator iterator2;
            ASTNode aSTNode;
            block6: {
                aSTNode = ASTUtilsKt.children(node);
                iterator2 = aSTNode.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            ASTNode aSTNode2 = v0;
            if (aSTNode2 == null) {
                return SequencesKt.emptySequence();
            }
            ASTNode textHolder = aSTNode2;
            ASTNode aSTNode3 = ASTUtilsKt.getFirstChild(textHolder);
            if (aSTNode3 != null) {
                ASTNode it = aSTNode = aSTNode3;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) ? aSTNode : null;
            } else {
                object = null;
            }
            ASTNode openBracket = object;
            ASTNode aSTNode4 = ASTUtilsKt.getLastChild(textHolder);
            if (aSTNode4 != null) {
                Iterator it = iterator2 = aSTNode4;
                boolean bl = false;
                iterator = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) ? iterator2 : null;
            } else {
                iterator = null;
            }
            Iterator closeBracket = iterator;
            return SequencesKt.filterNot(ASTUtilsKt.children(textHolder), arg_0 -> Companion.obtainLinkTextElements$lambda$3(openBracket, closeBracket, arg_0));
        }

        private final void processInlineLink(StringBuilder $this$processInlineLink, ASTNode node, String fileText) {
            Sequence<ASTNode> contentElements = this.obtainLinkTextElements(node);
            Sequence withoutWhitespaces = SequencesKt.filterNot(contentElements, Companion::processInlineLink$lambda$0);
            SequencesKt.joinTo$default((Sequence)withoutWhitespaces, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, arg_0 -> Companion.processInlineLink$lambda$1(fileText, arg_0), (int)60, null);
        }

        private static final boolean buildAnchorText$lambda$0(ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE);
        }

        private static final boolean calculateUniqueNumber$lambda$0(ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return MarkdownElementType.isHeaderElementType(it.getType());
        }

        private static final boolean calculateUniqueNumber$lambda$1(String $fileText, String $rawAnchorText, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)Companion.buildAnchorText(it, $fileText), (Object)$rawAnchorText);
        }

        private static final boolean calculateUniqueNumber$lambda$2(ASTNode $node, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it, (Object)$node);
        }

        private static final boolean obtainLinkTextElements$lambda$3(ASTNode $openBracket, ASTNode $closeBracket, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)$openBracket) || Intrinsics.areEqual((Object)it, (Object)$closeBracket);
        }

        private static final boolean processInlineLink$lambda$0(ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return whitespaces.contains(it.getType());
        }

        private static final CharSequence processInlineLink$lambda$1(String $fileText, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.IMAGE) ? (CharSequence)"" : ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)$fileText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

