/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionProcess;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import com.intellij.terminal.frontend.view.completion.TerminalLookupPrefixUpdater;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.view.TerminalContentChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalCursorOffsetChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\fH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\fH\u0087@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupPrefixUpdater;", "", "model", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lkotlinx/coroutines/CoroutineScope;)V", "prefixUpdateRequests", "Lkotlinx/coroutines/channels/Channel;", "", "pendingRequestsCount", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "updateLookupPrefix", "calculateCurPrefix", "", "calculateUpdatedPrefix", "truncatePrefix", "times", "appendPrefix", "text", "syncEditorCaretWithOutputModel", "awaitPrefixUpdated", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.terminal.frontend"})
@ApiStatus.Internal
public final class TerminalLookupPrefixUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel model;
    @NotNull
    private final LookupImpl lookup;
    @NotNull
    private final Channel<Unit> prefixUpdateRequests;
    @NotNull
    private final MutableStateFlow<Integer> pendingRequestsCount;
    @NotNull
    private static final Key<TerminalLookupPrefixUpdater> KEY;

    private TerminalLookupPrefixUpdater(TerminalOutputModel model, LookupImpl lookup, CoroutineScope coroutineScope) {
        this.model = model;
        this.lookup = lookup;
        this.prefixUpdateRequests = ChannelKt.Channel$default((int)Integer.MAX_VALUE, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
        this.pendingRequestsCount = StateFlowKt.MutableStateFlow((Object)0);
        this.model.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalOutputModelListener(){

            @Override
            public void cursorOffsetChanged(TerminalCursorOffsetChangeEvent event) {
                int it;
                Integer nextValue$iv;
                Object prevValue$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MutableStateFlow $this$update$iv = pendingRequestsCount;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = ((Number)prevValue$iv).intValue();
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
                prefixUpdateRequests.trySend-JP2dKIU((Object)Unit.INSTANCE);
            }
        });
        this.model.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalOutputModelListener(){

            @Override
            public void afterContentChanged(TerminalContentChangeEvent event) {
                int it;
                Integer nextValue$iv;
                Object prevValue$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MutableStateFlow $this$update$iv = pendingRequestsCount;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = ((Number)prevValue$iv).intValue();
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
                prefixUpdateRequests.trySend-JP2dKIU((Object)Unit.INSTANCE);
            }
        });
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ TerminalLookupPrefixUpdater this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = TerminalLookupPrefixUpdater.access$getPrefixUpdateRequests$p(this.this$0).iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl18
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        var2_3.next();
                        request = Unit.INSTANCE;
                        this.L$0 = var2_3;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)request);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TerminalLookupPrefixUpdater this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        int it;
                                        Integer nextValue$iv;
                                        Object prevValue$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.updateLookupPrefix();
                                        MutableStateFlow $this$update$iv = this.this$0.pendingRequestsCount;
                                        boolean $i$f$update = false;
                                        do {
                                            prevValue$iv = $this$update$iv.getValue();
                                            it = ((Number)prevValue$iv).intValue();
                                            boolean bl = false;
                                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Boxing.boxInt((int)(it - 1)))));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        request = (Unit)this.L$1;
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl34:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void updateLookupPrefix() {
        block4: {
            this.syncEditorCaretWithOutputModel();
            if (this.lookup.isLookupDisposed()) {
                return;
            }
            String string = this.calculateCurPrefix();
            if (string == null) {
                return;
            }
            String curPrefix = string;
            String newPrefix = this.calculateUpdatedPrefix();
            if (newPrefix == null) {
                this.lookup.hideLookup(false);
                return;
            }
            int commonPrefixLength = StringsKt.commonPrefixWith$default((CharSequence)newPrefix, (CharSequence)curPrefix, (boolean)false, (int)2, null).length();
            int truncateTimes = curPrefix.length() - commonPrefixLength;
            this.truncatePrefix(truncateTimes);
            String string2 = newPrefix.substring(commonPrefixLength, newPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String textToAppend = string2;
            this.appendPrefix(textToAppend);
            if (this.lookup.isLookupDisposed() || truncateTimes <= 0 && !(((CharSequence)textToAppend).length() > 0)) break block4;
            Project project = this.lookup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            TerminalCommandCompletionProcess terminalCommandCompletionProcess = TerminalCommandCompletionService.Companion.getInstance(project).getActiveProcess$intellij_terminal_frontend();
            if (terminalCommandCompletionProcess != null) {
                terminalCommandCompletionProcess.prefixUpdated();
            }
        }
    }

    private final String calculateCurPrefix() {
        LookupElement lookupElement = this.lookup.getCurrentItem();
        if (lookupElement == null) {
            return null;
        }
        LookupElement curItem = lookupElement;
        return this.lookup.itemPattern(curItem);
    }

    private final String calculateUpdatedPrefix() {
        TerminalOffset startOffset = this.model.getStartOffset().plus(this.lookup.getLookupStart());
        TerminalOffset caretOffset = this.model.getCursorOffset();
        if (caretOffset.compareTo(startOffset) < 0) {
            return null;
        }
        return ((Object)this.model.getText(startOffset, caretOffset)).toString();
    }

    private final void truncatePrefix(int times) {
        String curPrefix;
        Project project = this.lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TerminalCommandCompletionProcess terminalCommandCompletionProcess = TerminalCommandCompletionService.Companion.getInstance(project).getActiveProcess$intellij_terminal_frontend();
        boolean preserveSelection = !(terminalCommandCompletionProcess != null ? terminalCommandCompletionProcess.isAutopopupCompletion() : false);
        int hideOffset = this.lookup.getLookupStart();
        int n = 0;
        while (n < times) {
            int it = n++;
            boolean bl = false;
            if (this.lookup.isLookupDisposed()) {
                return;
            }
            this.lookup.truncatePrefix(preserveSelection, hideOffset, false);
        }
        if (!this.lookup.isLookupDisposed() && times > 0 && (curPrefix = this.calculateCurPrefix()) != null && ((CharSequence)curPrefix).length() == 0) {
            this.lookup.hideLookup(false);
            return;
        }
    }

    private final void appendPrefix(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (this.lookup.isLookupDisposed()) {
                return;
            }
            this.lookup.fireBeforeAppendPrefix(c);
            this.lookup.appendPrefix(c, false);
        }
    }

    private final void syncEditorCaretWithOutputModel() {
        if (!this.lookup.isLookupDisposed()) {
            int cursorOffset = TerminalViewImplKt.toRelative(this.model.getCursorOffset(), this.model);
            this.lookup.performGuardedChange(() -> TerminalLookupPrefixUpdater.syncEditorCaretWithOutputModel$lambda$0(this, cursorOffset));
        }
    }

    /*
     * Unable to fully structure code
     */
    @TestOnly
    @Nullable
    public final Object awaitPrefixUpdated(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitPrefixUpdated.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ TerminalLookupPrefixUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitPrefixUpdated((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = YieldKt.yield((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = FlowKt.first((Flow)((Flow)this.pendingRequestsCount), (Function2)((Function2)new Function2<Integer, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ int I$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        int n = this.I$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((it == false ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.I$0 = ((Number)value).intValue();
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(int p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void syncEditorCaretWithOutputModel$lambda$0(TerminalLookupPrefixUpdater this$0, int $cursorOffset) {
        this$0.lookup.getEditor().getCaretModel().moveToOffset($cursorOffset);
    }

    public /* synthetic */ TerminalLookupPrefixUpdater(TerminalOutputModel model, LookupImpl lookup, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(model, lookup, coroutineScope);
    }

    static {
        Key key = Key.create((String)"TerminalLookupPrefixUpdater");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupPrefixUpdater$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/terminal/frontend/view/completion/TerminalLookupPrefixUpdater;", "install", "", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "get", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull TerminalOutputModel outputModel, @NotNull LookupImpl lookup, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            TerminalLookupPrefixUpdater updater = new TerminalLookupPrefixUpdater(outputModel, lookup, coroutineScope, null);
            lookup.putUserData(KEY, (Object)updater);
            JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> Companion.install$lambda$0(lookup, arg_0));
        }

        @TestOnly
        @Nullable
        public final TerminalLookupPrefixUpdater get(@NotNull LookupImpl lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            return (TerminalLookupPrefixUpdater)lookup.getUserData(KEY);
        }

        private static final Unit install$lambda$0(LookupImpl $lookup, Throwable it) {
            $lookup.putUserData(KEY, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

