/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandlerKt;
import com.intellij.terminal.frontend.view.impl.TimedKeyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalKeyListener;", "Ljava/awt/event/KeyAdapter;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "eventsHandler", "Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;)V", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "keyPressed", "handleEvent", "intellij.terminal.frontend"})
final class TerminalKeyListener
extends KeyAdapter {
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalEventsHandler eventsHandler;

    public TerminalKeyListener(@NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalEventsHandler eventsHandler) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        this.settings = settings;
        this.eventsHandler = eventsHandler;
    }

    @Override
    public void keyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handleEvent(e);
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handleEvent(e);
    }

    private final void handleEvent(KeyEvent e) {
        if (this.settings.overrideIdeShortcuts()) {
            return;
        }
        TerminalEventsHandlerKt.handleKeyEvent(this.eventsHandler, new TimedKeyEvent(e, null, 2, null));
        e.consume();
    }
}

