/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.cloud;

import ai.grazie.client.common.SuspendableHTTPClient;
import ai.grazie.client.ktor.GrazieKtorHTTPClient;
import ai.grazie.utils.http.DefaultHttpClientRequestSetup;
import ai.grazie.utils.http.HttpClientRequestSetup;
import com.intellij.grazie.cloud.GrazieHttpClientAdaptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.HttpConfigurable;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.cio.CIO;
import io.ktor.client.engine.cio.CIOEngineConfig;
import io.ktor.client.plugins.DefaultRequest;
import io.ktor.client.plugins.DefaultRequestKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.plugins.logging.LoggingConfig;
import io.ktor.client.plugins.logging.LoggingKt;
import io.ktor.client.request.UtilsKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessageBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/intellij/grazie/cloud/GrazieHttpClientManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "headerLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lastClient", "Lkotlin/Pair;", "Ljava/net/Proxy;", "Lio/ktor/client/HttpClient;", "client", "getClient", "()Lio/ktor/client/HttpClient;", "createKtorClient", "jdkProxy", "instance", "Lai/grazie/client/common/SuspendableHTTPClient;", "getInstance", "()Lai/grazie/client/common/SuspendableHTTPClient;", "withExtendedTimeout", "Lcom/intellij/grazie/cloud/GrazieHttpClientAdaptor;", "getWithExtendedTimeout", "()Lcom/intellij/grazie/cloud/GrazieHttpClientAdaptor;", "prepare", "dispose", "", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nSuspendableGrazieHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendableGrazieHttpClient.kt\ncom/intellij/grazie/cloud/GrazieHttpClientManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n23#2:95\n23#2:96\n*S KotlinDebug\n*F\n+ 1 SuspendableGrazieHttpClient.kt\ncom/intellij/grazie/cloud/GrazieHttpClientManager\n*L\n38#1:95\n82#1:96\n*E\n"})
public final class GrazieHttpClientManager
implements Disposable {
    @NotNull
    private final Logger headerLogger;
    @Nullable
    private Pair<? extends Proxy, HttpClient> lastClient;

    public GrazieHttpClientManager() {
        Logger logger = Logger.getInstance((String)"com.intellij.ml.grazie.pro.http.headers");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.headerLogger = logger;
    }

    private final synchronized HttpClient getClient() {
        HttpConfigurable proxyConfig = HttpConfigurable.getInstance();
        Proxy proxy = proxyConfig.USE_HTTP_PROXY ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.PROXY_HOST, proxyConfig.PROXY_PORT)) : null;
        Pair last = this.lastClient;
        if (last == null || !Intrinsics.areEqual((Object)last.getFirst(), (Object)proxy)) {
            GrazieHttpClientManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GrazieHttpClientManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Using proxy " + proxy);
            this.lastClient = last = new Pair((Object)proxy, (Object)this.createKtorClient(proxy));
        }
        return (HttpClient)last.getSecond();
    }

    private final HttpClient createKtorClient(Proxy jdkProxy) {
        return HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)CIO.INSTANCE), arg_0 -> GrazieHttpClientManager.createKtorClient$lambda$0(jdkProxy, this, arg_0));
    }

    @NotNull
    public final SuspendableHTTPClient getInstance() {
        return this.prepare(this.getClient());
    }

    @NotNull
    public final GrazieHttpClientAdaptor getWithExtendedTimeout() {
        return this.prepare(this.getClient().config(GrazieHttpClientManager::_get_withExtendedTimeout_$lambda$0));
    }

    private final GrazieHttpClientAdaptor prepare(HttpClient client2) {
        HttpClient withProxy = client2.config(GrazieHttpClientManager::prepare$lambda$0);
        return new GrazieHttpClientAdaptor((SuspendableHTTPClient)new GrazieKtorHTTPClient(withProxy, (HttpClientRequestSetup)DefaultHttpClientRequestSetup.INSTANCE));
    }

    public void dispose() {
    }

    private static final Unit createKtorClient$lambda$0$0(Proxy $jdkProxy, CIOEngineConfig $this$engine) {
        Intrinsics.checkNotNullParameter((Object)$this$engine, (String)"$this$engine");
        $this$engine.setProxy($jdkProxy);
        return Unit.INSTANCE;
    }

    private static final Unit createKtorClient$lambda$0$1(GrazieHttpClientManager this$0, LoggingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setLogger(new io.ktor.client.plugins.logging.Logger(this$0){
            final /* synthetic */ GrazieHttpClientManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void log(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                GrazieHttpClientManager.access$getHeaderLogger$p(this.this$0).debug(message);
            }
        });
        $this$install.setLevel(LogLevel.HEADERS);
        return Unit.INSTANCE;
    }

    private static final Unit createKtorClient$lambda$0$2(HttpTimeoutConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        long timeoutMs = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS));
        $this$install.setConnectTimeoutMillis(Long.valueOf(timeoutMs));
        $this$install.setRequestTimeoutMillis(Long.valueOf(timeoutMs));
        $this$install.setSocketTimeoutMillis(Long.valueOf(timeoutMs));
        return Unit.INSTANCE;
    }

    private static final Unit createKtorClient$lambda$0(Proxy $jdkProxy, GrazieHttpClientManager this$0, HttpClientConfig $this$HttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$HttpClient, (String)"$this$HttpClient");
        HttpConfigurable proxyConfig = HttpConfigurable.getInstance();
        if (proxyConfig.USE_HTTP_PROXY) {
            $this$HttpClient.engine(arg_0 -> GrazieHttpClientManager.createKtorClient$lambda$0$0($jdkProxy, arg_0));
        }
        $this$HttpClient.install((HttpClientPlugin)LoggingKt.getLogging(), arg_0 -> GrazieHttpClientManager.createKtorClient$lambda$0$1(this$0, arg_0));
        $this$HttpClient.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), GrazieHttpClientManager::createKtorClient$lambda$0$2);
        return Unit.INSTANCE;
    }

    private static final Unit _get_withExtendedTimeout_$lambda$0$0(HttpTimeoutConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setRequestTimeoutMillis(Long.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS))));
        return Unit.INSTANCE;
    }

    private static final Unit _get_withExtendedTimeout_$lambda$0(HttpClientConfig $this$config) {
        Intrinsics.checkNotNullParameter((Object)$this$config, (String)"$this$config");
        $this$config.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), GrazieHttpClientManager::_get_withExtendedTimeout_$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit prepare$lambda$0$0(String $token, DefaultRequest.DefaultRequestBuilder $this$defaultRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultRequest, (String)"$this$defaultRequest");
        UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$defaultRequest), (String)HttpHeaders.INSTANCE.getProxyAuthorization(), (Object)("Basic " + $token));
        return Unit.INSTANCE;
    }

    private static final Unit prepare$lambda$0(HttpClientConfig $this$config) {
        Intrinsics.checkNotNullParameter((Object)$this$config, (String)"$this$config");
        HttpConfigurable proxyConfig = HttpConfigurable.getInstance();
        if (proxyConfig.USE_HTTP_PROXY && proxyConfig.PROXY_AUTHENTICATION) {
            String proxyLogin = proxyConfig.getProxyLogin();
            String proxyPassword = proxyConfig.getPlainProxyPassword();
            HttpClientConfig $this$thisLogger$iv = $this$config;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HttpClientConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            String string = proxyPassword;
            logger.debug("Using proxy authentication " + proxyLogin + " " + (string != null ? Integer.valueOf(string.length()) : null));
            Base64.Encoder encoder = Base64.getEncoder();
            String string2 = proxyLogin + ":" + proxyPassword;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String token = encoder.encodeToString(byArray);
            DefaultRequestKt.defaultRequest((HttpClientConfig)$this$config, arg_0 -> GrazieHttpClientManager.prepare$lambda$0$0(token, arg_0));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getHeaderLogger$p(GrazieHttpClientManager $this) {
        return $this.headerLogger;
    }
}

