/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.psi.CustomHighlighterTokenType;

public final class MultilineCommentParser
extends PrefixedTokenParser {
    private final char[] myEndDelimiter;

    private MultilineCommentParser(String startDelimiter, String endDelimiter) {
        super(startDelimiter, CustomHighlighterTokenType.MULTI_LINE_COMMENT);
        this.myEndDelimiter = endDelimiter.toCharArray();
    }

    @Override
    protected int getTokenEnd(int position) {
        while (position < this.myEndOffset) {
            int i;
            int pos = position;
            for (i = 0; i < this.myEndDelimiter.length && pos < this.myEndOffset && this.myBuffer.charAt(pos) == this.myEndDelimiter[i]; ++i, ++pos) {
            }
            if (i == this.myEndDelimiter.length) {
                return pos;
            }
            ++position;
        }
        return position;
    }

    public static MultilineCommentParser create(String startDelimiter, String endDelimiter) {
        if (startDelimiter == null || endDelimiter == null) {
            return null;
        }
        String trimmedStart = startDelimiter.trim();
        String trimmedEnd = endDelimiter.trim();
        if (!trimmedStart.isEmpty() && !trimmedEnd.isEmpty()) {
            return new MultilineCommentParser(trimmedStart, trimmedEnd);
        }
        return null;
    }
}

