/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.DiscoveredPluginsList;
import com.intellij.ide.plugins.KotlinK2ModeCompatibilityCheckerKt;
import com.intellij.ide.plugins.NonBundledPluginsAreExplicitlyDisabled;
import com.intellij.ide.plugins.PluginCompatibilityUtils;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependencyImpl;
import com.intellij.ide.plugins.PluginDependencyIsDisabled;
import com.intellij.ide.plugins.PluginDescriptorLoadingResult;
import com.intellij.ide.plugins.PluginHasDuplicateContentModuleDeclaration;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginIsCompatibleOnlyWithIntelliJIDEA;
import com.intellij.ide.plugins.PluginIsIncompatibleWithKotlinMode;
import com.intellij.ide.plugins.PluginIsMarkedBroken;
import com.intellij.ide.plugins.PluginIsMarkedDisabled;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.ide.plugins.PluginsPerProjectConfig;
import com.intellij.ide.plugins.PluginsSourceContext;
import com.intellij.idea.AppMode;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0019\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u000eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070!J\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070!J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010/\u001a\u0004\u0018\u00010\u0012*\u00020\u00072\u0006\u00100\u001a\u00020+H\u0002JG\u00101\u001a\u0004\u0018\u00010\u0012*\u00020\u00072\f\u00102\u001a\b\u0012\u0004\u0012\u000204032)\u00105\u001a%\u0012\u0004\u0012\u00020\u0006\u0012\u0015\u0012\u0013\u0018\u000107\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020\u001706H\u0002J\u0018\u0010;\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0006H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lcom/intellij/ide/plugins/PluginLoadingResult;", "", "<init>", "()V", "incompletePlugins", "Ljava/util/HashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "Lkotlin/collections/HashMap;", "enabledPluginsById", "getPluginsToAttemptLoading", "", "idMap", "duplicateModuleMap", "", "", "pluginErrors", "Ljava/util/LinkedHashMap;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "Lkotlin/collections/LinkedHashMap;", "shadowedBundledIds", "", "hasPluginErrors", "", "getHasPluginErrors", "()Z", "enabledPlugins", "", "getEnabledPlugins", "()Ljava/util/List;", "copyPluginErrors", "copyPluginErrors$intellij_platform_core_impl", "getIncompleteIdMap", "", "getIdMap", "addIncompletePlugin", "", "plugin", "error", "initAndAddAll", "descriptorLoadingResult", "Lcom/intellij/ide/plugins/PluginDescriptorLoadingResult;", "initContext", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "initAndAdd", "descriptor", "overrideExistingIfCompatible", "initialize", "context", "checkCompatibility", "getBuildNumber", "Lkotlin/Function0;", "Lcom/intellij/openapi/util/BuildNumber;", "isPluginBroken", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "version", "checkAndAdd", "id", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginLoadingResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1068#2:195\n1586#2:196\n1661#2,3:197\n1915#2,2:201\n1#3:200\n*S KotlinDebug\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n*L\n37#1:195\n37#1:196\n37#1:197,3\n126#1:201,2\n*E\n"})
public final class PluginLoadingResult {
    @NotNull
    private final HashMap<PluginId, PluginMainDescriptor> incompletePlugins = new HashMap();
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public final HashMap<PluginId, PluginMainDescriptor> enabledPluginsById = new HashMap();
    @NotNull
    private final HashMap<PluginId, PluginMainDescriptor> idMap = new HashMap();
    @JvmField
    @Nullable
    public Map<PluginId, List<PluginMainDescriptor>> duplicateModuleMap;
    @NotNull
    private final LinkedHashMap<PluginId, PluginNonLoadReason> pluginErrors = new LinkedHashMap();
    @VisibleForTesting
    @JvmField
    @NotNull
    public final Set<PluginId> shadowedBundledIds = new HashSet();

    @NotNull
    public final Set<PluginMainDescriptor> getPluginsToAttemptLoading() {
        Collection<PluginMainDescriptor> collection = this.enabledPluginsById.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @TestOnly
    public final boolean getHasPluginErrors() {
        return !this.pluginErrors.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<PluginMainDescriptor> getEnabledPlugins() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<PluginId, PluginMainDescriptor>> set = this.enabledPluginsById.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((PluginId)it.getKey());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((PluginId)it.getKey())));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PluginMainDescriptor)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<PluginId, PluginNonLoadReason> copyPluginErrors$intellij_platform_core_impl() {
        return new LinkedHashMap(this.pluginErrors);
    }

    @NotNull
    public final Map<PluginId, PluginMainDescriptor> getIncompleteIdMap() {
        return this.incompletePlugins;
    }

    @NotNull
    public final Map<PluginId, PluginMainDescriptor> getIdMap() {
        return this.idMap;
    }

    private final void addIncompletePlugin(PluginMainDescriptor plugin, PluginNonLoadReason error) {
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        PluginMainDescriptor existingIncompletePlugin = this.incompletePlugins.putIfAbsent(plugin.getPluginId(), plugin);
        if (existingIncompletePlugin != null && VersionComparatorUtil.compare((String)plugin.getVersion(), (String)existingIncompletePlugin.getVersion()) > 0) {
            ((Map)this.incompletePlugins).put(plugin.getPluginId(), plugin);
            if (error != null) {
                ((Map)this.pluginErrors).put(plugin.getPluginId(), error);
            }
        } else if (error != null) {
            this.pluginErrors.putIfAbsent(plugin.getPluginId(), error);
        }
    }

    public final void initAndAddAll(@NotNull PluginDescriptorLoadingResult descriptorLoadingResult, @NotNull PluginInitializationContext initContext) {
        Intrinsics.checkNotNullParameter((Object)descriptorLoadingResult, (String)"descriptorLoadingResult");
        Intrinsics.checkNotNullParameter((Object)initContext, (String)"initContext");
        for (DiscoveredPluginsList pluginList : descriptorLoadingResult.getDiscoveredPlugins()) {
            for (PluginMainDescriptor descriptor : pluginList.getPlugins()) {
                this.initAndAdd(descriptor, pluginList.getSource() instanceof PluginsSourceContext.SystemPropertyProvided, initContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initAndAdd(PluginMainDescriptor descriptor, boolean overrideExistingIfCompatible, PluginInitializationContext initContext) {
        PluginNonLoadReason pluginNonLoadReason;
        PluginsPerProjectConfig pluginsPerProjectConfig = initContext.getPluginsPerProjectConfig();
        if (pluginsPerProjectConfig != null) {
            PluginsPerProjectConfig conf = pluginsPerProjectConfig;
            boolean bl = false;
            if (conf.isMainProcess() && !initContext.getEssentialPlugins().contains(descriptor.getPluginId())) {
                return;
            }
        }
        if ((pluginNonLoadReason = this.initialize(descriptor, initContext)) != null) {
            void it;
            PluginNonLoadReason pluginNonLoadReason2;
            PluginNonLoadReason error = pluginNonLoadReason;
            boolean bl = false;
            descriptor.setMarkedForLoading(false);
            PluginNonLoadReason pluginNonLoadReason3 = pluginNonLoadReason2 = error;
            PluginMainDescriptor pluginMainDescriptor = descriptor;
            PluginLoadingResult pluginLoadingResult = this;
            boolean bl2 = false;
            boolean bl3 = !(it instanceof PluginIsMarkedDisabled);
            pluginLoadingResult.addIncompletePlugin(pluginMainDescriptor, bl3 ? pluginNonLoadReason2 : null);
            return;
        }
        if (initContext.getRequirePlatformAliasDependencyForLegacyPlugins() && PluginCompatibilityUtils.INSTANCE.isLegacyPluginWithoutPlatformAliasDependencies(descriptor)) {
            this.addIncompletePlugin(descriptor, new PluginIsCompatibleOnlyWithIntelliJIDEA(descriptor));
            return;
        }
        PluginId pluginId = descriptor.getPluginId();
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        PluginMainDescriptor prevDescriptor = this.enabledPluginsById.put(pluginId, descriptor);
        if (prevDescriptor == null) {
            ((Map)this.idMap).put(pluginId, descriptor);
            for (PluginId pluginAlias : descriptor.getPluginAliases()) {
                this.checkAndAdd(descriptor, pluginAlias);
            }
            return;
        }
        if (prevDescriptor.isBundled() || descriptor.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (PluginManagerCore.checkBuildNumberCompatibility(descriptor, initContext.getProductBuildNumber()) == null && (overrideExistingIfCompatible || VersionComparatorUtil.compare((String)descriptor.getVersion(), (String)prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor + " overrides " + prevDescriptor);
            ((Map)this.idMap).put(pluginId, descriptor);
            return;
        }
        ((Map)this.enabledPluginsById).put(pluginId, prevDescriptor);
    }

    private final PluginNonLoadReason initialize(PluginMainDescriptor $this$initialize, PluginInitializationContext context) {
        Iterable $this$forEach$iv = $this$initialize.getContent().modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginContentDescriptor.ModuleItem it = (PluginContentDescriptor.ModuleItem)element$iv;
            boolean bl = false;
            it.requireDescriptor();
        }
        if ($this$initialize.getContent().modules.size() > 1) {
            HashSet<PluginModuleId> duplicates = new HashSet<PluginModuleId>();
            for (PluginContentDescriptor.ModuleItem item : $this$initialize.getContent().modules) {
                if (duplicates.add(item.getModuleId())) continue;
                return new PluginHasDuplicateContentModuleDeclaration($this$initialize, item.getModuleId());
            }
        }
        if (context.isPluginDisabled($this$initialize.getPluginId())) {
            return new PluginIsMarkedDisabled($this$initialize);
        }
        PluginNonLoadReason pluginNonLoadReason = this.checkCompatibility($this$initialize, (Function0<BuildNumber>)((Function0)new PropertyReference0Impl(context){

            public Object get() {
                return ((PluginInitializationContext)this.receiver).getProductBuildNumber();
            }
        }), (Function2<? super PluginId, ? super String, Boolean>)((Function2)new Function2<PluginId, String, Boolean>((Object)context){

            public final Boolean invoke(PluginId p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PluginInitializationContext)this.receiver).isPluginBroken(p0, p1);
            }
        }));
        if (pluginNonLoadReason != null) {
            PluginNonLoadReason it = pluginNonLoadReason;
            boolean bl = false;
            return it;
        }
        for (PluginDependencyImpl dependency : $this$initialize.getPluginDependencies$intellij_platform_core_impl()) {
            if (!context.isPluginDisabled(dependency.getPluginId()) || dependency.isOptional()) continue;
            return new PluginDependencyIsDisabled($this$initialize, dependency.getPluginId(), false);
        }
        for (PluginId pluginDependency : $this$initialize.getModuleDependencies().getPlugins()) {
            if (!context.isPluginDisabled(pluginDependency)) continue;
            return new PluginDependencyIsDisabled($this$initialize, pluginDependency, false);
        }
        return null;
    }

    private final PluginNonLoadReason checkCompatibility(PluginMainDescriptor $this$checkCompatibility, Function0<BuildNumber> getBuildNumber, Function2<? super PluginId, ? super String, Boolean> isPluginBroken) {
        if (KotlinK2ModeCompatibilityCheckerKt.isPluginWhichDependsOnKotlinPluginAndItsIncompatibleWithIt($this$checkCompatibility)) {
            String mode = KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK1Mode() ? CoreBundle.message((String)"plugin.loading.error.k1.mode", (Object[])new Object[0]) : CoreBundle.message((String)"plugin.loading.error.k2.mode", (Object[])new Object[0]);
            return new PluginIsIncompatibleWithKotlinMode($this$checkCompatibility, mode);
        }
        if ($this$checkCompatibility.isBundled()) {
            return null;
        }
        if (AppMode.isDisableNonBundledPlugins()) {
            return new NonBundledPluginsAreExplicitlyDisabled($this$checkCompatibility);
        }
        PluginNonLoadReason pluginNonLoadReason = PluginManagerCore.checkBuildNumberCompatibility($this$checkCompatibility, (BuildNumber)getBuildNumber.invoke());
        if (pluginNonLoadReason != null) {
            PluginNonLoadReason it = pluginNonLoadReason;
            boolean bl = false;
            return it;
        }
        if (((Boolean)isPluginBroken.invoke((Object)$this$checkCompatibility.getPluginId(), (Object)$this$checkCompatibility.getVersion())).booleanValue()) {
            return new PluginIsMarkedBroken($this$checkCompatibility);
        }
        return null;
    }

    private final void checkAndAdd(PluginMainDescriptor descriptor, PluginId id) {
        Map<PluginId, List<PluginMainDescriptor>> map = this.duplicateModuleMap;
        if (map != null && (map = map.get(id)) != null) {
            Map<PluginId, List<PluginMainDescriptor>> duplicates = map;
            boolean bl = false;
            duplicates.add(descriptor);
            return;
        }
        PluginMainDescriptor pluginMainDescriptor = this.idMap.put(id, descriptor);
        if (pluginMainDescriptor == null) {
            return;
        }
        PluginMainDescriptor existingDescriptor = pluginMainDescriptor;
        this.idMap.remove(id);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap();
        }
        ArrayList<PluginMainDescriptor> list = new ArrayList<PluginMainDescriptor>(2);
        list.add(existingDescriptor);
        list.add(descriptor);
        Map<PluginId, List<PluginMainDescriptor>> map2 = this.duplicateModuleMap;
        Intrinsics.checkNotNull(map2);
        map2.put(id, list);
    }
}

