/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShortestPathFinder<Node> {
    private final InboundSemiGraph<Node> myGraph;

    public ShortestPathFinder(Graph<Node> graph) {
        this.myGraph = graph;
    }

    public ShortestPathFinder(InboundSemiGraph<Node> graph) {
        this.myGraph = graph;
    }

    @Nullable
    public List<Node> findPath(Node start, Node finish) {
        HashMap nextNodes = new HashMap();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.addLast(finish);
        boolean found = false;
        while (!queue.isEmpty()) {
            Object node = queue.removeFirst();
            if (node.equals(start)) {
                found = true;
                break;
            }
            Iterator in = this.myGraph.getIn(node);
            while (in.hasNext()) {
                Object prev = in.next();
                if (nextNodes.containsKey(prev)) continue;
                nextNodes.put(prev, node);
                queue.addLast(prev);
            }
        }
        if (!found) {
            return null;
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Object current = start;
        while (!current.equals(finish)) {
            path.add(current);
            current = nextNodes.get(current);
        }
        path.add(finish);
        return path;
    }
}

