/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.IndexingBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0082\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/module/impl/scopes/ModuleContentScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSearchInModuleContent", "aModule", "isSearchInLibraries", "equals", "other", "", "calcHashCode", "", "toString", "", "getDisplayName", "intellij.platform.analysis.impl"})
public final class ModuleContentScope
extends GlobalSearchScope {
    @NotNull
    private final Module module;
    @NotNull
    private final ProjectFileIndex projectFileIndex;

    public ModuleContentScope(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(module.getProject());
        this.module = module;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.projectFileIndex = projectFileIndex;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)this.projectFileIndex.getModuleForFile(file), (Object)this.module);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return Intrinsics.areEqual((Object)aModule, (Object)this.module);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(@Nullable Object other) {
        ModuleContentScope moduleContentScope = other instanceof ModuleContentScope ? (ModuleContentScope)((Object)other) : null;
        return Intrinsics.areEqual((Object)(moduleContentScope != null ? moduleContentScope.module : null), (Object)this.module);
    }

    protected int calcHashCode() {
        return this.module.hashCode();
    }

    @NotNull
    public String toString() {
        return "ModuleContentScope{module=" + this.module.getName() + "}";
    }

    @NotNull
    public String getDisplayName() {
        Object[] objectArray = new Object[]{this.module.getName()};
        String string = IndexingBundle.message((String)"search.scope.module", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

