/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassLetter;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigConvertToPlainPatternQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.editorconfig.backend"})
public final class EditorConfigConvertToPlainPatternQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.charclass.convert.to.plain.pattern.description", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        EditorConfigCharClassPattern editorConfigCharClassPattern = psiElement instanceof EditorConfigCharClassPattern ? (EditorConfigCharClassPattern)psiElement : null;
        if (editorConfigCharClassPattern == null) {
            return;
        }
        EditorConfigCharClassPattern charClass = editorConfigCharClassPattern;
        EditorConfigHeader header = charClass.getHeader();
        List list = charClass.getCharClassLetterList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCharClassLetterList(...)");
        EditorConfigCharClassLetter letter = (EditorConfigCharClassLetter)CollectionsKt.first((List)list);
        int headerOffset = header.getTextOffset();
        TextRange range = charClass.getTextRange();
        IntRange actualRange = RangesKt.until((int)(range.getStartOffset() - headerOffset), (int)(range.getEndOffset() - headerOffset));
        String text = header.getText();
        Intrinsics.checkNotNull((Object)text);
        String string = text;
        String string2 = letter.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        CharSequence charSequence = string2;
        String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (IntRange)actualRange, (CharSequence)charSequence)).toString();
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigHeader newHeader = factory.createHeader((CharSequence)newText);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> EditorConfigConvertToPlainPatternQuickFix.applyFix$lambda$0(header, newHeader));
    }

    private static final void applyFix$lambda$0(EditorConfigHeader $header, EditorConfigHeader $newHeader) {
        $header.replace((PsiElement)$newHeader);
    }
}

