/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001d\u001a\u00020\u0012H\u0016R$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0005R!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u001a\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/ContributedConfigurationBase;", "typeId", "", "<init>", "(Ljava/lang/String;)V", "value", "uuid", "getUuid", "()Ljava/lang/String;", "setUuid$intellij_platform_execution", "runtimes", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "Lcom/intellij/execution/target/LanguageRuntimeType;", "getRuntimes", "()Lcom/intellij/execution/target/ContributedConfigurationsList;", "addLanguageRuntime", "", "runtime", "removeLanguageRuntime", "", "createEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "project", "Lcom/intellij/openapi/project/Project;", "projectRootOnTarget", "getProjectRootOnTarget", "setProjectRootOnTarget", "validateConfiguration", "TargetBaseState", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nTargetEnvironmentConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetEnvironmentConfiguration.kt\ncom/intellij/execution/target/TargetEnvironmentConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1915#2,2:66\n*S KotlinDebug\n*F\n+ 1 TargetEnvironmentConfiguration.kt\ncom/intellij/execution/target/TargetEnvironmentConfiguration\n*L\n54#1:66,2\n*E\n"})
public abstract class TargetEnvironmentConfiguration
extends ContributedConfigurationBase {
    @NotNull
    private String uuid;
    @NotNull
    private final ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<?>> runtimes;

    public TargetEnvironmentConfiguration(@NotNull String typeId) {
        Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
        super(typeId, TargetEnvironmentType.EXTENSION_NAME);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.uuid = string;
        this.runtimes = new ContributedConfigurationsList(LanguageRuntimeType.EXTENSION_NAME);
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    public final void setUuid$intellij_platform_execution(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.uuid = string;
    }

    @NotNull
    public final ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<?>> getRuntimes() {
        return this.runtimes;
    }

    public final void addLanguageRuntime(@NotNull LanguageRuntimeConfiguration runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtimes.addConfig((LanguageRuntimeConfiguration)((ContributedConfigurationBase)runtime));
    }

    public final boolean removeLanguageRuntime(@NotNull LanguageRuntimeConfiguration runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        return this.runtimes.removeConfig((LanguageRuntimeConfiguration)((ContributedConfigurationBase)runtime));
    }

    @NotNull
    public final TargetEnvironmentRequest createEnvironmentRequest(@Nullable Project project) {
        return ((TargetEnvironmentType)TargetEnvironmentConfigurationKt.getTargetType(this)).createEnvironmentRequest(project, (TargetEnvironmentConfiguration)this);
    }

    @NotNull
    public abstract String getProjectRootOnTarget();

    public abstract void setProjectRootOnTarget(@NotNull String var1);

    public void validateConfiguration() throws RuntimeConfigurationException {
        List<LanguageRuntimeConfiguration> $this$validateConfiguration_u24lambda_u240 = this.runtimes.resolvedConfigs();
        boolean bl = false;
        if ($this$validateConfiguration_u24lambda_u240.isEmpty()) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message("TargetEnvironmentConfiguration.error.language.runtime.not.configured", new Object[0]));
        }
        Iterable $this$forEach$iv = $this$validateConfiguration_u24lambda_u240;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageRuntimeConfiguration it = (LanguageRuntimeConfiguration)element$iv;
            boolean bl2 = false;
            it.validateConfiguration();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentConfiguration$TargetBaseState;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "uuid", "getUuid", "()Ljava/lang/String;", "setUuid", "(Ljava/lang/String;)V", "uuid$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.execution"})
    public static abstract class TargetBaseState
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty uuid$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);

        @Nullable
        public final String getUuid() {
            return (String)this.uuid$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setUuid(@Nullable String string) {
            this.uuid$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TargetBaseState.class, "uuid", "getUuid()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

