/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.DataValidators;
import com.intellij.internal.inspector.components.DataContextDialogKt;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a4\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"equalData", "", "o1", "", "o2", "level", "", "visited", "", "isSpecialContextComponentOnlyKey", "key", "Lcom/intellij/openapi/actionSystem/DataKey;", "getKeyPresentation", "", "overridden", "getValuePresentation", "value", "getClassPresentation", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nDataContextDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataContextDialog.kt\ncom/intellij/internal/inspector/components/DataContextDialogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public final class DataContextDialogKt {
    private static final boolean equalData(Object o1, Object o2, int level, Set<Object> visited) {
        boolean bl;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (level > 10) {
            Set<Object> set = visited;
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"com/intellij/internal/inspector/components/DataContextDialogKt$equalData$P", "", "o1", "o2", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getO1", "()Ljava/lang/Object;", "getO2", "equals", "", "other", "hashCode", "", "intellij.platform.ide.ui.inspector"})
            public final class P {
                private final Object o1;
                private final Object o2;
                final /* synthetic */ Object $o1;
                final /* synthetic */ Object $o2;

                public P(Object $o1, Object $o2, Object o1, Object o2) {
                    Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                    this.$o1 = $o1;
                    this.$o2 = $o2;
                    this.o1 = o1;
                    this.o2 = o2;
                }

                public final Object getO1() {
                    return this.o1;
                }

                public final Object getO2() {
                    return this.o2;
                }

                public boolean equals(Object other) {
                    return other instanceof P && this.$o1 == ((P)other).o1 && this.$o2 == ((P)other).o2;
                }

                public int hashCode() {
                    Object object = this.$o1;
                    Object object2 = this.$o2;
                    return (object != null ? object.hashCode() : 0) + (object2 != null ? object2.hashCode() : 0) * 31;
                }
            }
            bl = set != null ? set.contains(new P(o1, o2, o1, o2)) : false;
        } else if (Comparing.equal((Object)o1, (Object)o2)) {
            bl = true;
        } else if (o1 instanceof Object[] && o2 instanceof Object[]) {
            bl = DataContextDialogKt.equalData(ArraysKt.toList((Object[])((Object[])o1)), ArraysKt.toList((Object[])((Object[])o2)), level + 1, DataContextDialogKt.equalData$set(visited, o1, o2));
        } else if (o1 instanceof Reference && o2 instanceof Reference) {
            bl = Comparing.equal(((Reference)o1).get(), ((Reference)o2).get());
        } else if (o1 instanceof Collection && o2 instanceof Collection) {
            if (((Collection)o1).size() != ((Collection)o2).size()) {
                return false;
            }
            Iterator it1 = ((Collection)o1).iterator();
            Iterator it2 = ((Collection)o2).iterator();
            while (it1.hasNext()) {
                if (DataContextDialogKt.equalData(it1.next(), it2.next(), level + 1, DataContextDialogKt.equalData$set(visited, o1, o2))) continue;
                return false;
            }
            bl = true;
        } else if (!Intrinsics.areEqual(c1, c2)) {
            bl = false;
        } else if (o1 instanceof JBIterable && o2 instanceof JBIterable) {
            bl = DataContextDialogKt.equalData(((JBIterable)o1).toList(), ((JBIterable)o2).toList(), level + 1, DataContextDialogKt.equalData$set(visited, o1, o2));
        } else {
            for (Field field : ReflectionUtil.collectFields(c1)) {
                Object o22;
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object o11 = field.get(o1);
                if (DataContextDialogKt.equalData(o11, o22 = field.get(o2), level + 1, DataContextDialogKt.equalData$set(visited, o1, o2))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean isSpecialContextComponentOnlyKey(DataKey<?> key) {
        return key == PlatformCoreDataKeys.CONTEXT_COMPONENT || key == PlatformCoreDataKeys.IS_MODAL_CONTEXT || key == PlatformDataKeys.MODALITY_STATE || key == PlatformDataKeys.SPEED_SEARCH_TEXT || key == PlatformDataKeys.SPEED_SEARCH_COMPONENT;
    }

    private static final String getKeyPresentation(String key, boolean overridden) {
        return overridden ? "*OVERRIDDEN* " + key : key;
    }

    private static final String getValuePresentation(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Object[]) {
            String string = Arrays.toString((Object[])value);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        } else if (object2 instanceof DataManagerImpl.KeyedDataProvider) {
            String string;
            String string2 = value.getClass().getSimpleName();
            int n = ((DataManagerImpl.KeyedDataProvider)value).getMap().size();
            DataProvider dataProvider = ((DataManagerImpl.KeyedDataProvider)value).getGeneric();
            if (dataProvider != null) {
                DataProvider dataProvider2 = dataProvider;
                int n2 = n;
                String string3 = string2;
                boolean bl = false;
                String string4 = " + generic";
                string2 = string3;
                n = n2;
                string = string4;
            } else {
                string = "";
            }
            object = string2 + "(" + n + " providers)" + string;
        } else {
            object = object2 instanceof CompositeDataProvider ? value.getClass().getSimpleName() + "(" + ((CompositeDataProvider)value).getDataProviders().size() + " providers)" : value.toString();
        }
        return object;
    }

    private static final String getClassPresentation(Object value) {
        Object object;
        String str;
        Object source;
        DataValidators.SourceWrapper sourceWrapper = value instanceof DataValidators.SourceWrapper ? (DataValidators.SourceWrapper)value : null;
        Object object2 = source = sourceWrapper != null ? sourceWrapper.unwrapSource() : null;
        if (source != null && source != value) {
            return DataContextDialogKt.getClassPresentation(source);
        }
        if (value instanceof CompositeDataProvider) {
            List list2 = ((CompositeDataProvider)value).getDataProviders();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataProviders(...)");
            return CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, DataContextDialogKt::getClassPresentation$lambda$0, (int)31, null);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isAnonymousClass()) {
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            v4 = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) + ": " + clazz.getSuperclass().getSimpleName();
        } else if (clazz.isHidden()) {
            String string = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            String it = StringsKt.substringBefore$default((String)string, (String)"/", null, (int)2, null);
            boolean bl = false;
            v4 = StringsKt.endsWith$default((String)it, (String)"Lambda", (boolean)false, (int)2, null) ? it : it + "/-";
        } else {
            v4 = str = clazz.getSimpleName();
        }
        if (value instanceof Object[]) {
            Intrinsics.checkNotNull((Object)str);
            object = StringsKt.substringBeforeLast$default((String)str, (String)"[", null, (int)2, null) + "[" + ((Object[])value).length + "]";
        } else {
            Intrinsics.checkNotNull((Object)str);
            object = str;
        }
        return object;
    }

    private static final Set<Object> equalData$set(Set<Object> $visited, Object $o1, Object $o2) {
        Set set;
        Set set2 = $visited;
        if (set2 == null) {
            set2 = new HashSet();
        }
        Set $this$equalData_u24set_u24lambda_u240 = set = set2;
        boolean bl = false;
        Object object = $o1;
        Intrinsics.checkNotNull((Object)object);
        Object object2 = $o2;
        Intrinsics.checkNotNull((Object)object2);
        $this$equalData_u24set_u24lambda_u240.add(new P($o1, $o2, object, object2));
        return set;
    }

    private static final CharSequence getClassPresentation$lambda$0(DataProvider it) {
        Intrinsics.checkNotNull((Object)it);
        return DataContextDialogKt.getClassPresentation(it);
    }

    public static final /* synthetic */ String access$getKeyPresentation(String key, boolean overridden) {
        return DataContextDialogKt.getKeyPresentation(key, overridden);
    }

    public static final /* synthetic */ boolean access$isSpecialContextComponentOnlyKey(DataKey key) {
        return DataContextDialogKt.isSpecialContextComponentOnlyKey(key);
    }

    public static final /* synthetic */ boolean access$equalData(Object o1, Object o2, int level, Set visited) {
        return DataContextDialogKt.equalData(o1, o2, level, visited);
    }

    public static final /* synthetic */ String access$getValuePresentation(Object value) {
        return DataContextDialogKt.getValuePresentation(value);
    }

    public static final /* synthetic */ String access$getClassPresentation(Object value) {
        return DataContextDialogKt.getClassPresentation(value);
    }
}

