/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ignore.actions.CreateNewIgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroupKt;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d*\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0002J+\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010'\u001a\u00020!H\u0002J\u0014\u0010(\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b**\u00020+H\u0082\u0002J\u0012\u0010,\u001a\u00070\u000f\u00a2\u0006\u0002\b-*\u00020+H\u0082\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "ignoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createAdditionalActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "selectedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "unversionedFiles", "createActionsFor", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "actionPerformed", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "filterSelectedFiles", "files", "findSuitableIgnoreFiles", "", "file", "toActions", "additionalActionsSize", "", "createNewIgnoreFileAction", "toTextRepresentation", "", "Lorg/jetbrains/annotations/Nls;", "projectDir", "size", "component1", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/vcs/VcsRoot;", "component2", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIgnoreFileActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFileActionGroup.kt\ncom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,165:1\n1586#2:166\n1661#2,3:167\n832#2:170\n862#2,2:171\n777#2:175\n873#2,2:176\n777#2:178\n873#2,2:179\n1586#2:181\n1661#2,3:182\n37#3,2:173\n*S KotlinDebug\n*F\n+ 1 IgnoreFileActionGroup.kt\ncom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup\n*L\n53#1:166\n53#1:167,3\n53#1:170\n53#1:171,2\n99#1:175\n99#1:176,2\n105#1:178\n105#1:179,2\n112#1:181\n112#1:182,3\n93#1:173,2\n*E\n"})
public class IgnoreFileActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private final IgnoreFileType ignoreFileType;

    public IgnoreFileActionGroup(@NotNull IgnoreFileType ignoreFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)ignoreFileType), (String)"ignoreFileType");
        Object[] objectArray = new Object[]{ignoreFileType.getIgnoreLanguage().getFilename()};
        Supplier supplier = VcsBundle.messagePointer((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
        objectArray = new Object[]{ignoreFileType.getIgnoreLanguage().getFilename()};
        super(supplier, VcsBundle.messagePointer((String)"vcs.add.to.ignore.file.action.group.description", (Object[])objectArray), () -> IgnoreFileActionGroup._init_$lambda$0(ignoreFileType));
        this.ignoreFileType = ignoreFileType;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    protected List<AnAction> createAdditionalActions(@NotNull Project project, @NotNull List<? extends VirtualFile> selectedFiles, @NotNull List<? extends VirtualFile> unversionedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnAction> createActionsFor(AnActionEvent e) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        List<VirtualFile> selectedFiles = IgnoreFileActionKt.getSelectedFiles(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        List list = ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List unversionedFiles = list;
        if (unversionedFiles.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = this.filterSelectedFiles(project, selectedFiles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.findSuitableIgnoreFiles(project, (VirtualFile)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean bl = false;
            if (p0.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ignoreFiles = (List)destination$iv$iv;
        HashSet resultedIgnoreFiles = CollectionsKt.toHashSet((Iterable)CollectionsKt.flatten((Iterable)ignoreFiles));
        for (Collection files : ignoreFiles) {
            resultedIgnoreFiles.retainAll(files);
        }
        List actions = new ArrayList();
        List<AnAction> additionalActions = this.createAdditionalActions(project, selectedFiles, unversionedFiles);
        if (!((Collection)resultedIgnoreFiles).isEmpty()) {
            CollectionsKt.addAll((Collection)actions, (Iterable)this.toActions(resultedIgnoreFiles, project, additionalActions.size()));
        } else {
            CollectionsKt.addAll((Collection)actions, (Iterable)CollectionsKt.listOfNotNull((Object)this.createNewIgnoreFileAction(project, selectedFiles)));
        }
        if (!((Collection)additionalActions).isEmpty()) {
            CollectionsKt.addAll((Collection)actions, (Iterable)additionalActions);
        }
        return actions;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        List<AnAction> actions = this.createActionsFor(e);
        presentation2.setPopupGroup(actions.size() > 1);
        presentation2.setPerformGroup(actions.size() == 1);
        e.getPresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)e.getPresentation().isPerformGroup());
        presentation2.setEnabledAndVisible(!((Collection)actions).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AnAction anAction = (AnAction)CollectionsKt.singleOrNull(this.createActionsFor(e));
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        action.actionPerformed(e);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ActionGroup.EMPTY_ARRAY;
        }
        Collection $this$toTypedArray$iv = this.createActionsFor(e);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> filterSelectedFiles(Project project, List<? extends VirtualFile> files) {
        void $this$filterTo$iv$iv;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(vcsManager.getVcsFor(file) != null && !changeListManager2.isIgnoredFile(file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> findSuitableIgnoreFiles(Project project, VirtualFile file) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        VirtualFile fileParent = file.getParent();
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)this.ignoreFileType), (GlobalSearchScope)ProjectScope.getProjectScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)fileParent, (Object)it.getParent()) || fileParent != null && it.getParent() != null && VfsUtil.isAncestor((VirtualFile)it.getParent(), (VirtualFile)fileParent, (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AnAction> toActions(Collection<? extends VirtualFile> $this$toActions, Project project, int additionalActionsSize) {
        void $this$mapTo$iv$iv;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        Iterable $this$map$iv = $this$toActions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Presentation presentation;
            void file;
            IgnoreFileAction ignoreFileAction;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IgnoreFileAction $this$toActions_u24lambda_u240_u240 = ignoreFileAction = new IgnoreFileAction((VirtualFile)file);
            boolean bl2 = false;
            Presentation $this$toActions_u24lambda_u240_u240_u240 = presentation = $this$toActions_u24lambda_u240_u240.getTemplatePresentation();
            boolean bl3 = false;
            $this$toActions_u24lambda_u240_u240_u240.setIcon(this.ignoreFileType.getIcon());
            $this$toActions_u24lambda_u240_u240_u240.setText(this.toTextRepresentation((VirtualFile)file, project, projectDir, $this$toActions.size() + additionalActionsSize));
            collection.add(ignoreFileAction);
        }
        return (List)destination$iv$iv;
    }

    private final AnAction createNewIgnoreFileAction(Project project, List<? extends VirtualFile> selectedFiles) {
        Presentation presentation;
        CreateNewIgnoreFileAction createNewIgnoreFileAction;
        String string = this.ignoreFileType.getIgnoreLanguage().getFilename();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilename(...)");
        String filename = string;
        VcsRoot vcsRoot = IgnoreFileActionGroupKt.access$getCommonIgnoreFileRoot(selectedFiles, project);
        if (vcsRoot == null) {
            return null;
        }
        VcsRoot vcsRoot2 = vcsRoot;
        AbstractVcs rootVcs = this.component1(vcsRoot2);
        VirtualFile commonIgnoreFileRoot = this.component2(vcsRoot2);
        if (rootVcs == null) {
            return null;
        }
        if (commonIgnoreFileRoot.findChild(filename) != null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(rootVcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        if (!Intrinsics.areEqual((Object)ignoredFileContentProvider2.getFileName(), (Object)filename)) {
            return null;
        }
        CreateNewIgnoreFileAction $this$createNewIgnoreFileAction_u24lambda_u240 = createNewIgnoreFileAction = new CreateNewIgnoreFileAction(filename, commonIgnoreFileRoot);
        boolean bl = false;
        Presentation $this$createNewIgnoreFileAction_u24lambda_u240_u240 = presentation = $this$createNewIgnoreFileAction_u24lambda_u240.getTemplatePresentation();
        boolean bl2 = false;
        $this$createNewIgnoreFileAction_u24lambda_u240_u240.setIcon(this.ignoreFileType.getIcon());
        Object[] objectArray = new Object[]{filename};
        $this$createNewIgnoreFileAction_u24lambda_u240_u240.setText(VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray));
        return (AnAction)createNewIgnoreFileAction;
    }

    private final String toTextRepresentation(VirtualFile $this$toTextRepresentation, Project project, VirtualFile projectDir, int size) {
        if (size == 1) {
            Object[] objectArray = new Object[]{this.ignoreFileType.getIgnoreLanguage().getFilename()};
            String string = VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        VirtualFile virtualFile = projectDir;
        if (virtualFile == null && (virtualFile = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)$this$toTextRepresentation)) == null) {
            String string = $this$toTextRepresentation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        VirtualFile projectRootOrVcsRoot = virtualFile;
        String string = VfsUtil.getRelativePath((VirtualFile)$this$toTextRepresentation, (VirtualFile)projectRootOrVcsRoot);
        if (string == null) {
            String string2 = $this$toTextRepresentation.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    private final AbstractVcs component1(VcsRoot $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getVcs();
    }

    private final VirtualFile component2(VcsRoot $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        VirtualFile virtualFile = $this$component2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
        return virtualFile;
    }

    private static final Icon _init_$lambda$0(IgnoreFileType $ignoreFileType) {
        return $ignoreFileType.getIcon();
    }
}

