/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diagnostic.Checks;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerChangesTreeTracker;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessorKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0002 !B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "editorViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "handler", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "updateWhileShown", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/diff/impl/DiffEditorViewer;Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;Z)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "getEditorViewer", "()Lcom/intellij/diff/impl/DiffEditorViewer;", "getHandler", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "getUpdateWhileShown", "()Z", "isCombinedViewer", "isForceKeepCurrentFileWhileFocused", "updatePreviewQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "track", "", "updatePreviewLater", "updateType", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$UpdateType;", "updatePreview", "refreshPreview", "clearPreview", "PreviewUpdate", "UpdateType", "intellij.platform.vcs.impl"})
public class TreeHandlerChangesTreeTracker {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final DiffEditorViewer editorViewer;
    @NotNull
    private final ChangesTreeDiffPreviewHandler handler;
    private final boolean updateWhileShown;
    private final boolean isCombinedViewer;
    private final boolean isForceKeepCurrentFileWhileFocused;
    @NotNull
    private final MergingUpdateQueue updatePreviewQueue;

    /*
     * WARNING - void declaration
     */
    public TreeHandlerChangesTreeTracker(@NotNull ChangesTree tree, @NotNull DiffEditorViewer editorViewer, @NotNull ChangesTreeDiffPreviewHandler handler, boolean updateWhileShown) {
        boolean bl;
        void $this$updatePreviewQueue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)editorViewer, (String)"editorViewer");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.tree = tree;
        this.editorViewer = editorViewer;
        this.handler = handler;
        this.updateWhileShown = updateWhileShown;
        this.isCombinedViewer = this.editorViewer instanceof CombinedDiffComponentProcessor;
        this.isForceKeepCurrentFileWhileFocused = this.editorViewer instanceof ChangeViewDiffRequestProcessor && ((ChangeViewDiffRequestProcessor)this.editorViewer).forceKeepCurrentFileWhileFocused();
        Object object = mergingUpdateQueue = new MergingUpdateQueue("TreeHandlerChangesTreeTracker", 100, true, this.editorViewer.getComponent(), (Disposable)this.editorViewer.getDisposable(), null, false, 96, null);
        TreeHandlerChangesTreeTracker treeHandlerChangesTreeTracker = this;
        boolean bl2 = false;
        $this$updatePreviewQueue_u24lambda_u240.setRestartTimerOnAdd(true);
        treeHandlerChangesTreeTracker.updatePreviewQueue = mergingUpdateQueue;
        boolean bl3 = bl = this.editorViewer instanceof CombinedDiffComponentProcessor || this.editorViewer instanceof ChangeViewDiffRequestProcessor;
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
    }

    public /* synthetic */ TreeHandlerChangesTreeTracker(ChangesTree changesTree, DiffEditorViewer diffEditorViewer, ChangesTreeDiffPreviewHandler changesTreeDiffPreviewHandler, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(changesTree, diffEditorViewer, changesTreeDiffPreviewHandler, bl);
    }

    @NotNull
    protected final ChangesTree getTree() {
        return this.tree;
    }

    @NotNull
    protected final DiffEditorViewer getEditorViewer() {
        return this.editorViewer;
    }

    @NotNull
    protected final ChangesTreeDiffPreviewHandler getHandler() {
        return this.handler;
    }

    protected final boolean getUpdateWhileShown() {
        return this.updateWhileShown;
    }

    public void track() {
        CheckedDisposable disposable = this.editorViewer.getDisposable();
        this.tree.addSelectionListener(() -> TreeHandlerChangesTreeTracker.track$lambda$0(this), (Disposable)disposable);
        PropertyChangeListener changeListener = arg_0 -> TreeHandlerChangesTreeTracker.track$lambda$1(this, arg_0);
        this.tree.addPropertyChangeListener("model", changeListener);
        Disposer.register((Disposable)((Disposable)disposable), () -> TreeHandlerChangesTreeTracker.track$lambda$2(this, changeListener));
        if (this.isForceKeepCurrentFileWhileFocused) {
            FocusAdapter focusListener2 = new FocusAdapter(this){
                final /* synthetic */ TreeHandlerChangesTreeTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(FocusEvent e) {
                    this.this$0.updatePreviewLater(UpdateType.ON_SELECTION_CHANGE);
                }
            };
            this.tree.addFocusListener((FocusListener)focusListener2);
            Disposer.register((Disposable)((Disposable)disposable), () -> TreeHandlerChangesTreeTracker.track$lambda$3(this, focusListener2));
        }
        if (this.updateWhileShown) {
            DiffUtil.installShowNotifyListener((JComponent)this.editorViewer.getComponent(), (Activatable)new Activatable(this){
                final /* synthetic */ TreeHandlerChangesTreeTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                public void showNotify() {
                    TreeHandlerChangesTreeTracker.access$updatePreview(this.this$0, UpdateType.FULL);
                    TreeHandlerChangesTreeTracker.access$getUpdatePreviewQueue$p(this.this$0).cancelAllUpdates();
                }

                public void hideNotify() {
                    TreeHandlerChangesTreeTracker.access$getUpdatePreviewQueue$p(this.this$0).cancelAllUpdates();
                }
            });
        } else {
            this.updatePreview(UpdateType.FULL);
        }
    }

    public final void updatePreviewLater(@NotNull UpdateType updateType) {
        Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
        this.updatePreviewQueue.queue((Update)new PreviewUpdate(updateType));
    }

    private final void updatePreview(UpdateType updateType) {
        boolean state;
        boolean bl = state = !this.updateWhileShown || UIUtil.isShowing((Component)this.editorViewer.getComponent());
        if (state) {
            this.refreshPreview(updateType);
        } else {
            this.clearPreview();
        }
    }

    private final void refreshPreview(UpdateType updateType) {
        if (this.editorViewer.getDisposable().isDisposed()) {
            return;
        }
        DiffEditorViewer diffEditorViewer = this.editorViewer;
        if (diffEditorViewer instanceof CombinedDiffComponentProcessor) {
            boolean onlyBlockSelection = updateType == UpdateType.ON_SELECTION_CHANGE;
            TreeHandlerDiffRequestProcessorKt.access$refreshCombinedDiffProcessor(this.tree, (CombinedDiffComponentProcessor)this.editorViewer, this.handler, onlyBlockSelection);
        } else if (diffEditorViewer instanceof ChangeViewDiffRequestProcessor) {
            boolean fromModelRefresh = updateType == UpdateType.ON_MODEL_CHANGE;
            ((ChangeViewDiffRequestProcessor)this.editorViewer).refresh(fromModelRefresh);
        } else {
            Checks.fail((Object)this.editorViewer);
        }
    }

    private final void clearPreview() {
        if (this.editorViewer.getDisposable().isDisposed()) {
            return;
        }
        DiffEditorViewer diffEditorViewer = this.editorViewer;
        if (diffEditorViewer instanceof CombinedDiffComponentProcessor) {
            ((CombinedDiffComponentProcessor)this.editorViewer).cleanBlocks();
        } else if (diffEditorViewer instanceof ChangeViewDiffRequestProcessor) {
            ((ChangeViewDiffRequestProcessor)this.editorViewer).clear();
        } else {
            Checks.fail((Object)this.editorViewer);
        }
    }

    private static final void track$lambda$0(TreeHandlerChangesTreeTracker this$0) {
        if (this$0.tree.isModelUpdateInProgress()) {
            this$0.updatePreviewLater(UpdateType.ON_MODEL_CHANGE);
        } else {
            this$0.updatePreviewLater(UpdateType.ON_SELECTION_CHANGE);
        }
    }

    private static final void track$lambda$1(TreeHandlerChangesTreeTracker this$0, PropertyChangeEvent it) {
        this$0.updatePreviewLater(UpdateType.ON_MODEL_CHANGE);
    }

    private static final void track$lambda$2(TreeHandlerChangesTreeTracker this$0, PropertyChangeListener $changeListener) {
        this$0.tree.removePropertyChangeListener("model", $changeListener);
    }

    private static final void track$lambda$3(TreeHandlerChangesTreeTracker this$0, track.focusListener.1 $focusListener) {
        this$0.tree.removeFocusListener((FocusListener)$focusListener);
    }

    public static final /* synthetic */ MergingUpdateQueue access$getUpdatePreviewQueue$p(TreeHandlerChangesTreeTracker $this) {
        return $this.updatePreviewQueue;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$PreviewUpdate;", "Lcom/intellij/util/ui/update/Update;", "updateType", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$UpdateType;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker;Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$UpdateType;)V", "getUpdateType", "()Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$UpdateType;", "run", "", "canEat", "", "eatenUpdate", "intellij.platform.vcs.impl"})
    private final class PreviewUpdate
    extends Update {
        @NotNull
        private final UpdateType updateType;

        public PreviewUpdate(UpdateType updateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
            super((Object)updateType, false, 0, 6, null);
            this.updateType = updateType;
        }

        @NotNull
        public final UpdateType getUpdateType() {
            return this.updateType;
        }

        public void run() {
            TreeHandlerChangesTreeTracker.this.updatePreview(this.updateType);
        }

        public boolean canEat(@NotNull Update eatenUpdate) {
            Intrinsics.checkNotNullParameter((Object)eatenUpdate, (String)"eatenUpdate");
            if (!(eatenUpdate instanceof PreviewUpdate)) {
                return false;
            }
            if (this.updateType == ((PreviewUpdate)eatenUpdate).updateType) {
                return true;
            }
            if (this.updateType == UpdateType.FULL) {
                return true;
            }
            if (TreeHandlerChangesTreeTracker.this.isCombinedViewer) {
                return this.updateType == UpdateType.ON_MODEL_CHANGE && ((PreviewUpdate)eatenUpdate).updateType == UpdateType.ON_SELECTION_CHANGE;
            }
            if (TreeHandlerChangesTreeTracker.this.isForceKeepCurrentFileWhileFocused) {
                return this.updateType == UpdateType.ON_SELECTION_CHANGE && ((PreviewUpdate)eatenUpdate).updateType == UpdateType.ON_MODEL_CHANGE;
            }
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerChangesTreeTracker$UpdateType;", "", "<init>", "(Ljava/lang/String;I)V", "FULL", "ON_SELECTION_CHANGE", "ON_MODEL_CHANGE", "intellij.platform.vcs.impl"})
    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType FULL = new UpdateType();
        public static final /* enum */ UpdateType ON_SELECTION_CHANGE = new UpdateType();
        public static final /* enum */ UpdateType ON_MODEL_CHANGE = new UpdateType();
        private static final /* synthetic */ UpdateType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateType[] values() {
            return (UpdateType[])$VALUES.clone();
        }

        public static UpdateType valueOf(String value) {
            return Enum.valueOf(UpdateType.class, value);
        }

        @NotNull
        public static EnumEntries<UpdateType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateTypeArray = new UpdateType[]{UpdateType.FULL, UpdateType.ON_SELECTION_CHANGE, UpdateType.ON_MODEL_CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

