/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitActivity;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.actions.GitAbortOperationAction;
import git4idea.applyChanges.GitApplyChangesProcess;
import git4idea.cherrypick.EmptyCherryPickResolutionStrategy;
import git4idea.cherrypick.EmptyCherryPickResolutionStrategyKt;
import git4idea.cherrypick.GitCherryPickContinueProcess;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0006H\u0014J:\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0014J:\u0010\"\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0014J,\u0010#\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0005H\u0014J\u001e\u0010'\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060$H\u0002J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020)H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgit4idea/cherrypick/GitCherryPickProcess;", "Lgit4idea/applyChanges/GitApplyChangesProcess;", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "successfullyCherryPickedCount", "", "totalCommitsToCherryPick", "currentCommitCounter", "isSuccess", "", "isEmptyCommit", "result", "Lgit4idea/commands/GitCommandResult;", "findStoppedCommitInSequence", "repository", "Lgit4idea/repo/GitRepository;", "cleanupBeforeCommit", "", "generateDefaultMessage", "", "Lorg/jetbrains/annotations/NonNls;", "commit", "executeForRepository", "repoCommits", "successfulCommits", "", "alreadyPicked", "executeForCommitChunk", "applyChanges", "", "listeners", "Lgit4idea/commands/GitLineHandlerListener;", "updateCherryPickIndicatorText", "shouldAddSuffix", "Lcom/intellij/vcs/log/Hash;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCherryPickProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CherryPickProcess.kt\ngit4idea/cherrypick/GitCherryPickProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n391#2,7:158\n1586#2:165\n1661#2,3:166\n1786#2,3:169\n37#3,2:172\n23#4:174\n*S KotlinDebug\n*F\n+ 1 CherryPickProcess.kt\ngit4idea/cherrypick/GitCherryPickProcess\n*L\n61#1:158,7\n119#1:165\n119#1:166,3\n121#1:169,3\n122#1:172,2\n148#1:174\n*E\n"})
public final class GitCherryPickProcess
extends GitApplyChangesProcess {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final ProgressIndicator indicator;
    private int successfullyCherryPickedCount;
    private final int totalCommitsToCherryPick;
    private int currentCommitCounter;
    @NotNull
    private static final Logger LOG;
    private static final boolean AUTO_COMMIT;

    public GitCherryPickProcess(@NotNull Project project, @NotNull List<? extends VcsCommitMetadata> commits, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        String string = GitBundle.message("cherry.pick.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message("cherry.pick.applied", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GitAbortOperationAction gitAbortOperationAction = new GitAbortOperationAction.CherryPick();
        String string3 = GitBundle.message("activity.name.cherry.pick", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        super(project, commits, string, string2, gitAbortOperationAction, true, string3, GitActivity.CherryPick);
        this.indicator = indicator;
        this.totalCommitsToCherryPick = commits.size();
    }

    public final boolean isSuccess() {
        return this.successfullyCherryPickedCount == this.totalCommitsToCherryPick;
    }

    @Override
    protected boolean isEmptyCommit(@NotNull GitCommandResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return GitCherryPickContinueProcess.INSTANCE.isEmptyCommit$intellij_vcs_git(result2);
    }

    @Override
    @NotNull
    protected VcsCommitMetadata findStoppedCommitInSequence(@NotNull GitRepository repository2, @NotNull List<? extends VcsCommitMetadata> commits) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        if (commits.size() == 1) {
            return (VcsCommitMetadata)CollectionsKt.first(commits);
        }
        VcsCommitMetadata vcsCommitMetadata = Companion.getCherryPickHead$intellij_vcs_git(repository2);
        if (vcsCommitMetadata == null) {
            int n;
            block3: {
                GitCherryPickProcess $this$findStoppedCommitInSequence_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("Failed to get CHERRY_PICK_HEAD");
                Hash head = GitUtil.getHead(repository2);
                List<? extends VcsCommitMetadata> $this$indexOfLast$iv = commits;
                boolean $i$f$indexOfLast = false;
                ListIterator<? extends VcsCommitMetadata> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    VcsCommitMetadata it = iterator$iv.previous();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)head, (Object)it.getId())) continue;
                    n = iterator$iv.nextIndex();
                    break block3;
                }
                n = -1;
            }
            int nextIndexAfterHead = n + 1;
            vcsCommitMetadata = commits.get(RangesKt.coerceIn((int)nextIndexAfterHead, (int)0, (int)CollectionsKt.getLastIndex(commits)));
        }
        return vcsCommitMetadata;
    }

    @Override
    public void cleanupBeforeCommit(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        File file = repository2.getRepositoryFiles().getCherryPickHead();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCherryPickHead(...)");
        File cherryPickHeadFile = file;
        if (cherryPickHeadFile.exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository2.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @Override
    @NotNull
    protected String generateDefaultMessage(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        StringBuilder $this$generateDefaultMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateDefaultMessage_u24lambda_u240.append(commit.getFullMessage());
        Object object = commit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        if (this.shouldAddSuffix(repository2, (Hash)object)) {
            String string = "\n\n(cherry picked from commit %s)";
            Object[] objectArray = new Object[]{((Hash)commit.getId()).asString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            $this$generateDefaultMessage_u24lambda_u240.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected boolean executeForRepository(@NotNull GitRepository repository2, @NotNull List<? extends VcsCommitMetadata> repoCommits, @NotNull Set<VcsCommitMetadata> successfulCommits, @NotNull Set<VcsCommitMetadata> alreadyPicked) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(repoCommits, (String)"repoCommits");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
        return Registry.Companion.is("git.cherry.pick.use.git.sequencer") ? this.executeForCommitChunk(repository2, repoCommits, successfulCommits, alreadyPicked) : super.executeForRepository(repository2, repoCommits, successfulCommits, alreadyPicked);
    }

    @Override
    protected boolean executeForCommitChunk(@NotNull GitRepository repository2, @NotNull List<? extends VcsCommitMetadata> commits, @NotNull Set<VcsCommitMetadata> successfulCommits, @NotNull Set<VcsCommitMetadata> alreadyPicked) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
        this.currentCommitCounter += commits.size();
        boolean result2 = super.executeForCommitChunk(repository2, commits, successfulCommits, alreadyPicked);
        if (result2) {
            this.successfullyCherryPickedCount += commits.size();
            VcsCommitMetadata lastCommit = (VcsCommitMetadata)CollectionsKt.last(commits);
            if (Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((Iterable)alreadyPicked), (Object)lastCommit)) {
                LOG.info("Applying empty cherry-pick resolution strategy, as the last commit " + lastCommit.getId() + " in the sequence is empty");
                EmptyCherryPickResolutionStrategy emptyCherryPickResolutionStrategy = GitVcsApplicationSettings.getInstance().getEmptyCherryPickResolutionStrategy();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)emptyCherryPickResolutionStrategy), (String)"getEmptyCherryPickResolutionStrategy(...)");
                EmptyCherryPickResolutionStrategyKt.apply(emptyCherryPickResolutionStrategy, repository2);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected GitCommandResult applyChanges(@NotNull GitRepository repository2, @NotNull Collection<? extends VcsCommitMetadata> commits, @NotNull List<? extends GitLineHandlerListener> listeners) {
        GitCommandResult result2;
        block6: {
            boolean bl;
            boolean bl2;
            Collection<String> collection;
            Git git;
            GitRepository gitRepository;
            block5: {
                void $this$all$iv;
                Iterator $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object it;
                Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
                ProgressIndicator progressIndicator = this.indicator;
                if (progressIndicator != null) {
                    it = progressIndicator;
                    boolean bl3 = false;
                    this.updateCherryPickIndicatorText((ProgressIndicator)it, commits);
                }
                it = commits;
                gitRepository = repository2;
                git = Git.getInstance();
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it2;
                    Object item$iv$iv = iterator.next();
                    VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(((Hash)it2.getId()).asString());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = commits;
                bl2 = AUTO_COMMIT;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VcsCommitMetadata commit = (VcsCommitMetadata)element$iv;
                        boolean bl5 = false;
                        Object object = commit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
                        if (this.shouldAddSuffix(repository2, (Hash)object)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            boolean bl6 = bl;
            Collection $this$toTypedArray$iv = listeners;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GitLineHandlerListener[] gitLineHandlerListenerArray = thisCollection$iv.toArray(new GitLineHandlerListener[0]);
            GitCommandResult gitCommandResult = git.cherryPick(gitRepository, (List<String>)collection, bl2, bl6, Arrays.copyOf(gitLineHandlerListenerArray, gitLineHandlerListenerArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"cherryPick(...)");
            result2 = gitCommandResult;
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator == null) break block6;
            progressIndicator.setFraction((double)this.currentCommitCounter / (double)this.totalCommitsToCherryPick);
        }
        return result2;
    }

    private final void updateCherryPickIndicatorText(ProgressIndicator indicator, Collection<? extends VcsCommitMetadata> commits) {
        String string;
        if (this.totalCommitsToCherryPick > 1) {
            Object[] objectArray = new Object[]{StringUtil.trimMiddle((String)CollectionsKt.joinToString$default((Iterable)commits, null, null, null, (int)0, null, GitCherryPickProcess::updateCherryPickIndicatorText$lambda$0, (int)31, null), (int)30), this.currentCommitCounter, this.totalCommitsToCherryPick};
            string = DvcsBundle.message((String)"cherry.picking.process.commit", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{StringUtil.trimMiddle((String)CollectionsKt.joinToString$default((Iterable)commits, null, null, null, (int)0, null, GitCherryPickProcess::updateCherryPickIndicatorText$lambda$1, (int)31, null), (int)30)};
            string = DvcsBundle.message((String)"cherry.picking.process.commit.single", (Object[])objectArray);
        }
        indicator.setText(string);
    }

    private final boolean shouldAddSuffix(GitRepository repository2, Hash commit) {
        return GitVcsSettings.getInstance(this.getProject()).shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository2, commit);
    }

    private static final CharSequence updateCherryPickIndicatorText$lambda$0(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
        return string;
    }

    private static final CharSequence updateCherryPickIndicatorText$lambda$1(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
        return string;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        AUTO_COMMIT = true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/cherrypick/GitCherryPickProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "AUTO_COMMIT", "", "getCherryPickHead", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lgit4idea/repo/GitRepository;", "getCherryPickHead$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VcsCommitMetadata getCherryPickHead$intellij_vcs_git(@NotNull GitRepository $this$getCherryPickHead) {
            VcsCommitMetadata vcsCommitMetadata;
            Intrinsics.checkNotNullParameter((Object)$this$getCherryPickHead, (String)"<this>");
            try {
                String[] stringArray = new String[]{"CHERRY_PICK_HEAD"};
                List<? extends VcsCommitMetadata> list = GitHistoryUtils.collectCommitsMetadata($this$getCherryPickHead.getProject(), $this$getCherryPickHead.getRoot(), stringArray);
                vcsCommitMetadata = list != null ? (VcsCommitMetadata)CollectionsKt.firstOrNull(list) : null;
            }
            catch (VcsException vcsException) {
                vcsCommitMetadata = null;
            }
            return vcsCommitMetadata;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

