/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitLocalBranch;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitProjectConfigurationCache;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u001c\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/repo/GitRepositoryUpdater;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "repository", "Lgit4idea/repo/GitRepository;", "repositoryFiles", "Lgit4idea/repo/GitRepositoryFiles;", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRepositoryFiles;)V", "rootDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "remotesDir", "headsDir", "tagsDir", "reftableDir", "watchRequests", "", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "installListeners", "", "dispose", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isRootDirChange", "", "event", "visitSubDirsInVfs", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryUpdater.kt\ngit4idea/repo/GitRepositoryUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1586#2:188\n1661#2,3:189\n1807#2,3:193\n1#3:192\n*S KotlinDebug\n*F\n+ 1 GitRepositoryUpdater.kt\ngit4idea/repo/GitRepositoryUpdater\n*L\n35#1:188\n35#1:189,3\n174#1:193,3\n*E\n"})
public final class GitRepositoryUpdater
implements Disposable,
AsyncVfsEventsListener {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GitRepositoryFiles repositoryFiles;
    @NotNull
    private final Collection<VirtualFile> rootDirs;
    @Nullable
    private final VirtualFile remotesDir;
    @Nullable
    private final VirtualFile headsDir;
    @Nullable
    private final VirtualFile tagsDir;
    @Nullable
    private final VirtualFile reftableDir;
    @NotNull
    private final Set<LocalFileSystem.WatchRequest> watchRequests;

    /*
     * WARNING - void declaration
     */
    public GitRepositoryUpdater(@NotNull GitRepository repository2, @NotNull GitRepositoryFiles repositoryFiles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)repositoryFiles, (String)"repositoryFiles");
        this.repository = repository2;
        this.repositoryFiles = repositoryFiles;
        Collection<VirtualFile> collection2 = this.repositoryFiles.getRootDirs();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getRootDirs(...)");
        this.rootDirs = collection2;
        Iterable iterable = this.rootDirs;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        GitRepositoryUpdater gitRepositoryUpdater = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        collection = (List)destination$iv$iv;
        Set set = localFileSystem.addRootsToWatch((Collection)collection, true);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"addRootsToWatch(...)");
        gitRepositoryUpdater.watchRequests = set;
        this.visitSubDirsInVfs();
        this.headsDir = VcsUtil.getVirtualFile((File)this.repositoryFiles.getRefsHeadsFile());
        this.remotesDir = VcsUtil.getVirtualFile((File)this.repositoryFiles.getRefsRemotesFile());
        this.tagsDir = VcsUtil.getVirtualFile((File)this.repositoryFiles.getRefsTagsFile());
        this.reftableDir = VcsUtil.getVirtualFile((File)this.repositoryFiles.getReftableFile());
    }

    public final void installListeners() {
        Disposer.register((Disposable)((Disposable)this.repository), (Disposable)this);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, this.repository.getCoroutineScope());
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots((Collection)this.watchRequests);
    }

    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        GitLocalBranch currentBranch = this.repository.getCurrentBranch();
        boolean configChanged = false;
        boolean indexChanged = false;
        boolean headChanged = false;
        boolean headMoved = false;
        boolean branchFileChanged = false;
        boolean currentBranchChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        boolean externallyCommitted = false;
        boolean tagChanged = false;
        boolean reftableChanged = false;
        boolean gitignoreChanged = false;
        boolean worktreesChanged = false;
        HashSet<VirtualFile> toReloadVfs = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            String filePath;
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)vFileEvent.getPath(), (String)"getPath(...)");
            if (this.isRootDirChange(vFileEvent)) {
                if (this.repositoryFiles.isConfigFile(filePath)) {
                    configChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isIndexFile(filePath)) {
                    indexChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isHeadFile(filePath)) {
                    headChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isOrigHeadFile(filePath)) {
                    headMoved = true;
                    continue;
                }
                if (this.repositoryFiles.isBranchFile(filePath)) {
                    branchFileChanged = true;
                    if (this.headsDir != null) {
                        VirtualFile it;
                        boolean bl = false;
                        Boxing.boxBoolean((boolean)toReloadVfs.add(it));
                    }
                    if (currentBranch == null || !this.repositoryFiles.isBranchFile(filePath, currentBranch.getFullName())) continue;
                    currentBranchChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isRemoteBranchFile(filePath)) {
                    branchFileChanged = true;
                    ContainerUtil.addIfNotNull((Collection)toReloadVfs, (Object)this.remotesDir);
                    continue;
                }
                if (this.repositoryFiles.isPackedRefs(filePath)) {
                    packedRefsChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isRebaseFile(filePath)) {
                    rebaseFileChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isMergeFile(filePath)) {
                    mergeFileChanged = true;
                    continue;
                }
                if (this.repositoryFiles.isCommitMessageFile(filePath)) {
                    externallyCommitted = true;
                    continue;
                }
                if (this.repositoryFiles.isTagFile(filePath)) {
                    tagChanged = true;
                    ContainerUtil.addIfNotNull((Collection)toReloadVfs, (Object)this.tagsDir);
                    continue;
                }
                if (this.repositoryFiles.isReftableFile(filePath)) {
                    reftableChanged = true;
                    ContainerUtil.addIfNotNull((Collection)toReloadVfs, (Object)this.reftableDir);
                    continue;
                }
                if (this.repositoryFiles.isExclude(filePath)) {
                    gitignoreChanged = true;
                    continue;
                }
                if (!this.repositoryFiles.isWorktreeDirectory(filePath)) continue;
                worktreesChanged = true;
                continue;
            }
            if (!StringsKt.endsWith$default((String)filePath, (String)".gitignore", (boolean)false, (int)2, null)) continue;
            gitignoreChanged = true;
        }
        JobKt.ensureActive((CoroutineContext)$completion.getContext());
        Iterator iterator = toReloadVfs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            VirtualFile virtualFile = (VirtualFile)object;
            VfsUtilCore.processFilesRecursively((VirtualFile)virtualFile, (Processor)CommonProcessors.alwaysTrue());
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || reftableChanged || rebaseFileChanged || mergeFileChanged) {
            this.repository.update();
        }
        if (tagChanged || packedRefsChanged || reftableChanged) {
            this.repository.getTagHolder().reload();
            ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)this.repository.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(this.repository);
        }
        if (configChanged) {
            Project project = this.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitProjectConfigurationCache.Companion.getInstance(project).clearForRepo(this.repository);
            ((GitConfigListener)BackgroundTaskUtil.syncPublisher((Project)this.repository.getProject(), GitConfigListener.TOPIC)).notifyConfigChanged(this.repository);
        }
        if (indexChanged || externallyCommitted || headMoved || headChanged || currentBranchChanged || gitignoreChanged) {
            VcsDirtyScopeManager.getInstance((Project)this.repository.getProject()).rootDirty(this.repository.getRoot());
            this.repository.getUntrackedFilesHolder().invalidate();
            this.repository.getResolvedConflictsFilesHolder().invalidate();
        }
        if (indexChanged) {
            Project project = this.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitIndexFileSystemRefresher.Companion.refreshRoots(project, CollectionsKt.listOf((Object)this.repository.getRoot()));
        }
        if (worktreesChanged) {
            this.repository.getWorkingTreeHolder().reload();
        }
        return Unit.INSTANCE;
    }

    private final boolean isRootDirChange(VFileEvent event) {
        boolean bl;
        block4: {
            VirtualFile virtualFile = event.getFile();
            if (virtualFile == null) {
                return true;
            }
            VirtualFile file = virtualFile;
            Iterable $this$any$iv = this.rootDirs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)false)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void visitSubDirsInVfs() {
        for (VirtualFile rootDir : this.repositoryFiles.getRootDirs()) {
            rootDir.getChildren();
        }
        for (String path : this.repositoryFiles.getPathsToWatch()) {
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        }
    }
}

