/*
 * Decompiled with CFR 0.152.
 */
package git4idea.statistics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.statistics.CommitsSummary;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/statistics/GitCommitterCounter;", "", "periods", "", "Ljava/time/Period;", "additionalGitParameters", "", "collectCommitCount", "", "<init>", "(Ljava/util/List;Ljava/util/List;Z)V", "getCollectCommitCount", "()Z", "thresholds", "calculateWithGit", "Lgit4idea/statistics/CommitsSummary;", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Lgit4idea/repo/GitRepository;", "since", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitterCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitterCounter.kt\ngit4idea/statistics/GitCommitterCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1586#2:63\n1661#2,3:64\n1924#2,3:67\n*S KotlinDebug\n*F\n+ 1 GitCommitterCounter.kt\ngit4idea/statistics/GitCommitterCounter\n*L\n24#1:63\n24#1:64,3\n29#1:67,3\n*E\n"})
public final class GitCommitterCounter {
    @NotNull
    private final List<String> additionalGitParameters;
    private final boolean collectCommitCount;
    @NotNull
    private final List<String> thresholds;

    /*
     * WARNING - void declaration
     */
    public GitCommitterCounter(@NotNull List<Period> periods, @NotNull List<String> additionalGitParameters, boolean collectCommitCount) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(periods, (String)"periods");
        Intrinsics.checkNotNullParameter(additionalGitParameters, (String)"additionalGitParameters");
        this.additionalGitParameters = additionalGitParameters;
        this.collectCommitCount = collectCommitCount;
        LocalDateTime now = LocalDateTime.now();
        Iterable iterable = periods;
        GitCommitterCounter gitCommitterCounter = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Period period = (Period)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(now.minus((TemporalAmount)it).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        gitCommitterCounter.thresholds = (List)destination$iv$iv;
    }

    public /* synthetic */ GitCommitterCounter(List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, list2, bl);
    }

    public final boolean getCollectCommitCount() {
        return this.collectCommitCount;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CommitsSummary> calculateWithGit(@NotNull Project project, @NotNull GitRepository repo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        List result2 = new ArrayList();
        Iterable $this$forEachIndexed$iv = this.thresholds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void sinceDate;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            result2.add(this.calculateWithGit(project, repo, (String)sinceDate));
        }
        return result2;
    }

    private final CommitsSummary calculateWithGit(Project project, GitRepository repo, String since) {
        GitLineHandler gitLineHandler;
        GitLineHandler $this$calculateWithGit_u24lambda_u241 = gitLineHandler = new GitLineHandler(project, repo.getRoot(), GitCommand.SHORTLOG);
        boolean bl = false;
        $this$calculateWithGit_u24lambda_u241.setSilent(true);
        String[] stringArray = new String[]{"-s", "--since", since};
        $this$calculateWithGit_u24lambda_u241.addParameters(stringArray);
        $this$calculateWithGit_u24lambda_u241.addParameters(this.additionalGitParameters);
        $this$calculateWithGit_u24lambda_u241.setInputProcessor(GitHandlerInputProcessorUtil.empty());
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        result2.throwOnError(new int[0]);
        int commits = 0;
        if (this.collectCommitCount) {
            for (String line : result2.getOutput()) {
                Intrinsics.checkNotNull((Object)line);
                Object[] objectArray = (Object[])((Object)StringsKt.trim((CharSequence)line)).toString();
                Object[] objectArray2 = new Regex("\\W");
                int n = 0;
                List split = objectArray2.split((CharSequence)objectArray, n);
                if (split.isEmpty()) {
                    objectArray = new Object[]{line};
                    throw new VcsException(GitBundle.message("stats.wrong.git.shortlog.response", objectArray));
                }
                try {
                    commits += Integer.parseInt((String)split.get(0));
                }
                catch (NumberFormatException e) {
                    objectArray2 = new Object[]{line};
                    throw new VcsException(GitBundle.message("stats.wrong.git.shortlog.response", objectArray2), (Throwable)e);
                }
            }
        }
        return new CommitsSummary(commits, result2.getOutput().size());
    }
}

