/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdateOptionsDialog;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.update.GitUpdateExecutionProcess;
import git4idea.update.GitUpdateNotificationsKt;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lgit4idea/update/GitUpdateOptionsDialog;", "Lcom/intellij/openapi/vcs/update/UpdateOptionsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsSafe;", "envToConfMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/LinkedHashMap;)V", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "askForConfirmation", "", "repository", "Lgit4idea/repo/GitRepository;", "ResetToRemoteBranchAction", "intellij.vcs.git"})
public final class GitUpdateOptionsDialog
extends UpdateOptionsDialog {
    public GitUpdateOptionsDialog(@NotNull Project project, @NotNull String title, @NotNull LinkedHashMap<Configurable, AbstractVcs> envToConfMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(envToConfMap, (String)"envToConfMap");
        super(project, title, envToConfMap);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = super.createLeftSideActions();
        Intrinsics.checkNotNullExpressionValue((Object)actionArray, (String)"createLeftSideActions(...)");
        Action[] baseLeft = actionArray;
        List<GitRepository> list = GitUtil.getRepositoryManager(this.myProject).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(list);
        if (gitRepository == null) {
            return baseLeft;
        }
        GitRepository repository2 = gitRepository;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)new ResetToRemoteBranchAction(repository2));
        spreadBuilder.addSpread((Object)baseLeft);
        return (Action[])spreadBuilder.toArray((Object[])new Action[spreadBuilder.size()]);
    }

    private final boolean askForConfirmation(GitRepository repository2) {
        GitLocalBranch gitLocalBranch = repository2.getCurrentBranch();
        if (gitLocalBranch == null) {
            GitUpdateOptionsDialog $this$askForConfirmation_u24lambda_u240 = this;
            boolean bl = false;
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)$this$askForConfirmation_u24lambda_u240.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
            GitUpdateNotificationsKt.notifyDetachedHeadError(vcsNotifier, repository2);
            return false;
        }
        GitLocalBranch localBranch = gitLocalBranch;
        GitRemoteBranch gitRemoteBranch = localBranch.findTrackedBranch(repository2);
        if (gitRemoteBranch == null) {
            GitUpdateOptionsDialog $this$askForConfirmation_u24lambda_u241 = this;
            boolean bl = false;
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)$this$askForConfirmation_u24lambda_u241.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
            GitUpdateNotificationsKt.notifyNoTrackedBranchError(vcsNotifier, repository2, localBranch);
            return false;
        }
        GitRemoteBranch remoteBranch = gitRemoteBranch;
        String string = GitBranchPopupActions.getSelectedBranchFullPresentation(localBranch.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSelectedBranchFullPresentation(...)");
        String localBranchPresentation = string;
        String string2 = GitBranchPopupActions.getSelectedBranchFullPresentation(remoteBranch.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSelectedBranchFullPresentation(...)");
        String remoteBranchPresentation = string2;
        String string3 = GitBundle.message("action.Git.Update.Reset.To.Remote.Branch.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Object[] objectArray = new Object[]{localBranchPresentation, remoteBranchPresentation};
        String string4 = GitBundle.message("action.Git.Update.Reset.To.Remote.Branch.confirmation", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return ((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string3, string4).asWarning()).ask(this.myProject);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/update/GitUpdateOptionsDialog$ResetToRemoteBranchAction;", "Lcom/intellij/openapi/ui/DialogWrapper$DialogWrapperAction;", "Lcom/intellij/openapi/ui/DialogWrapper;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/update/GitUpdateOptionsDialog;Lgit4idea/repo/GitRepository;)V", "doAction", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.vcs.git"})
    private final class ResetToRemoteBranchAction
    extends DialogWrapper.DialogWrapperAction {
        @NotNull
        private final GitRepository repository;

        public ResetToRemoteBranchAction(GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            super((DialogWrapper)GitUpdateOptionsDialog.this, GitBundle.message("action.Git.Update.Reset.To.Remote.Branch.text", new Object[0]));
            this.repository = repository2;
        }

        protected void doAction(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GitUpdateOptionsDialog.this.doCancelAction();
            if (GitUpdateOptionsDialog.this.askForConfirmation(this.repository)) {
                Project project = GitUpdateOptionsDialog.this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s1390093867(...)");
                GitUpdateExecutionProcess.launchUpdate$default(project, CollectionsKt.listOf((Object)this.repository), null, UpdateMethod.RESET, false, 16, null);
            }
        }
    }
}

