/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u0012H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/CropIcon;", "Ljavax/swing/Icon;", "sourceIcon", "crop", "Ljava/awt/Rectangle;", "<init>", "(Ljavax/swing/Icon;Ljava/awt/Rectangle;)V", "getSourceIcon", "()Ljavax/swing/Icon;", "getCrop", "()Ljava/awt/Rectangle;", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "toString", "", "getIconWidth", "getIconHeight", "equals", "", "other", "", "hashCode", "intellij.platform.core.ui"})
@ApiStatus.Internal
public final class CropIcon
implements Icon {
    @NotNull
    private final Icon sourceIcon;
    @NotNull
    private final Rectangle crop;

    public CropIcon(@NotNull Icon sourceIcon, @NotNull Rectangle crop) {
        Intrinsics.checkNotNullParameter((Object)sourceIcon, (String)"sourceIcon");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        this.sourceIcon = sourceIcon;
        this.crop = crop;
    }

    @NotNull
    public final Icon getSourceIcon() {
        return this.sourceIcon;
    }

    @NotNull
    public final Rectangle getCrop() {
        return this.crop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics customG = g.create();
        try {
            Rectangle iconClip = new Rectangle(x, y, this.crop.width, this.crop.height);
            Rectangle gClip = customG.getClipBounds();
            if (gClip != null) {
                Rectangle2D.intersect(iconClip, gClip, iconClip);
            }
            customG.setClip(iconClip);
            this.sourceIcon.paintIcon(c, customG, x - this.crop.x, y - this.crop.y);
        }
        finally {
            customG.dispose();
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.sourceIcon + " -> " + this.crop + ")";
    }

    @Override
    public int getIconWidth() {
        return this.crop.width;
    }

    @Override
    public int getIconHeight() {
        return this.crop.height;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CropIcon && Intrinsics.areEqual((Object)this.sourceIcon, (Object)((CropIcon)other).sourceIcon) && Intrinsics.areEqual((Object)this.crop, (Object)((CropIcon)other).crop);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.sourceIcon, this.crop};
        return Objects.hash(objectArray);
    }
}

