/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.text;

import ai.grazie.DataHolder;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.HashKey;
import ai.grazie.text.TextRange;
import ai.grazie.utils.Hash;
import ai.grazie.utils.HashKt;
import ai.grazie.utils.multiplatform.SafeJsExport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\t\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0003J\t\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001J\u0019\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010#\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lai/grazie/text/Text;", "Lai/grazie/DataHolder;", "", "charSequence", "<init>", "(Ljava/lang/CharSequence;)V", "value", "", "(Ljava/lang/String;)V", "getCharSequence", "()Ljava/lang/CharSequence;", "hash", "Lai/grazie/utils/Hash;", "getHash", "()Lai/grazie/utils/Hash;", "getValue", "()Ljava/lang/String;", "substring", "range", "Lai/grazie/text/TextRange;", "toString", "component1", "copy", "equals", "", "other", "", "get", "", "index", "", "hashCode", "subSequence", "startIndex", "endIndex", "length", "getLength", "()I", "model-text"})
public final class Text
extends DataHolder
implements CharSequence {
    @NotNull
    private final CharSequence charSequence;

    public Text(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        this.charSequence = charSequence;
    }

    @NotNull
    public final CharSequence getCharSequence() {
        return this.charSequence;
    }

    public Text(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this((CharSequence)value);
    }

    @NotNull
    public final Hash getHash() {
        return (Hash)this.getOrPut(HashKey.INSTANCE, () -> Text._get_hash_$lambda$0(this));
    }

    @NotNull
    public final String getValue() {
        return this.toString();
    }

    @NotNull
    public final Text substring(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new Text(ExtensionsKt.substring(this.toString(), range));
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.charSequence).toString();
    }

    @NotNull
    public final CharSequence component1() {
        return this.charSequence;
    }

    @NotNull
    public final Text copy(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        return new Text(charSequence);
    }

    public static /* synthetic */ Text copy$default(Text text2, CharSequence charSequence, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence = text2.charSequence;
        }
        return text2.copy(charSequence);
    }

    public int hashCode() {
        return this.charSequence.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Text)) {
            return false;
        }
        Text text2 = (Text)other;
        return Intrinsics.areEqual((Object)this.charSequence, (Object)text2.charSequence);
    }

    public char get(int index) {
        return this.charSequence.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.charSequence.subSequence(startIndex, endIndex);
    }

    public int getLength() {
        return this.charSequence.length();
    }

    private static final Hash _get_hash_$lambda$0(Text this$0) {
        return HashKt.hash(((Object)this$0.charSequence).toString());
    }
}

