/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.CustomLibraryTableImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.CustomLibraryTableDescription;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LibraryTablesRegistrarImpl.class);
    private final Map<String, LibraryTable> customLibraryTables = new ConcurrentHashMap<String, LibraryTable>();
    private volatile boolean extensionLoaded = false;
    private final Object extensionLoadingLock = new Object();

    LibraryTablesRegistrarImpl() {
        VirtualFilePointerManager.getInstance();
    }

    @NotNull
    public LibraryTable getLibraryTable() {
        GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.Companion.getInstance((EelMachine)LocalEelMachine.INSTANCE);
        if (globalLibraryTableBridge == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(0);
        }
        return globalLibraryTableBridge;
    }

    @NotNull
    public LibraryTable getGlobalLibraryTable(@NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"ide.workspace.model.per.environment.model.separation", (boolean)false)) {
            LibraryTable libraryTable = this.getLibraryTable();
            if (libraryTable == null) {
                LibraryTablesRegistrarImpl.$$$reportNull$$$0(2);
            }
            return libraryTable;
        }
        EelMachine eelMachine = EelProviderUtil.getEelMachine((Project)project);
        GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.Companion.getInstance(eelMachine);
        if (globalLibraryTableBridge == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(3);
        }
        return globalLibraryTableBridge;
    }

    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(4);
        }
        LibraryTable libraryTable = (LibraryTable)project.getService(ProjectLibraryTable.class);
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(5);
        }
        return libraryTable;
    }

    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(6);
        }
        return switch (level) {
            case "project" -> this.getLibraryTable(project);
            case "application" -> this.getGlobalLibraryTable(project);
            default -> this.getCustomLibraryTableByLevel(level);
        };
    }

    @Nullable
    public LibraryTable getCustomLibraryTableByLevel(String level) {
        LibraryTable table = this.getCustomLibrariesMap().get(level);
        if (table == null) {
            LOG.warn("Table not found: " + level);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, LibraryTable> getCustomLibrariesMap() {
        if (this.extensionLoaded) {
            Map<String, LibraryTable> map = this.customLibraryTables;
            if (map == null) {
                LibraryTablesRegistrarImpl.$$$reportNull$$$0(7);
            }
            return map;
        }
        Object object = this.extensionLoadingLock;
        synchronized (object) {
            if (!this.extensionLoaded) {
                CustomLibraryTableDescription.CUSTOM_TABLES_EP.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CustomLibraryTableDescription>(){

                    public void extensionAdded(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        if (extension == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        CustomLibraryTableImpl table = new CustomLibraryTableImpl(extension.getTableLevel(), extension.getPresentation());
                        LibraryTablesRegistrarImpl.this.customLibraryTables.put(extension.getTableLevel(), (LibraryTable)table);
                        LOG.info("Table added: " + extension.getTableLevel());
                    }

                    public void extensionRemoved(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        LibraryTable table;
                        if (extension == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if ((table = LibraryTablesRegistrarImpl.this.customLibraryTables.remove(extension.getTableLevel())) instanceof Disposable) {
                            Disposable disposable = (Disposable)table;
                            Disposer.dispose((Disposable)disposable);
                            LOG.info("Table removed: " + extension.getTableLevel());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "extension";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pluginDescriptor";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionAdded";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true, null);
                this.extensionLoaded = true;
            }
        }
        Map<String, LibraryTable> map = this.customLibraryTables;
        if (map == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public List<LibraryTable> getCustomLibraryTables() {
        List<LibraryTable> list = List.copyOf(this.getCustomLibrariesMap().values());
        if (list == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void dispose() {
        for (LibraryTable table : this.customLibraryTables.values()) {
            if (!(table instanceof Disposable)) continue;
            Disposable disposable = (Disposable)table;
            Disposer.dispose((Disposable)disposable);
        }
        this.customLibraryTables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTable";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalLibraryTable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLibrariesMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLibraryTables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalLibraryTable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTableByLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

