/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectData
extends AbstractNamedData
implements ExternalConfigPathAware,
Identifiable {
    @NotNull
    private final String linkedExternalProjectPath;
    @NotNull
    private String ideProjectFileDirectoryPath;
    @Nullable
    private String description;
    private String group;
    private String version;
    private String ideGrouping;

    @PropertyMapping(value={"owner", "externalName", "ideProjectFileDirectoryPath", "linkedExternalProjectPath"})
    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String externalName, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        if (owner == null) {
            ProjectData.$$$reportNull$$$0(0);
        }
        if (externalName == null) {
            ProjectData.$$$reportNull$$$0(1);
        }
        if (ideProjectFileDirectoryPath == null) {
            ProjectData.$$$reportNull$$$0(2);
        }
        if (linkedExternalProjectPath == null) {
            ProjectData.$$$reportNull$$$0(3);
        }
        super(owner, externalName);
        this.linkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.ideProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @NotNull
    public String getIdeProjectFileDirectoryPath() {
        String string = this.ideProjectFileDirectoryPath;
        if (string == null) {
            ProjectData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setIdeProjectFileDirectoryPath(@NotNull String ideProjectFileDirectoryPath) {
        if (ideProjectFileDirectoryPath == null) {
            ProjectData.$$$reportNull$$$0(5);
        }
        this.ideProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.linkedExternalProjectPath;
        if (string == null) {
            ProjectData.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getIdeGrouping() {
        return this.ideGrouping;
    }

    public void setIdeGrouping(@Nullable String ideGrouping) {
        this.ideGrouping = ideGrouping;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ideProjectFileDirectoryPath.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectData project = (ProjectData)o;
        return this.ideProjectFileDirectoryPath.equals(project.ideProjectFileDirectoryPath);
    }

    public String toString() {
        return String.format("%s project '%s'", StringUtil.toLowerCase((String)this.getOwner().toString()), this.getExternalName());
    }

    @Override
    @NotNull
    public String getId() {
        return "";
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProjectFileDirectoryPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedExternalProjectPath";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/ProjectData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/ProjectData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProjectFileDirectoryPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedExternalProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setIdeProjectFileDirectoryPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

