/*
 * Decompiled with CFR 0.152.
 */
package training.git.lesson;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.UnshelveWithDialogAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.fixture.JMenuItemFixture;
import org.assertj.swing.timing.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LearningBalloonConfig;
import training.dsl.LessonContext;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.git.GitLessonsBundle;
import training.git.GitLessonsUtil;
import training.git.lesson.GitLesson;
import training.ui.IftTestContainerFixture;
import training.ui.LearningUiUtil;
import training.util.LessonEndInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020'2\u0006\u0010(\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R%\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Ltraining/git/lesson/GitChangelistsAndShelveLesson;", "Ltraining/git/lesson/GitLesson;", "<init>", "()V", "sampleFilePath", "", "getSampleFilePath", "()Ljava/lang/String;", "branchName", "getBranchName", "commentingLineText", "commentText", "backupShelveDialogLocation", "Ljava/awt/Point;", "backupUnshelveDialogLocation", "fileAddition", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "onLessonEnd", "project", "Lcom/intellij/openapi/project/Project;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "removeShelvedChangeLists", "resetChangelistsState", "modifyFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLineMarkerRect", "Ljava/awt/Rectangle;", "Lcom/intellij/openapi/editor/ex/EditorGutterComponentEx;", "partOfLine", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "intellij.vcs.git.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nGitChangelistsAndShelveLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitChangelistsAndShelveLesson.kt\ntraining/git/lesson/GitChangelistsAndShelveLesson\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 LearningUiUtil.kt\ntraining/ui/LearningUiUtil\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TaskTestContext.kt\ntraining/dsl/TaskTestContext\n+ 7 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n*L\n1#1,345:1\n1915#2,2:346\n777#2:348\n873#2,2:349\n1915#2,2:351\n23#3:353\n167#4,8:354\n167#4,8:367\n167#4,8:380\n1#5:362\n156#6,4:363\n160#6:375\n156#6,4:376\n160#6:388\n25#7,2:389\n20#7,2:391\n20#7,2:393\n20#7,2:395\n20#7,2:397\n20#7,2:399\n20#7,2:401\n20#7,2:403\n*S KotlinDebug\n*F\n+ 1 GitChangelistsAndShelveLesson.kt\ntraining/git/lesson/GitChangelistsAndShelveLesson\n*L\n302#1:346,2\n313#1:348\n313#1:349,2\n313#1:351,2\n330#1:353\n96#1:354,8\n202#1:367,8\n266#1:380,8\n202#1:363,4\n202#1:375\n266#1:376,4\n266#1:388\n80#1:389,2\n90#1:391,2\n108#1:393,2\n159#1:395,2\n184#1:397,2\n209#1:399,2\n232#1:401,2\n259#1:403,2\n*E\n"})
public final class GitChangelistsAndShelveLesson
extends GitLesson {
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final String branchName;
    @NotNull
    private final String commentingLineText;
    @NotNull
    private final String commentText;
    @Nullable
    private Point backupShelveDialogLocation;
    @Nullable
    private Point backupUnshelveDialogLocation;
    @NotNull
    private final String fileAddition;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties = new TaskTestContext.TestScriptProperties(40, false, 2, null);
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent = arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0(this, arg_0);

    public GitChangelistsAndShelveLesson() {
        super("Git.ChangelistsAndShelf", GitLessonsBundle.INSTANCE.message("git.changelists.shelf.lesson.name", new Object[0]));
        this.sampleFilePath = "git/martian_cat.yml";
        this.branchName = "main";
        this.commentingLineText = "fur_type: long haired";
        this.commentText = "# debug: check another types (short haired, hairless)";
        this.fileAddition = "\n    - eat:\n        condition: hungry\n        actions: [ fry self-grown potatoes ]";
    }

    @Override
    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @Override
    @NotNull
    protected String getBranchName() {
        return this.branchName;
    }

    @Override
    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    @Override
    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    @Override
    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        LessonUtil.INSTANCE.restorePopupPosition(project, "CommitChangelistDialog2", this.backupShelveDialogLocation);
        this.backupShelveDialogLocation = null;
        LessonUtil.INSTANCE.restorePopupPosition(project, "vcs.ApplyPatchDifferentiatedDialog", this.backupUnshelveDialogLocation);
        this.backupUnshelveDialogLocation = null;
    }

    private final void removeShelvedChangeLists(Project project) {
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance((Project)project);
        List list = shelveChangesManager.getAllLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLists(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShelvedChangeList it = (ShelvedChangeList)element$iv;
            boolean bl = false;
            it.setRecycled(true);
        }
        shelveChangesManager.cleanUnshelved(System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    private final void resetChangelistsState(Project project) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList defaultChangelist = localChangeList;
        String string = VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String defaultChangelistName = string;
        if (!Intrinsics.areEqual((Object)defaultChangelist.getName(), (Object)defaultChangelistName)) {
            changeListManager2.editName(defaultChangelist.getName(), defaultChangelistName);
        }
        List list = changeListManager2.getChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalChangeList it = (LocalChangeList)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)defaultChangelist.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalChangeList p0 = (LocalChangeList)element$iv;
            boolean bl = false;
            changeListManager2.removeChangeList(p0);
        }
    }

    private final void modifyFile(VirtualFile file) {
        ActionsKt.invokeLater$default(null, () -> GitChangelistsAndShelveLesson.modifyFile$lambda$0(file, this), (int)1, null);
    }

    private final Rectangle getLineMarkerRect(EditorGutterComponentEx $this$getLineMarkerRect, String partOfLine) {
        CharSequence charSequence = $this$getLineMarkerRect.getEditor().getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        int offset = StringsKt.indexOf$default((CharSequence)charSequence, (String)partOfLine, (int)0, (boolean)false, (int)6, null);
        if (offset == -1) {
            EditorGutterComponentEx $this$thisLogger$iv = $this$getLineMarkerRect;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditorGutterComponentEx.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to find '" + partOfLine + "' in the editor text:\n" + $this$getLineMarkerRect.getEditor().getDocument().getCharsSequence());
            return null;
        }
        int y = ((Number)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> GitChangelistsAndShelveLesson.getLineMarkerRect$lambda$0($this$getLineMarkerRect, offset), (int)1, null)).intValue();
        int highlightingWidth = JBUI.scale((int)8);
        return new Rectangle($this$getLineMarkerRect.getX() + $this$getLineMarkerRect.getWidth() - highlightingWidth, y, highlightingWidth, $this$getLineMarkerRect.getEditor().getLineHeight());
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)GitLessonsBundle.INSTANCE.message("git.changelists.shelf.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("work-on-several-features-simultaneously.html")));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lessonContent$lambda$0$2$1$0(TaskTestContext $this_test, GitChangelistsAndShelveLesson this$0, IftTestContainerFixture $this$ideFrame) {
        EditorGutterComponentEx editorGutterComponentEx;
        void $this$findComponentWithTimeout$iv;
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        LearningUiUtil learningUiUtil = LearningUiUtil.INSTANCE;
        IftTestContainerFixture iftTestContainerFixture = $this$ideFrame;
        Timeout timeout = $this_test.getDefaultTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"<get-defaultTimeout>(...)");
        Timeout timeout$iv = timeout;
        boolean $i$f$findComponentWithTimeout = false;
        try {
            void this_$iv;
            editorGutterComponentEx = this_$iv.waitUntilFound(this_$iv.getRobot(), this_$iv.typeMatcher(EditorGutterComponentEx.class, (Function1)new Function1<EditorGutterComponentEx, Boolean>($this_test){
                final /* synthetic */ TaskTestContext $this_test$inlined;
                {
                    this.$this_test$inlined = taskTestContext;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Component it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EditorGutterComponentEx ui = (EditorGutterComponentEx)it;
                    boolean bl = false;
                    return Intrinsics.areEqual((Object)ui.getEditor(), (Object)this.$this_test$inlined.getEditor());
                }
            }), timeout$iv, (Function0<? extends Collection<? extends Container>>)((Function0)new Function0<Collection<? extends Container>>((IftTestContainerFixture)$this$findComponentWithTimeout$iv){
                final /* synthetic */ IftTestContainerFixture $this_findComponentWithTimeout;
                {
                    this.$this_findComponentWithTimeout = $receiver;
                }

                public final Collection<Container> invoke() {
                    C c = this.$this_findComponentWithTimeout.target();
                    Intrinsics.checkNotNull(c, (String)"null cannot be cast to non-null type java.awt.Container");
                    return CollectionsKt.listOf(c);
                }
            }));
        }
        catch (WaitTimedOutError e$iv) {
            throw new ComponentLookupException("Unable to find " + EditorGutterComponentEx.class.getName() + " in container " + $this$findComponentWithTimeout$iv.target() + " in " + timeout$iv.duration());
        }
        EditorGutterComponentEx gutter = editorGutterComponentEx;
        Rectangle rectangle = this$0.getLineMarkerRect(gutter, this$0.commentText);
        if (rectangle == null) {
            throw new IllegalStateException(("Failed to find '" + this$0.commentText + "' in the editor").toString());
        }
        Rectangle rect = rectangle;
        $this_test.getRobot().click((Component)gutter, new Point((int)rect.getCenterX(), (int)rect.getCenterY()));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$2$1(GitChangelistsAndShelveLesson this$0, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$2$1$0($this$test, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3$1$0(TaskTestContext $this_test, String $newChangelistText, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        Component component2 = $this_test.getPrevious().getUi();
        ActionButton actionButton = component2 instanceof ActionButton ? (ActionButton)component2 : null;
        if (actionButton == null) {
            return Unit.INSTANCE;
        }
        ActionButton changelistsButton = actionButton;
        $this_test.jComponent($this$ideFrame, (Component)changelistsButton).click();
        TaskTestContext.jList$default($this_test, $this$ideFrame, $newChangelistText, null, 2, null).clickItem($newChangelistText);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3$1(String $newChangelistText, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$3$1$0($this$test, $newChangelistText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$4$0(Ref.ObjectRef $newChangeListName, String $defaultChangelistName, TaskRuntimeContext $this$stateCheck) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)$this$stateCheck.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.getChangeListsNumber() == 2) {
            Object v2;
            block3: {
                List list = changeListManager2.getChangeLists();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
                Iterable iterable = list;
                Ref.ObjectRef objectRef = $newChangeListName;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    LocalChangeList it = (LocalChangeList)t;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)$defaultChangelistName))) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            String string = ((LocalChangeList)v2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            objectRef.element = string;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean lessonContent$lambda$0$4$1(TaskRuntimeContext $this$restoreState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        Component component2 = $this$restoreState.getPrevious().getUi();
        boolean it = bl = !(component2 != null ? component2.isShowing() : false);
        boolean bl2 = false;
        if (it) {
            HintManager.getInstance().hideAllHints();
        }
        return bl;
    }

    private static final Unit lessonContent$lambda$0$4$2(Ref.ObjectRef $newChangeListName, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.type((String)$newChangeListName.element);
        $this$test.invokeActionViaShortcut("ENTER");
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$6$0$0(TaskTestContext $this_test, Component $stripe, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        $this_test.jComponent($this$ideFrame, $stripe).click();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$6$0(TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        Component component2 = $this$test.getPrevious().getUi();
        if (component2 == null) {
            throw new IllegalStateException("Not found Commit stripe button".toString());
        }
        Component stripe = component2;
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$6$0$0($this$test, stripe, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$9$0(Ref.ObjectRef $newChangeListName, TaskRuntimeContext $this$treeItem, JTree jTree2, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)$this$treeItem, (String)"$this$treeItem");
        Intrinsics.checkNotNullParameter((Object)jTree2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.contains$default((CharSequence)path.getPathComponent(path.getPathCount() - 1).toString(), (CharSequence)((CharSequence)$newChangeListName.element), (boolean)false, (int)2, null);
    }

    private static final boolean lessonContent$lambda$0$10$1$0$0(Ref.ObjectRef $newChangeListName, Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return Intrinsics.areEqual((Object)item.toString(), (Object)$newChangeListName.element);
    }

    private static final Unit lessonContent$lambda$0$10$1$0(TaskTestContext $this_test, Ref.ObjectRef $newChangeListName, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        GitLessonsUtil.clickTreeRow$default(GitLessonsUtil.INSTANCE, $this_test, false, true, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$10$1$0$0($newChangeListName, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$10$1(Ref.ObjectRef $newChangeListName, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$10$1$0($this$test, $newChangeListName, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lessonContent$lambda$0$11$0$0(TaskTestContext $this_test, IftTestContainerFixture $this$ideFrame) {
        ActionMenuItem actionMenuItem;
        void $this$findComponentWithTimeout$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        TaskTestContext taskTestContext = $this_test;
        IftTestContainerFixture $receiver$iv = $this$ideFrame;
        Timeout timeout = $this$iv.getDefaultTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"<get-defaultTimeout>(...)");
        Timeout timeout$iv = timeout;
        boolean $i$f$jMenuItem = false;
        LearningUiUtil learningUiUtil = LearningUiUtil.INSTANCE;
        IftTestContainerFixture iftTestContainerFixture = $receiver$iv;
        Timeout timeout$iv$iv = timeout$iv;
        boolean $i$f$findComponentWithTimeout = false;
        try {
            void this_$iv$iv;
            actionMenuItem = this_$iv$iv.waitUntilFound(this_$iv$iv.getRobot(), this_$iv$iv.typeMatcher(ActionMenuItem.class, (Function1)new Function1<ActionMenuItem, Boolean>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(Component it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JMenuItem item = (JMenuItem)it;
                    boolean bl2 = false;
                    if (((Component)item).isShowing()) {
                        ActionMenuItem item2 = (ActionMenuItem)item;
                        boolean bl3 = false;
                        if (item2.getAnAction() instanceof ShelveChangesAction) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            }), timeout$iv$iv, (Function0<? extends Collection<? extends Container>>)((Function0)new Function0<Collection<? extends Container>>((IftTestContainerFixture)$this$findComponentWithTimeout$iv$iv){
                final /* synthetic */ IftTestContainerFixture $this_findComponentWithTimeout;
                {
                    this.$this_findComponentWithTimeout = $receiver;
                }

                public final Collection<Container> invoke() {
                    C c = this.$this_findComponentWithTimeout.target();
                    Intrinsics.checkNotNull(c, (String)"null cannot be cast to non-null type java.awt.Container");
                    return CollectionsKt.listOf(c);
                }
            }));
        }
        catch (WaitTimedOutError e$iv$iv) {
            throw new ComponentLookupException("Unable to find " + ActionMenuItem.class.getName() + " in container " + $this$findComponentWithTimeout$iv$iv.target() + " in " + timeout$iv$iv.duration());
        }
        JMenuItem item$iv = (JMenuItem)actionMenuItem;
        new JMenuItemFixture($receiver$iv.robot(), item$iv).click();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$11$0(TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$11$0$0($this$test, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$13$2$0(TaskTestContext $this_test, String $shelveChangesButtonText, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        TaskTestContext.button$default($this_test, $this$ideFrame, $shelveChangesButtonText, null, 2, null).click();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$13$0(GitChangelistsAndShelveLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        if (this$0.backupShelveDialogLocation == null) {
            this$0.backupShelveDialogLocation = LessonUtil.INSTANCE.adjustPopupPosition($this$before, "CommitChangelistDialog2");
        }
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$13$1(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return ShelveChangesManager.getInstance((Project)$this$stateCheck.getProject()).getAllLists().size() == 1;
    }

    private static final Unit lessonContent$lambda$0$13$2(String $shelveChangesButtonText, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$13$2$0($this$test, $shelveChangesButtonText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$15$1$0(TaskTestContext $this_test, String $removeButtonText, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        TaskTestContext.button$default($this_test, $this$ideFrame, $removeButtonText, null, 2, null).click();
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$15$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        Component component2 = $this$stateCheck.getPrevious().getUi();
        return !(component2 != null ? component2.isShowing() : false);
    }

    private static final Unit lessonContent$lambda$0$15$1(String $removeButtonText, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$15$1$0($this$test, $removeButtonText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$16$0(TaskRuntimeContext $this$treeItem, JTree jTree2, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)$this$treeItem, (String)"$this$treeItem");
        Intrinsics.checkNotNullParameter((Object)jTree2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.getPathCount() == 2;
    }

    private static final boolean lessonContent$lambda$0$18$1$0$0(Ref.ObjectRef $newChangeListName, Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return Intrinsics.areEqual((Object)item.toString(), (Object)$newChangeListName.element);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lessonContent$lambda$0$18$1$0(TaskTestContext $this_test, Ref.ObjectRef $newChangeListName, IftTestContainerFixture $this$ideFrame) {
        ActionMenuItem actionMenuItem;
        void $this$findComponentWithTimeout$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        GitLessonsUtil.clickTreeRow$default(GitLessonsUtil.INSTANCE, $this_test, false, true, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$18$1$0$0($newChangeListName, arg_0), 1, null);
        TaskTestContext taskTestContext = $this_test;
        IftTestContainerFixture $receiver$iv = $this$ideFrame;
        Timeout timeout = $this$iv.getDefaultTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"<get-defaultTimeout>(...)");
        Timeout timeout$iv = timeout;
        boolean $i$f$jMenuItem = false;
        LearningUiUtil learningUiUtil = LearningUiUtil.INSTANCE;
        IftTestContainerFixture iftTestContainerFixture = $receiver$iv;
        Timeout timeout$iv$iv = timeout$iv;
        boolean $i$f$findComponentWithTimeout = false;
        try {
            void this_$iv$iv;
            actionMenuItem = this_$iv$iv.waitUntilFound(this_$iv$iv.getRobot(), this_$iv$iv.typeMatcher(ActionMenuItem.class, (Function1)new Function1<ActionMenuItem, Boolean>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(Component it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JMenuItem item = (JMenuItem)it;
                    boolean bl2 = false;
                    if (((Component)item).isShowing()) {
                        ActionMenuItem item2 = (ActionMenuItem)item;
                        boolean bl3 = false;
                        if (item2.getAnAction() instanceof UnshelveWithDialogAction) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            }), timeout$iv$iv, (Function0<? extends Collection<? extends Container>>)((Function0)new Function0<Collection<? extends Container>>((IftTestContainerFixture)$this$findComponentWithTimeout$iv$iv){
                final /* synthetic */ IftTestContainerFixture $this_findComponentWithTimeout;
                {
                    this.$this_findComponentWithTimeout = $receiver;
                }

                public final Collection<Container> invoke() {
                    C c = this.$this_findComponentWithTimeout.target();
                    Intrinsics.checkNotNull(c, (String)"null cannot be cast to non-null type java.awt.Container");
                    return CollectionsKt.listOf(c);
                }
            }));
        }
        catch (WaitTimedOutError e$iv$iv) {
            throw new ComponentLookupException("Unable to find " + ActionMenuItem.class.getName() + " in container " + $this$findComponentWithTimeout$iv$iv.target() + " in " + timeout$iv$iv.duration());
        }
        JMenuItem item$iv = (JMenuItem)actionMenuItem;
        new JMenuItemFixture($receiver$iv.robot(), item$iv).click();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$18$1(Ref.ObjectRef $newChangeListName, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$18$1$0($this$test, $newChangeListName, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$19$2$0(TaskTestContext $this_test, String $unshelveChangesButtonText, IftTestContainerFixture $this$ideFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$ideFrame, (String)"$this$ideFrame");
        TaskTestContext.button$default($this_test, $this$ideFrame, $unshelveChangesButtonText, null, 2, null).click();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$19$0(GitChangelistsAndShelveLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        if (this$0.backupUnshelveDialogLocation == null) {
            this$0.backupUnshelveDialogLocation = LessonUtil.INSTANCE.adjustPopupPosition($this$before, "vcs.ApplyPatchDifferentiatedDialog");
        }
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$19$1(GitChangelistsAndShelveLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        String string = $this$stateCheck.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)this$0.commentText, (boolean)false, (int)2, null);
    }

    private static final Unit lessonContent$lambda$0$19$2(String $unshelveChangesButtonText, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        Thread.sleep(500L);
        $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$19$2$0($this$test, $unshelveChangesButtonText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$0(GitChangelistsAndShelveLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.resetChangelistsState($this$prepareRuntimeTask.getProject());
        this$0.removeShelvedChangeLists($this$prepareRuntimeTask.getProject());
        this$0.modifyFile($this$prepareRuntimeTask.getVirtualFile());
        PsiDocumentManager.getInstance((Project)$this$prepareRuntimeTask.getProject()).commitAllDocuments();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$1(Ref.ObjectRef $highlightLineMarkerTaskId, GitChangelistsAndShelveLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $highlightLineMarkerTaskId.element = $this$task.getTaskId();
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$componentPart = false;
        this_$iv.explicitComponentPartDetection(EditorGutterComponentEx.class, (Function2)new Function2<TaskRuntimeContext, EditorGutterComponentEx, Rectangle>(this$0){
            final /* synthetic */ GitChangelistsAndShelveLesson this$0;
            {
                this.this$0 = gitChangelistsAndShelveLesson;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Rectangle invoke(TaskRuntimeContext $this$explicitComponentPartDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentPartDetection, (String)"$this$explicitComponentPartDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u241_u240 = $this$explicitComponentPartDetection;
                boolean bl = false;
                return !Intrinsics.areEqual((Object)ui.getEditor(), (Object)$this$lessonContent_u24lambda_u240_u241_u240.getEditor()) ? null : GitChangelistsAndShelveLesson.access$getLineMarkerRect(this.this$0, (EditorGutterComponentEx)ui, GitChangelistsAndShelveLesson.access$getCommentText$p(this.this$0));
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$2(GitChangelistsAndShelveLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.introduction", new Object[0]), null, 2, null);
        $this$task.text(GitLessonsBundle.INSTANCE.message("git.changelists.shelf.click.line.marker.balloon", new Object[0]), new LearningBalloonConfig(Balloon.Position.below, 0, false, null, 0, 0, 0, null, null, 508, null));
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                boolean bl;
                block3: {
                    void ui;
                    Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ActionButton actionButton = (ActionButton)it;
                    TaskRuntimeContext $this$lessonContent_u24lambda_u240_u242_u240 = $this$explicitComponentDetection;
                    boolean bl2 = false;
                    AnAction anAction = ui.getAction();
                    ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
                    if (actionGroup == null) {
                        bl = false;
                    } else {
                        ActionGroup group = actionGroup;
                        AnAction[] anActionArray = group.getChildren(null);
                        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
                        Object[] $this$any$iv = anActionArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            AnAction it2 = (AnAction)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getTemplateText(), (Object)VcsBundle.message((String)"ex.new.changelist", (Object[])new Object[0]))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        TaskContext.test$default($this$task, false, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$2$1(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3(Ref.ObjectRef $highlightLineMarkerTaskId, String $defaultChangelistName, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        String string = VcsBundle.message((String)"ex.new.changelist", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String newChangelistText = string;
        Object[] objectArray = new Object[]{$this$task.strong(newChangelistText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.choose.new.changelist", objectArray), null, 2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerUI$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(EditorComponentImpl.class, null, (Function2)new Function2<TaskRuntimeContext, EditorComponentImpl, Boolean>($defaultChangelistName){
            final /* synthetic */ String $defaultChangelistName$inlined;
            {
                this.$defaultChangelistName$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EditorComponentImpl editorComponentImpl = (EditorComponentImpl)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u243_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return StringsKt.contains$default((CharSequence)string, (CharSequence)this.$defaultChangelistName$inlined, (boolean)false, (int)2, null);
            }
        });
        if ($highlightLineMarkerTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"highlightLineMarkerTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$highlightLineMarkerTaskId.element;
        }
        TaskContext.restoreByUi$default($this$task, taskId, 0, null, 6, null);
        TaskContext.test$default($this$task, false, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$3$1(newChangelistText, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$4(Ref.ObjectRef $highlightLineMarkerTaskId, Ref.ObjectRef $newChangeListName, String $defaultChangelistName, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[3];
        objectArray[0] = $this$task.code("Comments");
        objectArray[1] = LessonUtil.INSTANCE.rawEnter();
        String string = CommonBundle.getOkButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOkButtonText(...)");
        objectArray[2] = $this$task.strong(string);
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.create.changelist", objectArray), null, 2, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$4$0($newChangeListName, $defaultChangelistName, arg_0)));
        if ($highlightLineMarkerTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"highlightLineMarkerTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$highlightLineMarkerTaskId.element;
        }
        TaskContext.restoreState$default($this$task, taskId, 0, null, GitChangelistsAndShelveLesson::lessonContent$lambda$0$4$1, 6, null);
        $this$task.test(false, (Function1<? super TaskTestContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$4$2($newChangeListName, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$5(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        HintManager.getInstance().hideAllHints();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$6(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GitLessonsUtil.INSTANCE.openCommitWindow($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.open.commit.window", new Object[0]));
        TaskContext.test$default($this$task, false, GitChangelistsAndShelveLesson::lessonContent$lambda$0$6$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$7(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerUI$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ChangesListView.class, null, (Function2)new Function2<TaskRuntimeContext, ChangesListView, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ChangesListView changesListView = (ChangesListView)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u247_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                ui.expandAll();
                return true;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$8(String $shelfText, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong($shelfText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.explanation", objectArray), null, 2, null);
        LessonUtilKt.proceedLink$default($this$task, 0, 1, null);
        GitLessonsUtil.showWarningIfCommitWindowClosed$default(GitLessonsUtil.INSTANCE, $this$task, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$9(Ref.ObjectRef $letsShelveTaskId, Ref.ObjectRef $newChangeListName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $letsShelveTaskId.element = $this$task.getTaskId();
        TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null).treeItem((Function3<? super TaskRuntimeContext, ? super JTree, ? super TreePath, Boolean>)((Function3)(arg_0, arg_1, arg_2) -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$9$0($newChangeListName, arg_0, arg_1, arg_2)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$10(Ref.ObjectRef $newChangeListName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.open.context.menu", new Object[0]), null, 2, null);
        Object[] objectArray = new Object[]{$this$task.strong((String)$newChangeListName.element)};
        $this$task.text(GitLessonsBundle.INSTANCE.message("git.changelists.shelf.click.changelist.tooltip", objectArray), new LearningBalloonConfig(Balloon.Position.above, 250, false, null, 0, 0, 0, null, null, 508, null));
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionMenuItem.class, null, (Function2)new Function2<TaskRuntimeContext, ActionMenuItem, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionMenuItem actionMenuItem = (ActionMenuItem)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u2410_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                return ui.getAnAction() instanceof ShelveChangesAction;
            }
        });
        GitLessonsUtil.INSTANCE.showWarningIfCommitWindowClosed($this$task, true);
        TaskContext.test$default($this$task, false, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$10$1($newChangeListName, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$11(String $shelfText, Ref.ObjectRef $letsShelveTaskId, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[2];
        String string = ActionsBundle.message((String)"action.ChangesView.Shelve.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        objectArray[1] = $this$task.strong($shelfText);
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.open.shelf.dialog", objectArray), null, 2, null);
        TaskContext.triggerStart$default($this$task, "ChangesView.Shelve", null, 2, null);
        if ($letsShelveTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"letsShelveTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$letsShelveTaskId.element;
        }
        TaskContext.restoreByUi$default($this$task, taskId, LessonUtilKt.getDefaultRestoreDelay(), null, 4, null);
        TaskContext.test$default($this$task, false, GitChangelistsAndShelveLesson::lessonContent$lambda$0$11$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$12(String $shelveChangesButtonText, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(JButton.class, null, (Function2)new Function2<TaskRuntimeContext, JButton, Boolean>($shelveChangesButtonText){
            final /* synthetic */ String $shelveChangesButtonText$inlined;
            {
                this.$shelveChangesButtonText$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JButton jButton = (JButton)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u2412_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)this.$shelveChangesButtonText$inlined, (boolean)false, (int)2, null) : false;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$13(String $shelveChangesButtonText, String $shelfText, Ref.ObjectRef $letsShelveTaskId, GitChangelistsAndShelveLesson this$0, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before((Function1<? super TaskRuntimeContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$13$0(this$0, arg_0)));
        Object[] objectArray = new Object[]{$this$task.strong($shelveChangesButtonText), $this$task.strong($shelfText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.shelve.changelist", objectArray), null, 2, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)GitChangelistsAndShelveLesson::lessonContent$lambda$0$13$1));
        if ($letsShelveTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"letsShelveTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$letsShelveTaskId.element;
        }
        TaskContext.restoreByUi$default($this$task, taskId, 0, null, 6, null);
        TaskContext.test$default($this$task, false, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$13$2($shelveChangesButtonText, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$14(String $removeButtonText, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(JButton.class, null, (Function2)new Function2<TaskRuntimeContext, JButton, Boolean>($removeButtonText){
            final /* synthetic */ String $removeButtonText$inlined;
            {
                this.$removeButtonText$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JButton jButton = (JButton)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u2414_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)this.$removeButtonText$inlined, (boolean)false, (int)2, null) : false;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$15(String $removeButtonText, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong($removeButtonText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.remove.changelist", objectArray), null, 2, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)GitChangelistsAndShelveLesson::lessonContent$lambda$0$15$0));
        $this$task.test(false, (Function1<? super TaskTestContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$15$1($removeButtonText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$16(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null).treeItem((Function3<? super TaskRuntimeContext, ? super JTree, ? super TreePath, Boolean>)((Function3)GitChangelistsAndShelveLesson::lessonContent$lambda$0$16$0));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$17(String $shelfText, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong($shelfText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.performed.explanation", objectArray), null, 2, null);
        objectArray = new Object[]{$this$task.strong($shelfText)};
        LessonUtilKt.gotItStep$default($this$task, Balloon.Position.below, 0, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.performed.got.it", objectArray), null, 0, false, 24, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$18(String $shelfText, String $unshelveChangesButtonText, Ref.ObjectRef $newChangeListName, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.strong($shelfText), $this$task.action(it)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.open.unshelve.dialog", objectArray), null, 2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(JButton.class, null, (Function2)new Function2<TaskRuntimeContext, JButton, Boolean>($unshelveChangesButtonText){
            final /* synthetic */ String $unshelveChangesButtonText$inlined;
            {
                this.$unshelveChangesButtonText$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JButton jButton = (JButton)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u240_u2418_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)this.$unshelveChangesButtonText$inlined, (boolean)false, (int)2, null) : false;
            }
        });
        GitLessonsUtil.showWarningIfCommitWindowClosed$default(GitLessonsUtil.INSTANCE, $this$task, false, 1, null);
        TaskContext.test$default($this$task, false, arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$18$1($newChangeListName, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$19(String $unshelveChangesButtonText, GitChangelistsAndShelveLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before((Function1<? super TaskRuntimeContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$19$0(this$0, arg_0)));
        Object[] objectArray = new Object[]{$this$task.strong($unshelveChangesButtonText)};
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.unshelve.changelist", objectArray), null, 2, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$19$1(this$0, arg_0)));
        String string = VcsBundle.message((String)"vcs.unshelving.changes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GitLessonsUtil.restoreByUiAndBackgroundTask$default(GitLessonsUtil.INSTANCE, $this$task, string, LessonUtilKt.getDefaultRestoreDelay(), null, 4, null);
        $this$task.test(false, (Function1<? super TaskTestContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$19$2($unshelveChangesButtonText, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$20(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default($this$task, GitLessonsBundle.INSTANCE.message("git.changelists.shelf.congratulations", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0(GitChangelistsAndShelveLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        String string = VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String defaultChangelistName = string;
        lessonContext.prepareRuntimeTask(ModalityState.nonModal(), (Function1<? super TaskRuntimeContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$0(this$0, arg_0)));
        GitLessonsUtil.INSTANCE.showWarningIfStagingAreaEnabled(lessonContext);
        Ref.ObjectRef highlightLineMarkerTaskId = new Ref.ObjectRef();
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$1(highlightLineMarkerTaskId, this$0, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$2(this$0, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$3(highlightLineMarkerTaskId, defaultChangelistName, arg_0)));
        Ref.ObjectRef newChangeListName = new Ref.ObjectRef();
        newChangeListName.element = "Comments";
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$4(highlightLineMarkerTaskId, newChangeListName, defaultChangelistName, arg_0)));
        LessonContext.prepareRuntimeTask$default(lessonContext, null, GitChangelistsAndShelveLesson::lessonContent$lambda$0$5, 1, null);
        GitLessonsUtil.INSTANCE.highlightToolWindowStripe(lessonContext, "Commit");
        lessonContext.task("CheckinProject", (Function2<? super TaskContext, ? super String, Unit>)((Function2)GitChangelistsAndShelveLesson::lessonContent$lambda$0$6));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)GitChangelistsAndShelveLesson::lessonContent$lambda$0$7));
        String string2 = VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String shelfText = string2;
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$8(shelfText, arg_0)));
        Ref.ObjectRef letsShelveTaskId = new Ref.ObjectRef();
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$9(letsShelveTaskId, newChangeListName, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$10(newChangeListName, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$11(shelfText, letsShelveTaskId, arg_0)));
        String string3 = VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String shelveChangesButtonText = LessonUtilKt.dropMnemonic(string3);
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$12(shelveChangesButtonText, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$13(shelveChangesButtonText, shelfText, letsShelveTaskId, this$0, arg_0)));
        String string4 = VcsBundle.message((String)"button.remove", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String removeButtonText = string4;
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$14(removeButtonText, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$15(removeButtonText, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)GitChangelistsAndShelveLesson::lessonContent$lambda$0$16));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$17(shelfText, arg_0)));
        String string5 = VcsBundle.message((String)"unshelve.changes.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        String unshelveChangesButtonText = string5;
        lessonContext.task("ShelveChanges.UnshelveWithDialog", (Function2<? super TaskContext, ? super String, Unit>)((Function2)(arg_0, arg_1) -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$18(shelfText, unshelveChangesButtonText, newChangeListName, arg_0, arg_1)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> GitChangelistsAndShelveLesson.lessonContent$lambda$0$19(unshelveChangesButtonText, this$0, arg_0)));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)GitChangelistsAndShelveLesson::lessonContent$lambda$0$20));
        GitLessonsUtil.INSTANCE.restoreCommitWindowStateInformer(lessonContext);
        return Unit.INSTANCE;
    }

    private static final void modifyFile$lambda$0$0(VirtualFile $file, GitChangelistsAndShelveLesson this$0) {
        Document document = FileDocumentManager.getInstance().getDocument($file);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        document2.insertString(document2.getTextLength(), (CharSequence)this$0.fileAddition);
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        int offset = StringsKt.indexOf$default((CharSequence)charSequence, (String)this$0.commentingLineText, (int)0, (boolean)false, (int)6, null);
        if (offset == -1) {
            throw new IllegalStateException(("Not found '" + this$0.commentingLineText + "' item in text").toString());
        }
        document2.insertString(offset + this$0.commentingLineText.length(), (CharSequence)("  " + this$0.commentText));
        FileDocumentManager.getInstance().saveDocument(document2);
    }

    private static final Unit modifyFile$lambda$0(VirtualFile $file, GitChangelistsAndShelveLesson this$0) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> GitChangelistsAndShelveLesson.modifyFile$lambda$0$0($file, this$0));
        return Unit.INSTANCE;
    }

    private static final int getLineMarkerRect$lambda$0(EditorGutterComponentEx $this_getLineMarkerRect, int $offset) {
        int line = $this_getLineMarkerRect.getEditor().offsetToVisualLine($offset, true);
        return $this_getLineMarkerRect.getEditor().visualLineToY(line);
    }

    public static final /* synthetic */ Rectangle access$getLineMarkerRect(GitChangelistsAndShelveLesson $this, EditorGutterComponentEx $receiver, String partOfLine) {
        return $this.getLineMarkerRect($receiver, partOfLine);
    }

    public static final /* synthetic */ String access$getCommentText$p(GitChangelistsAndShelveLesson $this) {
        return $this.commentText;
    }
}

