/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TextComponentAccessor<T extends Component> {
    public static final TextComponentAccessor<JTextField> TEXT_FIELD_SELECTED_TEXT = new TextComponentAccessor<JTextField>(){

        @Override
        public String getText(JTextField textField) {
            String selectedText = textField.getSelectedText();
            return selectedText != null ? selectedText : textField.getText();
        }

        @Override
        public void setText(JTextField textField, @NotNull String text) {
            if (text == null) {
                1.$$$reportNull$$$0(0);
            }
            if (textField.getSelectedText() != null) {
                textField.replaceSelection(text);
            } else {
                textField.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/ui/TextComponentAccessor$1", "setText"));
        }
    };
    public static final TextComponentAccessor<JTextField> TEXT_FIELD_WHOLE_TEXT = new TextComponentAccessor<JTextField>(){

        @Override
        @NotNull
        public String getText(JTextField textField) {
            String string = StringUtil.notNullize((String)textField.getText());
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void setText(JTextField textField, @NotNull String text) {
            if (text == null) {
                2.$$$reportNull$$$0(1);
            }
            textField.setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/TextComponentAccessor$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/TextComponentAccessor$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };
    public static final TextComponentAccessor<JComboBox> STRING_COMBOBOX_WHOLE_TEXT = new TextComponentAccessor<JComboBox>(){

        @Override
        @NotNull
        public String getText(JComboBox comboBox) {
            ComboBoxEditor editor = comboBox.getEditor();
            if (editor == null) {
                return "";
            }
            Object item = editor.getItem();
            if (item == null) {
                return "";
            }
            String string = item.toString();
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void setText(JComboBox comboBox, @NotNull String text) {
            if (text == null) {
                3.$$$reportNull$$$0(1);
            }
            comboBox.getEditor().setItem(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/TextComponentAccessor$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/TextComponentAccessor$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };

    @NlsSafe
    @Nullable
    public String getText(T var1);

    public void setText(T var1, @NlsSafe @NotNull String var2);
}

