/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePermissionManager;
import com.intellij.platform.ide.core.permissions.Permission;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vfs/impl/WriteFilePermission;", "Lcom/intellij/platform/ide/core/permissions/Permission;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "id", "", "getId", "()Ljava/lang/String;", "isGranted", "", "intellij.platform.ide.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWriteFilePermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteFilePermission.kt\ncom/intellij/openapi/vfs/impl/WriteFilePermission\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,20:1\n42#2,3:21\n*S KotlinDebug\n*F\n+ 1 WriteFilePermission.kt\ncom/intellij/openapi/vfs/impl/WriteFilePermission\n*L\n17#1:21,3\n*E\n"})
public final class WriteFilePermission
implements Permission {
    @NotNull
    private final VirtualFile file;

    public WriteFilePermission(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getId() {
        return "w: " + this.file.getPath();
    }

    @Override
    public boolean isGranted() {
        if (!this.file.isWritable()) {
            return false;
        }
        boolean $i$f$service = false;
        Class<FilePermissionManager> serviceClass$iv = FilePermissionManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((FilePermissionManager)object).isWriteGranted(this.file);
    }
}

