/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001$B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001fJ$\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00062\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ui/SpinningProgressIcon;", "Lcom/intellij/ui/AnimatedIcon;", "paths", "", "", "size", "", "<init>", "([Ljava/lang/String;I)V", "[Ljava/lang/String;", "opacities", "", "getOpacities", "()[Ljava/lang/Double;", "iconColor", "Ljava/awt/Color;", "iconCache", "Ljavax/swing/Icon;", "[Ljavax/swing/Icon;", "iconCacheKey", "setIconColor", "", "color", "getIconColor", "createFrame", "Lcom/intellij/ui/AnimatedIcon$Frame;", "i", "getIconFromCache", "createRooTag", "generateSvgIcon", "index", "generateSvgIcon$intellij_platform_ide_core", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "stroke", "CashedDelegateIcon", "intellij.platform.ide.core"})
@ApiStatus.Internal
public final class SpinningProgressIcon
extends AnimatedIcon {
    @NotNull
    private final String[] paths;
    private final int size;
    @NotNull
    private Color iconColor;
    @NotNull
    private final Icon[] iconCache;
    private int iconCacheKey;

    public SpinningProgressIcon(@NotNull String[] paths, int size) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        super(arg_0 -> SpinningProgressIcon._init_$lambda$0(paths, arg_0));
        this.paths = paths;
        this.size = size;
        JBColor jBColor = JBColor.namedColor((String)"ProgressIcon.color", (Color)((Color)new JBColor(11054525, 7304058)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.iconColor = (Color)jBColor;
        this.iconCache = new Icon[this.paths.length];
        this.iconCacheKey = -1;
    }

    public /* synthetic */ SpinningProgressIcon(String[] stringArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            String[] stringArray2 = new String[]{" x=\"7\"       y=\"1\"       width=\"2\" height=\"4\" rx=\"1\" ", " x=\"2.34961\" y=\"3.76416\" width=\"2\" height=\"4\" rx=\"1\" transform=\"rotate(-45 2.34961 3.76416)\" ", " x=\"1\"       y=\"7\"       width=\"4\" height=\"2\" rx=\"1\" ", " x=\"5.17871\" y=\"9.40991\" width=\"2\" height=\"4\" rx=\"1\" transform=\"rotate(45 5.17871 9.40991)\" ", " x=\"7\"       y=\"11\"      width=\"2\" height=\"4\" rx=\"1\" ", " x=\"9.41016\" y=\"10.8242\" width=\"2\" height=\"4\" rx=\"1\" transform=\"rotate(-45 9.41016 10.8242)\" ", " x=\"11\"      y=\"7\"       width=\"4\" height=\"2\" rx=\"1\" ", " x=\"12.2383\" y=\"2.3501\"  width=\"2\" height=\"4\" rx=\"1\" transform=\"rotate(45 12.2383 2.3501)\" "};
            stringArray = stringArray2;
        }
        if ((n2 & 2) != 0) {
            n = 16;
        }
        this(stringArray, n);
    }

    private final Double[] getOpacities() {
        Double[] doubleArray = new Double[]{1.0, 0.93, 0.78, 0.69, 0.62, 0.48, 0.38, 0.3};
        return doubleArray;
    }

    public final void setIconColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.iconColor = color;
    }

    @NotNull
    public final Color getIconColor() {
        return this.iconColor;
    }

    private final AnimatedIcon.Frame createFrame(int i) {
        return new AnimatedIcon.Frame(this, i){
            final /* synthetic */ SpinningProgressIcon this$0;
            final /* synthetic */ int $i;
            {
                this.this$0 = $receiver;
                this.$i = $i;
            }

            public CashedDelegateIcon getIcon() {
                return this.this$0.new CashedDelegateIcon(this.$i);
            }

            public int getDelay() {
                return JBUI.getInt((String)"ProgressIcon.delay", (int)125);
            }
        };
    }

    private final Icon getIconFromCache(int i) {
        Icon icon = this.iconCache[i];
        int cacheKey = this.iconColor.hashCode();
        if (icon != null && this.iconCacheKey == cacheKey) {
            return icon;
        }
        float scale = JBUI.pixScale();
        StringBuilder stringBuilder = new StringBuilder();
        String header = this.createRooTag();
        String string = ColorUtil.toHex((Color)this.iconColor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String stroke = string;
        int n = this.iconCache.length;
        for (int index = 0; index < n; ++index) {
            stringBuilder.setLength(0);
            stringBuilder.append(header);
            this.generateSvgIcon(index, stringBuilder, stroke);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            this.iconCache[index] = IconUtilKt.toRetinaAwareIcon$default((BufferedImage)SvgKt.loadSvg((byte[])StringsKt.encodeToByteArray((String)string2), (float)scale), (float)0.0f, (int)2, null);
        }
        this.iconCacheKey = cacheKey;
        Icon icon2 = this.iconCache[i];
        Intrinsics.checkNotNull((Object)icon2);
        return icon2;
    }

    private final String createRooTag() {
        return "<svg width=\"" + this.size + "\" height=\"" + this.size + "\" viewBox=\"0 0 " + this.size + " " + this.size + "\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\\n";
    }

    @NotNull
    public final String generateSvgIcon$intellij_platform_ide_core(int index) {
        StringBuilder s = new StringBuilder(this.createRooTag());
        String string = ColorUtil.toHex((Color)this.iconColor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        this.generateSvgIcon(index, s, string);
        String string2 = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final void generateSvgIcon(int index, StringBuilder s, String stroke) {
        int n = this.paths.length;
        for (int n2 = 0; n2 < n; ++n2) {
            double opacity = this.getOpacities()[(n2 + index) % this.getOpacities().length];
            s.append("  <rect fill=\"#" + stroke + "\" opacity=\"" + opacity + "\" " + this.paths[n2] + " />").append('\n');
        }
        s.append("</svg>");
    }

    private static final AnimatedIcon.Frame[] _init_$lambda$0(String[] $paths, AnimatedIcon it) {
        int n = 0;
        int n2 = $paths.length;
        AnimatedIcon.Frame[] frameArray = new AnimatedIcon.Frame[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.ui.SpinningProgressIcon");
            frameArray[n3] = ((SpinningProgressIcon)it).createFrame(n3);
        }
        return frameArray;
    }

    public SpinningProgressIcon() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0001H\u0002J,\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/SpinningProgressIcon$CashedDelegateIcon;", "Ljavax/swing/Icon;", "index", "", "<init>", "(Lcom/intellij/ui/SpinningProgressIcon;I)V", "getDelegate", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "intellij.platform.ide.core"})
    private final class CashedDelegateIcon
    implements Icon {
        private final int index;

        public CashedDelegateIcon(int index) {
            this.index = index;
        }

        private final Icon getDelegate() {
            return SpinningProgressIcon.this.getIconFromCache(this.index);
        }

        @Override
        public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
            this.getDelegate().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getDelegate().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getDelegate().getIconHeight();
        }
    }
}

