/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.DiffContentLayoutPanel;
import com.intellij.diff.tools.util.side.DiffContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideContentPanel
extends JPanel {
    @NotNull
    private final DiffSplitter mySplitter;
    @NotNull
    private final List<DiffContentPanel> myPanels;

    public TwosideContentPanel(@NotNull List<? extends JComponent> contents) {
        if (contents == null) {
            TwosideContentPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        assert (contents.size() == 2);
        this.myPanels = ContainerUtil.map(contents, it -> new DiffContentPanel((JComponent)it));
        DiffContentLayoutPanel.syncTitleHeights(this.myPanels);
        this.mySplitter = new DiffSplitter();
        this.mySplitter.setFirstComponent((JComponent)Side.LEFT.select(this.myPanels));
        this.mySplitter.setSecondComponent((JComponent)Side.RIGHT.select(this.myPanels));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.add((Component)((Object)this.mySplitter), "Center");
    }

    public void setTitles(@NotNull List<? extends @Nullable JComponent> titleComponents) {
        if (titleComponents == null) {
            TwosideContentPanel.$$$reportNull$$$0(1);
        }
        for (Side side : Side.values()) {
            DiffContentPanel panel = (DiffContentPanel)((Object)side.select(this.myPanels));
            JComponent title = (JComponent)side.select(titleComponents);
            panel.setTitle(title);
        }
    }

    @ApiStatus.Internal
    public void setBreadcrumbs(@NotNull Side side, @Nullable DiffBreadcrumbsPanel breadcrumbs, final @NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (side == null) {
            TwosideContentPanel.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TwosideContentPanel.$$$reportNull$$$0(3);
        }
        if (breadcrumbs != null) {
            final DiffContentPanel panel = (DiffContentPanel)((Object)side.select(this.myPanels));
            panel.setBreadcrumbs(breadcrumbs);
            panel.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
            settings.addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener.Adapter(){

                @Override
                public void breadcrumbsPlacementChanged() {
                    panel.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
                    TwosideContentPanel.this.repaintDivider();
                }
            }, (Disposable)breadcrumbs);
        }
    }

    public void setBottomAction(@Nullable AnAction value) {
        this.mySplitter.setBottomAction(value);
    }

    public void setTopAction(@Nullable AnAction value) {
        this.mySplitter.setTopAction(value);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPainter(@Nullable DiffSplitter.Painter painter) {
        void painter2;
        ThreadingAssertions.assertEventDispatchThread();
        this.mySplitter.setPainter((DiffSplitter.Painter)painter2);
    }

    public void repaintDivider() {
        this.mySplitter.repaintDivider();
    }

    @NotNull
    public DiffSplitter getSplitter() {
        DiffSplitter diffSplitter = this.mySplitter;
        if (diffSplitter == null) {
            TwosideContentPanel.$$$reportNull$$$0(4);
        }
        return diffSplitter;
    }

    @NotNull
    public static TwosideContentPanel createFromHolders(@NotNull List<? extends EditorHolder> holders) {
        if (holders == null) {
            TwosideContentPanel.$$$reportNull$$$0(5);
        }
        TwosideContentPanel panel = new TwosideContentPanel(ContainerUtil.map(holders, holder -> holder.getComponent()));
        EditorHolder holder2 = (EditorHolder)Side.RIGHT.select(holders);
        panel.mySplitter.redispatchWheelEventsTo(holder2);
        TwosideContentPanel twosideContentPanel = panel;
        if (twosideContentPanel == null) {
            TwosideContentPanel.$$$reportNull$$$0(6);
        }
        return twosideContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/TwosideContentPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/TwosideContentPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTitles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBreadcrumbs";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromHolders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

