/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.settings.DiffPreviewProvider;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class DiffPreviewPanel
implements PreviewPanel {
    private final JPanel myPanel;
    private final MyViewer myViewer;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public DiffPreviewPanel() {
        this.myViewer = new MyViewer();
        this.myViewer.init();
        for (ThreeSide side : ThreeSide.values()) {
            EditorMouseListener motionListener = new EditorMouseListener(side);
            EditorClickListener clickListener = new EditorClickListener(side);
            EditorEx editor = this.myViewer.getEditor(side);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
            editor.addEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
            editor.getCaretModel().addCaretListener((CaretListener)clickListener);
        }
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myViewer.getComponent()).withBorder(IdeBorderFactory.createBorder());
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void updateView() {
        List<SimpleThreesideDiffChange> changes = this.myViewer.getChanges();
        for (SimpleThreesideDiffChange change : changes) {
            change.reinstallHighlighters();
        }
        this.myViewer.repaint();
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        for (EditorEx editorEx : this.myViewer.getEditors()) {
            editorEx.setColorsScheme(editorEx.createBoundColorSchemeDelegate(highlighterSettings));
            editorEx.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
            editorEx.reinitSettings();
        }
    }

    public void addListener(@NotNull ColorAndFontSettingsListener listener) {
        if (listener == null) {
            DiffPreviewPanel.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    private void selectColorForLine(@NotNull ThreeSide side, int line) {
        SimpleThreesideDiffChange change;
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(1);
        }
        if ((change = this.getChange(side, line)) != null) {
            TextDiffTypeFactory.TextDiffTypeImpl diffType = (TextDiffTypeFactory.TextDiffTypeImpl)ObjectUtils.tryCast((Object)change.getDiffType(), TextDiffTypeFactory.TextDiffTypeImpl.class);
            if (diffType != null) {
                ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(diffType.getKey().getExternalName());
            }
            return;
        }
        FoldRegion region = this.getFoldRegion(side, line);
        if (region != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(DiffLineSeparatorRenderer.FOREGROUND.getExternalName());
        }
    }

    @Nullable
    private SimpleThreesideDiffChange getChange(@NotNull ThreeSide side, int line) {
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(2);
        }
        for (SimpleThreesideDiffChange change : this.myViewer.getChanges()) {
            int endLine;
            int startLine = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(line, startLine, endLine = change.getEndLine(side)) || !change.isChange(side)) continue;
            return change;
        }
        return null;
    }

    @Nullable
    private FoldRegion getFoldRegion(@NotNull ThreeSide side, int line) {
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(3);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        for (FoldRegion region : editor.getFoldingModel().getAllFoldRegions()) {
            if (region.isExpanded()) continue;
            int line1 = document.getLineNumber(region.getStartOffset());
            int line2 = document.getLineNumber(region.getEndOffset());
            if (line1 > line || line > line2) continue;
            return region;
        }
        return null;
    }

    public void blinkSelectedHighlightType(Object selected) {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @TestOnly
    @NotNull
    public SimpleThreesideDiffViewer testGetViewer() {
        MyViewer myViewer = this.myViewer;
        if (myViewer == null) {
            DiffPreviewPanel.$$$reportNull$$$0(4);
        }
        return myViewer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "testGetViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectColorForLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegion";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyViewer
    extends SimpleThreesideDiffViewer {
        MyViewer() {
            super((DiffContext)new SampleContext(), (DiffRequest)new SampleRequest());
        }

        @Override
        protected boolean forceRediffSynchronously() {
            return true;
        }

        public void repaint() {
            this.myPanel.repaint();
        }
    }

    private final class EditorMouseListener
    implements EditorMouseMotionListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorMouseListener(ThreeSide side) {
            if (side == null) {
                EditorMouseListener.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            int line;
            if (e == null) {
                EditorMouseListener.$$$reportNull$$$0(1);
            }
            Cursor cursor = DiffPreviewPanel.this.getChange(this.mySide, line = e.getLogicalPosition().line) != null || DiffPreviewPanel.this.getFoldRegion(this.mySide, line) != null ? Cursor.getPredefinedCursor(12) : null;
            ((EditorEx)e.getEditor()).setCustomCursor(DiffPreviewPanel.class, cursor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$EditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class EditorClickListener
    implements CaretListener,
    com.intellij.openapi.editor.event.EditorMouseListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorClickListener(ThreeSide side) {
            if (side == null) {
                EditorClickListener.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e == null) {
                EditorClickListener.$$$reportNull$$$0(1);
            }
            DiffPreviewPanel.this.selectColorForLine(this.mySide, e.getLogicalPosition().line);
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                EditorClickListener.$$$reportNull$$$0(2);
            }
            DiffPreviewPanel.this.selectColorForLine(this.mySide, e.getNewPosition().line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$EditorClickListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SampleContext
    extends DiffContext {
        SampleContext() {
            TextDiffSettingsHolder.TextDiffSettings settings = new TextDiffSettingsHolder.TextDiffSettings();
            settings.setHighlightPolicy(HighlightPolicy.BY_WORD);
            settings.setIgnorePolicy(IgnorePolicy.IGNORE_WHITESPACES);
            settings.setContextRange(2);
            settings.setExpandByDefault(false);
            this.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, settings);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        public boolean isWindowFocused() {
            return false;
        }

        public boolean isFocusedInWindow() {
            return false;
        }

        public void requestFocusInWindow() {
        }
    }

    private static final class SampleRequest
    extends ContentDiffRequest {
        private final List<DiffContent> myContents = Arrays.asList(DiffPreviewProvider.getContents());

        SampleRequest() {
        }

        @NotNull
        public List<DiffContent> getContents() {
            List<DiffContent> list = this.myContents;
            if (list == null) {
                SampleRequest.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<String> getContentTitles() {
            List<String> list = Arrays.asList(null, null, null);
            if (list == null) {
                SampleRequest.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public String getTitle() {
            String string = DiffBundle.message((String)"merge.color.options.dialog.title", (Object[])new Object[0]);
            if (string == null) {
                SampleRequest.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$SampleRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentTitles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

