/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.LookAndFeelThemeAdapter;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.AbstractButtonLayout;
import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxBorder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    private static Icon defaultIconCache;
    private final PropertyChangeListener textChangedListener = e -> DarculaCheckBoxUI.updateTextPosition((AbstractButton)e.getSource());

    public static ComponentUI createUI(JComponent c) {
        return new DarculaCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c) != null) {
            c.setBorder(null);
        }
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        DarculaCheckBoxUI.updateTextPosition(b);
    }

    private static void updateTextPosition(AbstractButton b) {
        b.setVerticalTextPosition(DarculaUIUtil.isMultiLineHTML(b.getText()) ? 1 : 0);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("text", this.textChangedListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton button2) {
        super.uninstallListeners(button2);
        button2.removePropertyChangeListener("text", this.textChangedListener);
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)JBUI.getInt((String)"CheckBox.textIconGap", (int)5));
    }

    @Override
    public void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton button2 = (AbstractButton)c;
        AbstractButtonLayout layout2 = this.createLayout(button2, button2.getSize());
        layout2.paint(g, this.getDisabledTextColor(), this.getMnemonicIndex(button2));
        this.drawCheckIcon(c, g, button2, layout2.iconRect, button2.isSelected(), button2.isEnabled());
    }

    @ApiStatus.Internal
    @NotNull
    public Rectangle getTextRect(@NotNull JCheckBox b) {
        if (b == null) {
            DarculaCheckBoxUI.$$$reportNull$$$0(0);
        }
        Rectangle rectangle = this.createLayout((JComponent)b, (Dimension)b.getSize()).textRect;
        if (rectangle == null) {
            DarculaCheckBoxUI.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        AbstractButtonLayout layout2 = this.createLayout(c, new Dimension(width, height));
        return layout2.getBaseline();
    }

    protected boolean removeInsetsBeforeLayout(AbstractButton b) {
        return !(b.getBorder() instanceof DarculaCheckBoxBorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled2) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
            DarculaUIUtil.Outline op = DarculaUIUtil.getOutline(b);
            boolean hasFocus = op == null && b.hasFocus();
            Icon icon2 = LafIconLookup.getIcon((String)iconName, (selected || this.isIndeterminate(b) ? 1 : 0) != 0, (boolean)hasFocus, (boolean)b.isEnabled());
            icon2.paintIcon(b, g2, iconRect.x, iconRect.y);
            if (op != null) {
                op.setGraphicsColor(g2, b.hasFocus());
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(new RoundRectangle2D.Float(iconRect.x + JBUIScale.scale((int)3), iconRect.y + JBUIScale.scale((int)3), JBUIScale.scale((int)18), JBUIScale.scale((int)18), JBUIScale.scale((int)8), JBUIScale.scale((int)8)), false);
                outline.append(new RoundRectangle2D.Float(iconRect.x + JBUIScale.scale((int)5), iconRect.y + JBUIScale.scale((int)5), JBUIScale.scale((int)14), JBUIScale.scale((int)14), JBUIScale.scale((int)4), JBUIScale.scale((int)4)), false);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.fill(outline);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected int getMnemonicIndex(AbstractButton b) {
        return LookAndFeelThemeAdapter.isAltPressed() ? b.getDisplayedMnemonicIndex() : -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButtonLayout layout2 = this.createLayout(c, new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        return layout2.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Icon getDefaultIcon() {
        int iconSize = JBUI.getInt((String)"CheckBox.iconSize", (int)18);
        if (defaultIconCache == null || defaultIconCache.getIconWidth() != iconSize || defaultIconCache.getIconHeight() != iconSize) {
            defaultIconCache = ((EmptyIcon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)iconSize))).asUIResource();
        }
        return defaultIconCache;
    }

    protected boolean isIndeterminate(AbstractButton checkBox) {
        return "indeterminate".equals(checkBox.getClientProperty("JButton.selectedState")) || checkBox instanceof ThreeStateCheckBox && ((ThreeStateCheckBox)checkBox).getState() == ThreeStateCheckBox.State.DONT_CARE;
    }

    @NotNull
    private AbstractButtonLayout createLayout(JComponent c, Dimension size2) {
        AbstractButton button2 = (AbstractButton)c;
        return new AbstractButtonLayout(button2, size2, this.removeInsetsBeforeLayout(button2), this.getDefaultIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaCheckBoxUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaCheckBoxUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextRect";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

