/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.editorActions.NonWriteAccessTypedHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SlowOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRawTypedHandler
implements TypedActionHandlerEx {
    private final TypedAction myAction;
    private CommandToken myCurrentCommandToken;
    private boolean myInOuterCommand;

    DefaultRawTypedHandler(TypedAction action2) {
        this.myAction = action2;
    }

    public void beforeExecute(@NotNull Editor editor2, char c, @NotNull DataContext context2, @NotNull ActionPlan plan) {
        if (editor2 == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(1);
        }
        if (plan == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor2.isViewer() || !editor2.getDocument().isWritable()) {
            return;
        }
        TypedActionHandler handler2 = this.myAction.getHandler();
        if (handler2 instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)handler2).beforeExecute(editor2, c, context2, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull Editor editor2, char charTyped, @NotNull DataContext dataContext2) {
        if (editor2 == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(4);
        }
        CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (this.myCurrentCommandToken != null) {
            throw new IllegalStateException("Unexpected reentrancy of DefaultRawTypedHandler");
        }
        this.myCurrentCommandToken = commandProcessorEx.startCommand(project2, DefaultRawTypedHandler.commandName(project2), (Object)editor2.getDocument(), UndoConfirmationPolicy.DEFAULT);
        this.myInOuterCommand = this.myCurrentCommandToken == null;
        try {
            FileDocumentManager.WriteAccessStatus writeAccess = FileDocumentManager.getInstance().requestWritingStatus(editor2.getDocument(), editor2.getProject());
            if (!writeAccess.hasWriteAccess()) {
                for (NonWriteAccessTypedHandler handler2 : NonWriteAccessTypedHandler.EP_NAME.getExtensionList()) {
                    if (!handler2.isApplicable(editor2, charTyped, dataContext2)) continue;
                    try (AccessToken ignored = SlowOperations.startSection((String)"action.perform");){
                        handler2.handle(editor2, charTyped, dataContext2);
                    }
                    return;
                }
                HintManager.getInstance().showInformationHint(editor2, writeAccess.getReadOnlyMessage(), writeAccess.getHyperlinkListener());
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                Document doc = editor2.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    this.myAction.getHandler().execute(editor2, charTyped, dataContext2);
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            });
        }
        finally {
            if (!this.myInOuterCommand) {
                commandProcessorEx.finishCommand(this.myCurrentCommandToken, null);
                this.myCurrentCommandToken = null;
            }
            this.myInOuterCommand = false;
        }
    }

    public void beginUndoablePostProcessing() {
        if (this.myInOuterCommand) {
            return;
        }
        if (this.myCurrentCommandToken == null) {
            throw new IllegalStateException("Not in a typed action at this time");
        }
        CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        Project project2 = this.myCurrentCommandToken.getProject();
        if (!DefaultRawTypedHandler.isCommandRestartSupported(project2)) {
            return;
        }
        commandProcessorEx.finishCommand(this.myCurrentCommandToken, null);
        this.myCurrentCommandToken = commandProcessorEx.startCommand(project2, "", null, UndoConfirmationPolicy.DEFAULT);
    }

    @NlsContexts.Command
    @NotNull
    private static String commandName(@Nullable Project project2) {
        UndoManager undoManager;
        UndoManager undoManager2 = undoManager = project2 == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project2);
        if (((UndoManagerImpl)undoManager).isGroupIdChangeSupported()) {
            return "";
        }
        String string = EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]);
        if (string == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isCommandRestartSupported(@Nullable Project project2) {
        UndoManager undoManager = project2 == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project2);
        return ((UndoManagerImpl)undoManager).isCommandRestartSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/DefaultRawTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/DefaultRawTypedHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

