/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.util.Alarm;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ZipperUpdater {
    private final Alarm myAlarm;
    private boolean myRaised;
    private final Object myLock;
    private final int myDelay;
    private final Alarm.ThreadToUse myThreadToUse;

    public ZipperUpdater(int delay, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ZipperUpdater.$$$reportNull$$$0(0);
        }
        this(delay, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public ZipperUpdater(int delay, Alarm.ThreadToUse threadToUse, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ZipperUpdater.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myDelay = delay;
        this.myThreadToUse = threadToUse;
        this.myAlarm = new Alarm(threadToUse, parentDisposable);
    }

    public void queue(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ZipperUpdater.$$$reportNull$$$0(2);
        }
        this.queue(runnable2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final @NotNull Runnable runnable2, boolean urgent, boolean anyModality) {
        if (runnable2 == null) {
            ZipperUpdater.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myAlarm.isDisposed()) {
                return;
            }
            boolean wasRaised = this.myRaised;
            this.myRaised = true;
            if (!wasRaised) {
                Runnable request = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ZipperUpdater.this.myLock;
                        synchronized (object) {
                            if (!ZipperUpdater.this.myRaised) {
                                return;
                            }
                            ZipperUpdater.this.myRaised = false;
                        }
                        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ZipperUpdater.this.myAlarm, (Runnable)runnable2);
                    }

                    public String toString() {
                        return runnable2.toString();
                    }
                };
                this.addRequest(request, urgent, anyModality);
            }
        }
    }

    private void addRequest(@NotNull Runnable request, boolean urgent, boolean anyModality) {
        int delay;
        if (request == null) {
            ZipperUpdater.$$$reportNull$$$0(4);
        }
        int n = delay = urgent ? 0 : this.myDelay;
        if (Alarm.ThreadToUse.SWING_THREAD.equals((Object)this.myThreadToUse)) {
            if (anyModality) {
                this.myAlarm.addRequest(request, delay, ModalityState.any());
            } else if (!ApplicationManager.getApplication().isDispatchThread()) {
                this.myAlarm.addRequest(request, delay, ModalityState.nonModal());
            } else {
                this.myAlarm.addRequest(request, delay);
            }
        } else {
            this.myAlarm.addRequest(request, delay);
        }
    }

    public void stop() {
        this.myAlarm.cancelAllRequests();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ZipperUpdater.$$$reportNull$$$0(5);
        }
        try {
            void unit;
            this.myAlarm.waitForAllExecuted(timeout, (TimeUnit)unit);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/ZipperUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "queue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAllExecuted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

