/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.customization;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.l10n.LocalizationStateService;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.updateSettings.impl.UpdateRequestParametersProvider;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.platform.ide.customization.FeedbackReporter;
import com.intellij.platform.ide.impl.customization.BaseJetBrainsExternalProductResourceUrlsKt;
import com.intellij.platform.ide.impl.customization.JetBrainsFeedbackReporter;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\"\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R1\u0010(\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u0005\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0016\u0010-\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0016\u00101\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0007R\u0016\u00103\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0007R1\u00105\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020\u0005\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010'\u00a8\u00068"}, d2={"Lcom/intellij/platform/ide/impl/customization/BaseJetBrainsExternalProductResourceUrls;", "Lcom/intellij/platform/ide/customization/ExternalProductResourceUrls;", "<init>", "()V", "basePatchDownloadUrl", "Lcom/intellij/util/Url;", "getBasePatchDownloadUrl", "()Lcom/intellij/util/Url;", "youtrackProjectId", "", "getYoutrackProjectId", "()Ljava/lang/String;", "shortProductNameUsedInForms", "getShortProductNameUsedInForms", "productPageUrl", "getProductPageUrl", "baseWebHelpUrl", "getBaseWebHelpUrl", "baseWebSiteUrl", "getBaseWebSiteUrl", "intellijSupportFormId", "", "getIntellijSupportFormId", "()I", "useInIdeGeneralFeedback", "", "getUseInIdeGeneralFeedback", "()Z", "useInIdeEvaluationFeedback", "getUseInIdeEvaluationFeedback", "updateMetadataUrl", "getUpdateMetadataUrl", "computePatchUrl", "from", "Lcom/intellij/openapi/util/BuildNumber;", "to", "bugReportUrl", "Lkotlin/Function1;", "getBugReportUrl", "()Lkotlin/jvm/functions/Function1;", "technicalSupportUrl", "Lkotlin/ParameterName;", "name", "description", "getTechnicalSupportUrl", "feedbackReporter", "Lcom/intellij/platform/ide/customization/FeedbackReporter;", "getFeedbackReporter", "()Lcom/intellij/platform/ide/customization/FeedbackReporter;", "downloadPageUrl", "getDownloadPageUrl", "whatIsNewPageUrl", "getWhatIsNewPageUrl", "helpPageUrl", "topicId", "getHelpPageUrl", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nBaseJetBrainsExternalProductResourceUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseJetBrainsExternalProductResourceUrls.kt\ncom/intellij/platform/ide/impl/customization/BaseJetBrainsExternalProductResourceUrls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public abstract class BaseJetBrainsExternalProductResourceUrls
implements ExternalProductResourceUrls {
    @NotNull
    public abstract Url getBasePatchDownloadUrl();

    @NotNull
    public abstract String getYoutrackProjectId();

    @Nullable
    public abstract String getShortProductNameUsedInForms();

    @NotNull
    public abstract Url getProductPageUrl();

    @Nullable
    public abstract Url getBaseWebHelpUrl();

    @NotNull
    public final Url getBaseWebSiteUrl() {
        String locale;
        StringBuilder stringBuilder;
        String string;
        Map defaultLocales = MapsKt.mapOf((Pair)TuplesKt.to((Object)Region.CHINA, (Object)"zh"));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"en", (Object)"en-us"), TuplesKt.to((Object)"zh", (Object)"zh-cn"), TuplesKt.to((Object)"ja", (Object)"ja-jp"), TuplesKt.to((Object)"ko", (Object)"ko-kr"), TuplesKt.to((Object)"es", (Object)"es-es"), TuplesKt.to((Object)"pt", (Object)"pt-br"), TuplesKt.to((Object)"fr", (Object)"fr-fr"), TuplesKt.to((Object)"de", (Object)"de-de")};
        Map langToUrl = MapsKt.mapOf((Pair[])pairArray);
        Region region = RegionSettings.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region, (String)"getRegion(...)");
        Region currentRegion = region;
        Object object = LocalizationStateService.getInstance();
        if (object != null && (object = object.getSelectedLocale()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String selectedLocale = string;
        StringBuilder $this$_get_baseWebSiteUrl__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_baseWebSiteUrl__u24lambda_u240.append("https://www.jetbrains.com");
        if (currentRegion == Region.CHINA) {
            $this$_get_baseWebSiteUrl__u24lambda_u240.append(".cn");
        }
        if (!Intrinsics.areEqual((Object)selectedLocale, (Object)defaultLocales.getOrDefault(currentRegion, "en")) && (locale = (String)langToUrl.get(selectedLocale)) != null) {
            $this$_get_baseWebSiteUrl__u24lambda_u240.append("/" + locale);
        }
        return Urls.newFromEncoded((String)stringBuilder.toString());
    }

    public int getIntellijSupportFormId() {
        return 66731;
    }

    public boolean getUseInIdeGeneralFeedback() {
        return false;
    }

    public boolean getUseInIdeEvaluationFeedback() {
        return false;
    }

    @NotNull
    public Url getUpdateMetadataUrl() {
        String it = System.getProperty("idea.updates.url", "https://www.jetbrains.com/updates/updates.xml");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        it = Urls.newFromEncoded((String)it);
        boolean bl2 = false;
        Url url = UpdateRequestParametersProvider.passUpdateParameters((Url)it);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"let(...)");
        return url;
    }

    @NotNull
    public final Url computePatchUrl(@NotNull BuildNumber from, @NotNull BuildNumber to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Url url = BaseJetBrainsExternalProductResourceUrlsKt.computeCustomPatchDownloadUrl(from, to);
        if (url == null) {
            Url url2 = this.getBasePatchDownloadUrl().resolve(BaseJetBrainsExternalProductResourceUrlsKt.computePatchFileName(from, to));
            url = url2;
            Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"resolve(...)");
        }
        return url;
    }

    @Nullable
    public Function1<String, Url> getBugReportUrl() {
        return arg_0 -> BaseJetBrainsExternalProductResourceUrls._get_bugReportUrl_$lambda$0(this, arg_0);
    }

    @Nullable
    public Function1<String, Url> getTechnicalSupportUrl() {
        return arg_0 -> BaseJetBrainsExternalProductResourceUrls._get_technicalSupportUrl_$lambda$0(this, arg_0);
    }

    @Nullable
    public FeedbackReporter getFeedbackReporter() {
        JetBrainsFeedbackReporter jetBrainsFeedbackReporter;
        String string = this.getShortProductNameUsedInForms();
        if (string != null) {
            String productName = string;
            boolean bl = false;
            jetBrainsFeedbackReporter = new JetBrainsFeedbackReporter(productName, this.getUseInIdeGeneralFeedback(), this.getUseInIdeEvaluationFeedback());
        } else {
            jetBrainsFeedbackReporter = null;
        }
        return jetBrainsFeedbackReporter;
    }

    @Nullable
    public Url getDownloadPageUrl() {
        return this.getProductPageUrl().resolve("download");
    }

    @Nullable
    public Url getWhatIsNewPageUrl() {
        return this.getProductPageUrl().resolve("whatsnew");
    }

    @Nullable
    public Function1<String, Url> getHelpPageUrl() {
        Function1 function1;
        Url url = this.getBaseWebHelpUrl();
        if (url != null) {
            Url baseUrl = url;
            boolean bl = false;
            function1 = arg_0 -> BaseJetBrainsExternalProductResourceUrls._get_helpPageUrl_$lambda$0$0(baseUrl, arg_0);
        } else {
            function1 = null;
        }
        return function1;
    }

    private static final Url _get_bugReportUrl_$lambda$0(BaseJetBrainsExternalProductResourceUrls this$0, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"project", (Object)this$0.getYoutrackProjectId()), TuplesKt.to((Object)"clearDraft", (Object)"true"), TuplesKt.to((Object)"description", (Object)description), TuplesKt.to((Object)"c", (Object)("Affected versions: " + ApplicationInfo.getInstance().getFullVersion() + " (" + ApplicationInfo.getInstance().getBuild().withoutProductCode() + ")"))};
        Url url = Urls.newFromEncoded((String)"https://youtrack.jetbrains.com/newissue").addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    private static final Url _get_technicalSupportUrl_$lambda$0(BaseJetBrainsExternalProductResourceUrls this$0, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ticket_form_id", (Object)String.valueOf(this$0.getIntellijSupportFormId())), TuplesKt.to((Object)"product", (Object)this$0.getShortProductNameUsedInForms()), TuplesKt.to((Object)"build", (Object)ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode()), TuplesKt.to((Object)"os", (Object)BaseJetBrainsExternalProductResourceUrlsKt.currentOsNameForIntelliJSupport()), TuplesKt.to((Object)"timezone", (Object)System.getProperty("user.timezone"))};
        Url url = Urls.newFromEncoded((String)"https://intellij-support.jetbrains.com/hc/en-us/requests/new").addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    private static final Url _get_helpPageUrl_$lambda$0$0(Url $baseUrl, String topicId) {
        Intrinsics.checkNotNullParameter((Object)topicId, (String)"topicId");
        return $baseUrl.resolve(ApplicationInfo.getInstance().getShortVersion() + "/").addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)topicId, (Object)"")));
    }
}

