/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.platform.ide.menu.ActionAwareIdeMenuBar;
import com.intellij.platform.ide.menu.FloatingMenuBarFlavor;
import com.intellij.platform.ide.menu.IdeJMenuBarKt;
import com.intellij.platform.ide.menu.IdeMenuBarHelper;
import com.intellij.platform.ide.menu.IdeMenuBarHelperKt;
import com.intellij.platform.ide.menu.IdeMenuBarState;
import com.intellij.platform.ide.menu.IdeMenuFlavor;
import com.intellij.platform.ide.menu.JMenuBasedIdeMenuBarHelper;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001=B%\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u000fJ\u000e\u0010/\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u000fJ\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u00102\u001a\u0004\u0018\u00010\bH\u0096@\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0016J\r\u00106\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b9J\u0015\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u001bH\u0011\u00a2\u0006\u0002\b<R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010#\u001a\u00020\u001b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010+\u001a\u00020\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010%\u00a8\u0006>"}, d2={"Lcom/intellij/platform/ide/menu/IdeJMenuBar;", "Ljavax/swing/JMenuBar;", "Lcom/intellij/platform/ide/menu/ActionAwareIdeMenuBar;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "frame", "Ljavax/swing/JFrame;", "customMenuGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljavax/swing/JFrame;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "menuBarHelper", "Lcom/intellij/platform/ide/menu/IdeMenuBarHelper;", "updateGlobalMenuRootsListeners", "", "Ljava/lang/Runnable;", "rootMenuItems", "", "Lcom/intellij/openapi/actionSystem/impl/ActionMenu;", "getRootMenuItems", "()Ljava/util/List;", "add", "Ljavax/swing/JMenu;", "menu", "getBorder", "Ljavax/swing/border/Border;", "isPaintingOrigin", "", "paint", "", "g", "Ljava/awt/Graphics;", "doLayout", "menuSelectionChanged", "isIncluded", "isActivated", "isActivated$intellij_platform_ide_impl", "()Z", "getPreferredSize", "Ljava/awt/Dimension;", "removeNotify", "updateMenuActions", "forceRebuild", "isDarkMenu", "paintComponent", "addUpdateGlobalMenuRootsListener", "runnable", "removeUpdateGlobalMenuRootsListener", "paintBackground", "paintChildren", "getMainMenuActionGroup", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMenuCount", "", "updateGlobalMenuRoots", "updateGlobalMenuRoots$intellij_platform_ide_impl", "doInstallAppMenuIfNeeded", "doInstallAppMenuIfNeeded$intellij_platform_ide_impl", "onToggleFullScreen", "isFullScreen", "onToggleFullScreen$intellij_platform_ide_impl", "JMenuBarImpl", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeJMenuBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeJMenuBar.kt\ncom/intellij/platform/ide/menu/IdeJMenuBar\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n12033#2,10:283\n14060#2:293\n14061#2:295\n12043#2:296\n1#3:294\n*S KotlinDebug\n*F\n+ 1 IdeJMenuBar.kt\ncom/intellij/platform/ide/menu/IdeJMenuBar\n*L\n48#1:283,10\n48#1:293\n48#1:295\n48#1:296\n48#1:294\n*E\n"})
public class IdeJMenuBar
extends JMenuBar
implements ActionAwareIdeMenuBar {
    @JvmField
    @NotNull
    public final CoroutineScope coroutineScope;
    @JvmField
    @NotNull
    public final JFrame frame;
    @Nullable
    private final ActionGroup customMenuGroup;
    @NotNull
    private final IdeMenuBarHelper menuBarHelper;
    @NotNull
    private final List<Runnable> updateGlobalMenuRootsListeners;

    public IdeJMenuBar(@NotNull CoroutineScope coroutineScope, @NotNull JFrame frame, @Nullable ActionGroup customMenuGroup) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.coroutineScope = coroutineScope;
        this.frame = frame;
        this.customMenuGroup = customMenuGroup;
        this.updateGlobalMenuRootsListeners = new ArrayList();
        IdeMenuFlavor flavor2 = CustomWindowHeaderUtil.INSTANCE.isFloatingMenuBarSupported$intellij_platform_ide_impl() ? (IdeMenuFlavor)new FloatingMenuBarFlavor(this) : (IdeMenuFlavor)new IdeMenuFlavor(){

            public void updateAppMenu() {
                IdeJMenuBarKt.doUpdateAppMenu();
            }
        };
        this.menuBarHelper = new JMenuBasedIdeMenuBarHelper(flavor2, new JMenuBarImpl(this));
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            this.setOpaque(false);
        }
    }

    public /* synthetic */ IdeJMenuBar(CoroutineScope coroutineScope, JFrame jFrame, ActionGroup actionGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            actionGroup = null;
        }
        this(coroutineScope, jFrame, actionGroup);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ActionMenu> getRootMenuItems() {
        void $this$mapNotNullTo$iv$iv;
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$mapNotNull$iv = componentArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            ActionMenu it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            Component it = (Component)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof ActionMenu ? (ActionMenu)((Object)it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public JMenu add(@NotNull JMenu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        menu.setFocusable(false);
        JMenu jMenu = super.add(menu);
        Intrinsics.checkNotNullExpressionValue((Object)jMenu, (String)"add(...)");
        return jMenu;
    }

    @Override
    @Nullable
    public Border getBorder() {
        Object state2;
        Object object = this.menuBarHelper;
        if (object == null || (object = ((IdeMenuBarHelper)object).flavor) == null || (object = object.getState()) == null) {
            object = IdeMenuBarState.EXPANDED;
        }
        if ((state2 = object) == IdeMenuBarState.EXPANDING || state2 == IdeMenuBarState.COLLAPSING) {
            return (Border)JBUI.Borders.empty();
        }
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            return (Border)JBUI.Borders.empty();
        }
        if (state2 == IdeMenuBarState.TEMPORARY_EXPANDED && StartupUiUtil.INSTANCE.isDarkTheme()) {
            return JBUI.Borders.customLine((Color)((Color)Gray._75), (int)0, (int)0, (int)1, (int)0);
        }
        if (state2 == IdeMenuBarState.COLLAPSED) {
            return (Border)JBUI.Borders.emptyBottom((int)1);
        }
        UISettings uiSettings = UISettings.Companion.getInstance();
        return uiSettings.getShowMainToolbar() || uiSettings.getShowNavigationBar() ? super.getBorder() : null;
    }

    @Override
    protected boolean isPaintingOrigin() {
        return true;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.menuBarHelper.flavor.getState() != IdeMenuBarState.COLLAPSED) {
            super.paint(g);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.menuBarHelper.flavor.layoutClockPanelAndButton();
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        this.menuBarHelper.flavor.jMenuSelectionChanged(isIncluded);
        super.menuSelectionChanged(isIncluded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isActivated$intellij_platform_ide_impl() {
        int index = this.getSelectionModel().getSelectedIndex();
        if (index == -1) return false;
        JMenu jMenu = this.getMenu(index);
        Intrinsics.checkNotNullExpressionValue((Object)jMenu, (String)"getMenu(...)");
        if (!IdeJMenuBarKt.access$isTryingToShowPopupMenu(jMenu)) return false;
        return true;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        IdeMenuFlavor ideMenuFlavor = this.menuBarHelper.flavor;
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return ideMenuFlavor.getPreferredSize(dimension);
    }

    @Override
    public void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            this.menuBarHelper.flavor.suspendAnimator();
        }
        super.removeNotify();
    }

    @Override
    public void updateMenuActions(boolean forceRebuild) {
        this.menuBarHelper.updateMenuActions(forceRebuild);
    }

    protected boolean isDarkMenu() {
        return false;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.isOpaque()) {
            this.paintBackground(g);
        }
    }

    public final void addUpdateGlobalMenuRootsListener(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.updateGlobalMenuRootsListeners.add(runnable2);
    }

    public final void removeUpdateGlobalMenuRootsListener(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.updateGlobalMenuRootsListeners.remove(runnable2);
    }

    private final void paintBackground(Graphics g) {
        Window window;
        if (IdeFrameDecorator.Companion.isCustomDecorationActive() && (window = SwingUtilities.getWindowAncestor(this)) instanceof IdeFrame && !((IdeFrame)window).isInFullScreen()) {
            return;
        }
        g.setColor(IdeaMenuUI.getMenuBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.menuBarHelper.flavor.getState().isInProgress()) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldTransform = g2.getTransform();
            AffineTransform newTransform = oldTransform == null ? new AffineTransform() : new AffineTransform(oldTransform);
            newTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getHeight() - super.getPreferredSize().height));
            g2.setTransform(newTransform);
            super.paintChildren(g2);
            g2.setTransform(oldTransform);
        } else if (this.menuBarHelper.flavor.getState() != IdeMenuBarState.COLLAPSED) {
            super.paintChildren(g);
        }
    }

    @Nullable
    public Object getMainMenuActionGroup(@NotNull Continuation<? super ActionGroup> $completion) {
        return IdeJMenuBar.getMainMenuActionGroup$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object getMainMenuActionGroup$suspendImpl(IdeJMenuBar $this, Continuation<? super ActionGroup> $completion) {
        ActionGroup actionGroup = $this.customMenuGroup;
        if (actionGroup == null) {
            return IdeMenuBarHelperKt.createIdeMainMenuActionGroup($completion);
        }
        return actionGroup;
    }

    @Override
    public int getMenuCount() {
        return this.menuBarHelper == null ? 0 : this.menuBarHelper.flavor.correctMenuCount(super.getMenuCount());
    }

    public void updateGlobalMenuRoots$intellij_platform_ide_impl() {
        for (Runnable listener2 : this.updateGlobalMenuRootsListeners) {
            listener2.run();
        }
    }

    public void doInstallAppMenuIfNeeded$intellij_platform_ide_impl(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
    }

    @RequiresEdt
    public void onToggleFullScreen$intellij_platform_ide_impl(boolean isFullScreen) {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/ide/menu/IdeJMenuBar$JMenuBarImpl;", "Lcom/intellij/platform/ide/menu/IdeMenuBarHelper$MenuBarImpl;", "bar", "Lcom/intellij/platform/ide/menu/IdeJMenuBar;", "<init>", "(Lcom/intellij/platform/ide/menu/IdeJMenuBar;)V", "frame", "Ljavax/swing/JFrame;", "getFrame", "()Ljavax/swing/JFrame;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "isDarkMenu", "", "()Z", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "updateGlobalMenuRoots", "", "getMainMenuActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class JMenuBarImpl
    implements IdeMenuBarHelper.MenuBarImpl {
        @NotNull
        private final IdeJMenuBar bar;

        public JMenuBarImpl(@NotNull IdeJMenuBar bar2) {
            Intrinsics.checkNotNullParameter((Object)bar2, (String)"bar");
            this.bar = bar2;
        }

        @Override
        @NotNull
        public JFrame getFrame() {
            return this.bar.frame;
        }

        @Override
        @NotNull
        public CoroutineScope getCoroutineScope() {
            return this.bar.coroutineScope;
        }

        public final boolean isDarkMenu() {
            return this.bar.isDarkMenu();
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            return this.bar;
        }

        @Override
        public void updateGlobalMenuRoots() {
            this.bar.updateGlobalMenuRoots$intellij_platform_ide_impl();
        }

        @Override
        @Nullable
        public Object getMainMenuActionGroup(@NotNull Continuation<? super ActionGroup> $completion) {
            ActionGroup actionGroup = this.bar.customMenuGroup;
            if (actionGroup == null) {
                return this.bar.getMainMenuActionGroup($completion);
            }
            return actionGroup;
        }
    }
}

