/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.ShadowJava2DPainterKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001%B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J8\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002JH\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ui/ShadowJava2DPainter;", "", "type", "Lcom/intellij/ui/ShadowJava2DPainter$Type;", "arc", "", "borderColor", "Ljava/awt/Color;", "<init>", "(Lcom/intellij/ui/ShadowJava2DPainter$Type;ILjava/awt/Color;)V", "hideTopCorners", "", "hideBottomSide", "hideSide", "", "topCorners", "bottom", "getInsets", "Ljava/awt/Insets;", "paintShadow", "g", "Ljava/awt/Graphics2D;", "x", "y", "width", "height", "drawCorner", "side", "", "setGradient", "sideKey", "gKey0", "gKey1", "x0", "y0", "x1", "y1", "Type", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ShadowJava2DPainter {
    @NotNull
    private final Type type;
    private final int arc;
    @Nullable
    private final Color borderColor;
    private boolean hideTopCorners;
    private boolean hideBottomSide;

    public ShadowJava2DPainter(@NotNull Type type, int arc, @Nullable Color borderColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.arc = arc;
        this.borderColor = borderColor;
        if (this.arc < 0) {
            throw new IllegalArgumentException("Arc cannot be negative, arc = " + this.arc);
        }
    }

    public /* synthetic */ ShadowJava2DPainter(Type type, int n, Color color, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            color = null;
        }
        this(type, n, color);
    }

    public final void hideSide(boolean topCorners, boolean bottom) {
        this.hideTopCorners = topCorners;
        this.hideBottomSide = bottom;
    }

    @NotNull
    public final Insets getInsets() {
        return this.type.getInsets();
    }

    public final void paintShadow(@NotNull Graphics2D g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Insets insets = this.getInsets();
        int xxLeft = x + insets.left;
        int yyTop = y + insets.top;
        int xxRight = x + width - insets.right;
        int yyBottom = y + height - insets.bottom;
        int widthLR = width - insets.left - insets.right;
        int heightTB = height - insets.top - insets.bottom;
        if (this.arc > 0) {
            g.setColor(this.type.getColor("topLeft", "1"));
            g.fillRect(x + insets.left, y + insets.top, this.arc, this.arc);
            g.setColor(this.type.getColor("topRight", "1"));
            g.fillRect(xxRight - this.arc, y + insets.top, this.arc, this.arc);
            if (!this.hideBottomSide) {
                g.setColor(this.type.getColor("bottomRight", "1"));
                g.fillRect(xxRight - this.arc, yyBottom - this.arc, this.arc, this.arc);
                g.setColor(this.type.getColor("bottomLeft", "1"));
                g.fillRect(x + insets.left, yyBottom - this.arc, this.arc, this.arc);
            }
        }
        this.setGradient(g, "top", "0", "1", xxLeft, y, xxLeft, yyTop);
        g.fillRect(xxLeft, y, widthLR, insets.top);
        if (!this.hideBottomSide) {
            this.setGradient(g, "bottom", "1", "0", xxLeft, yyBottom, xxLeft, y + height);
            g.fillRect(xxLeft, yyBottom, widthLR, insets.bottom);
        }
        int offset = this.hideTopCorners ? JBUI.scale((int)7) : 0;
        this.setGradient(g, "left", "0", "1", x, yyTop + offset, xxLeft, yyTop + offset);
        g.fillRect(x, yyTop + offset, insets.left, heightTB - offset);
        this.setGradient(g, "right", "1", "0", xxRight, yyTop + offset, x + width, yyTop + offset);
        g.fillRect(xxRight, yyTop + offset, insets.right, heightTB - offset);
        if (!this.hideTopCorners) {
            this.drawCorner(g, "topLeft", x, y, insets.left, insets.top);
            this.drawCorner(g, "topRight", xxRight, y, insets.right, insets.top);
        }
        if (!this.hideBottomSide) {
            this.drawCorner(g, "bottomRight", xxRight, yyBottom, insets.right, insets.bottom);
            this.drawCorner(g, "bottomLeft", x, yyBottom, insets.left, insets.bottom);
        }
        if (this.borderColor != null) {
            int one = JBUI.scale((int)1);
            g.setColor(this.borderColor);
            g.drawRect(xxLeft - one, yyTop - one, widthLR + one, heightTB + one);
        }
    }

    private final void drawCorner(Graphics2D g, String side, int x, int y, int width, int height) {
        switch (side) {
            case "topLeft": {
                this.setGradient(g, side, "0", "1", x + width / 2, y + height / 2, x + width, y + height);
                break;
            }
            case "topRight": {
                this.setGradient(g, side, "0", "1", x + width / 2, y + height / 2, x, y + height);
                break;
            }
            case "bottomRight": {
                this.setGradient(g, side, "0", "1", x + width / 2, y + height / 2, x, y);
                break;
            }
            case "bottomLeft": {
                this.setGradient(g, side, "0", "1", x + width / 2, y + height / 2, x + width, y);
            }
        }
        g.fillRect(x, y, width, height);
    }

    private final void setGradient(Graphics2D g, String sideKey, String gKey0, String gKey1, int x0, int y0, int x1, int y1) {
        g.setPaint(new GradientPaint(x0, y0, this.type.getColor(sideKey, gKey0), x1, y1, this.type.getColor(sideKey, gKey1)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bj\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/ShadowJava2DPainter$Type;", "", "uiKeyGroup", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "IDE", "NOTIFICATION", "insets", "Ljava/awt/Insets;", "getInsets", "()Ljava/awt/Insets;", "getColor", "Ljava/awt/Color;", "sideKey", "gradientKey", "intellij.platform.ide.impl"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String uiKeyGroup;
        public static final /* enum */ Type IDE = new Type("Ide");
        public static final /* enum */ Type NOTIFICATION = new Type("Notification");
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(String uiKeyGroup) {
            this.uiKeyGroup = uiKeyGroup;
        }

        @NotNull
        public final Insets getInsets() {
            JBInsets jBInsets = JBUI.insets((String)(this.uiKeyGroup + ".Shadow.borderInsets"), (JBInsets)ShadowJava2DPainterKt.access$getDEF_INSETS$p());
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            return (Insets)jBInsets;
        }

        @NotNull
        public final Color getColor(@NotNull String sideKey, @NotNull String gradientKey) {
            Intrinsics.checkNotNullParameter((Object)sideKey, (String)"sideKey");
            Intrinsics.checkNotNullParameter((Object)gradientKey, (String)"gradientKey");
            JBColor jBColor = JBColor.namedColor((String)(this.uiKeyGroup + ".Shadow." + sideKey + gradientKey + "Color"), (Color)ShadowJava2DPainterKt.access$getDEF_COLOR$p());
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
            return (Color)jBColor;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.IDE, Type.NOTIFICATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

