/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBPanel;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CtxDialogs {
    private static final Logger LOG = Logger.getInstance(CtxDialogs.class);
    private static final int BUTTON_MIN_WIDTH_DLG = 107;
    private static final int BUTTON_BORDER = 16;
    private static final int BUTTON_IMAGE_MARGIN = 2;

    CtxDialogs() {
    }

    @NotNull
    static Disposable showWindowActions(final @NotNull Component contentPane) {
        if (contentPane == null) {
            CtxDialogs.$$$reportNull$$$0(0);
        }
        final DefaultActionGroup actions = new DefaultActionGroup();
        List<AnAction> actionList = CtxDialogs.findAllTouchbarActions(contentPane);
        if (actionList != null) {
            actions.addAll(actionList);
        }
        if (LOG.isDebugEnabled()) {
            if (actionList == null || actionList.isEmpty()) {
                LOG.debug("window '%s' hasn't any touchbar actions", new Object[]{contentPane});
            } else {
                ArrayList leaves = new ArrayList();
                Helpers.collectLeafActions((ActionGroup)actions, leaves);
                LOG.debug("show actions of window '%s' (count=%d):", new Object[]{contentPane, leaves.size()});
                for (AnAction act : leaves) {
                    LOG.debug("\t'%s' | id=%s | %s", new Object[]{act.getTemplateText(), Helpers.getActionId(act), act});
                }
            }
        }
        ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        TBPanel.CrossEscInfo crossEscInfo = CtxDialogs.isCrossEscGroup((ActionGroup)actions) ? new TBPanel.CrossEscInfo(true, false) : null;
        Customizer customizer = new Customizer(crossEscInfo, null){
            @NotNull
            private final WeakReference<Component> myRoot;
            {
                super(crossEscInfo, autoCloseActionIds);
                this.myRoot = new WeakReference<Component>(contentPane);
            }

            @Override
            void onBeforeActionsExpand(@NotNull ActionGroup actionGroup) {
                if (actionGroup == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<AnAction> allActs = CtxDialogs.findAllTouchbarActions((Component)this.myRoot.get());
                actions.removeAll();
                if (allActs != null) {
                    actions.addAll(allActs);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/mac/touchbar/CtxDialogs$1", "onBeforeActionsExpand"));
            }
        };
        customizer.addBaseCustomizations((arg_0, arg_1, arg_2) -> CtxDialogs.lambda$showWindowActions$0((ModalityState)ms, arg_0, arg_1, arg_2));
        TouchBarsManager.registerAndShow(contentPane, (ActionGroup)actions, customizer);
        Disposable disposable = () -> {
            LOG.debug("hide actions of window '%s'", new Object[]{contentPane});
            TouchBarsManager.unregister(contentPane);
        };
        if (disposable == null) {
            CtxDialogs.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    @Nullable
    private static List<AnAction> findAllTouchbarActions(@NotNull Component root) {
        if (root == null) {
            CtxDialogs.$$$reportNull$$$0(2);
        }
        ArrayList<ActionGroup> result2 = null;
        JBIterable iter2 = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root).expandAndFilter(c -> c.isVisible())).traverse();
        for (Component component2 : iter2) {
            ActionGroup group2;
            if (!(component2 instanceof JComponent) || (group2 = Touchbar.getActions((JComponent)((JComponent)component2))) == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<ActionGroup>();
            }
            result2.add(group2);
        }
        return result2;
    }

    private static boolean isCrossEscGroup(@NotNull ActionGroup group2) {
        if (group2 == null) {
            CtxDialogs.$$$reportNull$$$0(3);
        }
        for (AnAction child : group2.getChildren(null)) {
            TouchbarActionCustomizations customizations = TouchbarActionCustomizations.getCustomizations((AnAction)child);
            if (customizations != null && customizations.isCrossEsc()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$showWindowActions$0(ModalityState ms, Customizer.ActionGroupInfo pc, TBItemAnActionButton button2, Presentation presentation2) {
        button2.setModality(ms);
        boolean isDefault = false;
        TouchbarActionCustomizations actionCustomizations = TouchbarActionCustomizations.getCustomizations((AnAction)button2.getAnAction());
        if (actionCustomizations != null) {
            JComponent patt0$temp;
            isDefault = actionCustomizations.isDefault();
            if (!isDefault && (patt0$temp = actionCustomizations.getComponent()) instanceof JButton) {
                JButton jb = (JButton)patt0$temp;
                isDefault = jb.getAction() != null ? jb.getAction().getValue("DefaultAction") != null : jb.isDefaultButton();
            }
            button2.setComponent(actionCustomizations.getComponent());
            button2.setText(actionCustomizations.isShowText() ? presentation2.getText() : null);
            button2.setIcon(actionCustomizations.isShowImage() ? presentation2.getIcon() : null);
            if (actionCustomizations.getComponent() instanceof JButton) {
                button2.setLayout(107, 32768, 2, 16);
            }
        } else {
            TouchbarActionCustomizations parentAc = pc == null ? null : pc.getCustomizations();
            button2.setIconAndTextFromPresentation(presentation2, parentAc);
            button2.setComponent(parentAc == null ? null : parentAc.getComponent());
        }
        if (isDefault) {
            button2.setColored();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/CtxDialogs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDialogs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "showWindowActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showWindowActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAllTouchbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCrossEscGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

