/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StatusText;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class TextComponentEmptyText
extends StatusText {
    public static final String STATUS_VISIBLE_FUNCTION = "StatusVisibleFunction";
    private final JTextComponent myOwner;
    private final boolean myDynamicStatus;
    private String myStatusTriggerText = "";

    TextComponentEmptyText(JTextComponent owner2, boolean dynamicStatus) {
        super(owner2);
        this.myOwner = owner2;
        this.myDynamicStatus = dynamicStatus;
        this.clear();
        this.myOwner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }
        });
    }

    public void setTextToTriggerStatus(@NotNull String defaultText) {
        if (defaultText == null) {
            TextComponentEmptyText.$$$reportNull$$$0(0);
        }
        this.myStatusTriggerText = defaultText;
    }

    @NotNull
    public String getStatusTriggerText() {
        String string = this.myStatusTriggerText;
        if (string == null) {
            TextComponentEmptyText.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void paintStatusText(Graphics g) {
        if (!this.isFontSet()) {
            this.setFont(this.myOwner.getFont());
        }
        this.paint(this.myOwner, g);
    }

    public void resetFontToOwnerFont() {
        this.setFont(this.myOwner.getFont());
    }

    @Override
    protected boolean isStatusVisible() {
        Object function;
        if (this.myDynamicStatus && (function = this.myOwner.getClientProperty(STATUS_VISIBLE_FUNCTION)) instanceof Predicate) {
            return ((Predicate)function).test(this.myOwner);
        }
        return this.myOwner.getText().equals(this.myStatusTriggerText) && !this.myOwner.isFocusOwner();
    }

    @Override
    protected Rectangle getTextComponentBound() {
        Rectangle b = this.myOwner.getBounds();
        Insets insets = (Insets)ObjectUtils.notNull((Object)this.myOwner.getInsets(), (Object)JBInsets.emptyInsets());
        Insets margin = (Insets)ObjectUtils.notNull((Object)this.myOwner.getMargin(), (Object)JBInsets.emptyInsets());
        Insets ipad = this.getComponent().getIpad();
        int left = insets.left + margin.left - ipad.left;
        int right = insets.right + margin.right - ipad.right;
        int top = insets.top + margin.top - ipad.top;
        int bottom = insets.bottom + margin.bottom - ipad.bottom;
        return new Rectangle(left, top, b.width - left - right, b.height - top - bottom);
    }

    @Override
    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        if (component == null) {
            TextComponentEmptyText.$$$reportNull$$$0(2);
        }
        if (bounds == null) {
            TextComponentEmptyText.$$$reportNull$$$0(3);
        }
        Dimension size = component.getPreferredSize();
        int width = Math.min(size.width, bounds.width);
        return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, width, bounds.height) : new Rectangle(bounds.x + bounds.width - width, bounds.y, width, bounds.height);
    }

    public static void setupPlaceholderVisibility(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            TextComponentEmptyText.$$$reportNull$$$0(4);
        }
        textComponent.putClientProperty(STATUS_VISIBLE_FUNCTION, f -> StringUtil.isEmpty((String)f.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/TextComponentEmptyText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/TextComponentEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusTriggerText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTextToTriggerStatus";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupPlaceholderVisibility";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

