/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.builders;

import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsX;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010 \u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\"0!J\u001a\u0010#\u001a\u00020\u00002\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u001cJ`\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/2\n\b\u0002\u00101\u001a\u0004\u0018\u000102JN\u00103\u001a\u0002042\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/2\n\b\u0002\u00101\u001a\u0004\u0018\u000102JL\u00105\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/JL\u00106\u001a\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/J\u0010\u00107\u001a\u00020\u00002\b\b\u0002\u00108\u001a\u00020\rJ\u000e\u00109\u001a\u00020:2\u0006\u0010$\u001a\u00020%J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010<\u001a\u00020:J\b\u0010=\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016*\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/ui/dsl/gridLayout/builders/RowsGridBuilder;", "", "panel", "Ljavax/swing/JComponent;", "grid", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/ui/dsl/gridLayout/Grid;)V", "layout", "Lcom/intellij/ui/dsl/gridLayout/GridLayout;", "getGrid", "()Lcom/intellij/ui/dsl/gridLayout/Grid;", "value", "", "columnsCount", "getColumnsCount", "()I", "resizableColumns", "", "getResizableColumns$delegate", "(Lcom/intellij/ui/dsl/gridLayout/builders/RowsGridBuilder;)Ljava/lang/Object;", "getResizableColumns", "()Ljava/util/Set;", "defaultHorizontalAlign", "Lcom/intellij/ui/dsl/gridLayout/HorizontalAlign;", "defaultVerticalAlign", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "defaultBaselineAlign", "", "x", "getX", "y", "columnsGaps", "", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "row", "rowGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "resizable", "cell", "component", "width", "horizontalAlign", "verticalAlign", "baselineAlign", "resizableColumn", "gaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGaps;", "visualPaddings", "widthGroup", "", "constraints", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "subGrid", "subGridBuilder", "skip", "count", "setRowGaps", "", "resizableRow", "addResizableColumn", "startFirstRow", "intellij.platform.ide"})
@ApiStatus.Experimental
@ApiStatus.Internal
public final class RowsGridBuilder {
    @NotNull
    private final JComponent panel;
    @NotNull
    private final GridLayout layout;
    @NotNull
    private final Grid grid;
    private int columnsCount;
    @NotNull
    private HorizontalAlign defaultHorizontalAlign;
    @NotNull
    private VerticalAlign defaultVerticalAlign;
    private boolean defaultBaselineAlign;
    private int x;
    private int y;

    public RowsGridBuilder(@NotNull JComponent panel2, @Nullable Grid grid) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        LayoutManager layoutManager = this.panel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.GridLayout");
        this.layout = (GridLayout)layoutManager;
        Grid grid2 = grid;
        if (grid2 == null) {
            grid2 = this.layout.getRootGrid();
        }
        this.grid = grid2;
        this.defaultHorizontalAlign = HorizontalAlign.LEFT;
        this.defaultVerticalAlign = VerticalAlign.CENTER;
        this.y = -1;
    }

    public /* synthetic */ RowsGridBuilder(JComponent jComponent, Grid grid, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            grid = null;
        }
        this(jComponent, grid);
    }

    @NotNull
    public final Grid getGrid() {
        return this.grid;
    }

    public final int getColumnsCount() {
        return this.columnsCount;
    }

    @NotNull
    public final Set<Integer> getResizableColumns() {
        return this.grid.getResizableColumns();
    }

    private static Object getResizableColumns$delegate(RowsGridBuilder rowsGridBuilder) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)rowsGridBuilder.grid, Grid.class, "resizableColumns", "getResizableColumns()Ljava/util/Set;", 0)));
    }

    public final int getX() {
        return this.x;
    }

    @NotNull
    public final RowsGridBuilder columnsGaps(@NotNull List<? extends UnscaledGapsX> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.grid.getColumnsGaps().clear();
        this.grid.getColumnsGaps().addAll((Collection<UnscaledGapsX>)value2);
        return this;
    }

    @NotNull
    public final RowsGridBuilder row(@NotNull UnscaledGapsY rowGaps, boolean resizable) {
        Intrinsics.checkNotNullParameter((Object)rowGaps, (String)"rowGaps");
        this.x = 0;
        int n = this.y;
        this.y = n + 1;
        this.setRowGaps(rowGaps);
        if (resizable) {
            this.resizableRow();
        }
        return this;
    }

    public static /* synthetic */ RowsGridBuilder row$default(RowsGridBuilder rowsGridBuilder, UnscaledGapsY unscaledGapsY, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            unscaledGapsY = UnscaledGapsY.EMPTY;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return rowsGridBuilder.row(unscaledGapsY, bl);
    }

    @NotNull
    public final RowsGridBuilder cell(@NotNull JComponent component, int width, @NotNull HorizontalAlign horizontalAlign, @NotNull VerticalAlign verticalAlign, boolean baselineAlign, boolean resizableColumn, @NotNull UnscaledGaps gaps, @NotNull UnscaledGaps visualPaddings, @Nullable String widthGroup) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlign), (String)"horizontalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
        Intrinsics.checkNotNullParameter((Object)visualPaddings, (String)"visualPaddings");
        if (this.y == -1) {
            this.y = 0;
        }
        if (resizableColumn) {
            this.addResizableColumn();
        }
        Constraints constraints = new Constraints(this.grid, this.x, this.y, width, 0, horizontalAlign, verticalAlign, baselineAlign, gaps, visualPaddings, widthGroup, 16, null);
        this.panel.add((Component)component, constraints);
        return this.skip(width);
    }

    public static /* synthetic */ RowsGridBuilder cell$default(RowsGridBuilder rowsGridBuilder, JComponent jComponent, int n, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, boolean bl, boolean bl2, UnscaledGaps unscaledGaps, UnscaledGaps unscaledGaps2, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            horizontalAlign = rowsGridBuilder.defaultHorizontalAlign;
        }
        if ((n2 & 8) != 0) {
            verticalAlign = rowsGridBuilder.defaultVerticalAlign;
        }
        if ((n2 & 0x10) != 0) {
            bl = rowsGridBuilder.defaultBaselineAlign;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            unscaledGaps = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x80) != 0) {
            unscaledGaps2 = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x100) != 0) {
            string = null;
        }
        return rowsGridBuilder.cell(jComponent, n, horizontalAlign, verticalAlign, bl, bl2, unscaledGaps, unscaledGaps2, string);
    }

    @NotNull
    public final Constraints constraints(int width, @NotNull HorizontalAlign horizontalAlign, @NotNull VerticalAlign verticalAlign, boolean baselineAlign, @NotNull UnscaledGaps gaps, @NotNull UnscaledGaps visualPaddings, @Nullable String widthGroup) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlign), (String)"horizontalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
        Intrinsics.checkNotNullParameter((Object)visualPaddings, (String)"visualPaddings");
        if (this.y == -1) {
            this.y = 0;
        }
        Constraints result2 = new Constraints(this.grid, this.x, this.y, width, 0, horizontalAlign, verticalAlign, baselineAlign, gaps, visualPaddings, widthGroup, 16, null);
        this.skip(width);
        return result2;
    }

    public static /* synthetic */ Constraints constraints$default(RowsGridBuilder rowsGridBuilder, int n, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, boolean bl, UnscaledGaps unscaledGaps, UnscaledGaps unscaledGaps2, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            horizontalAlign = rowsGridBuilder.defaultHorizontalAlign;
        }
        if ((n2 & 4) != 0) {
            verticalAlign = rowsGridBuilder.defaultVerticalAlign;
        }
        if ((n2 & 8) != 0) {
            bl = rowsGridBuilder.defaultBaselineAlign;
        }
        if ((n2 & 0x10) != 0) {
            unscaledGaps = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x20) != 0) {
            unscaledGaps2 = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x40) != 0) {
            string = null;
        }
        return rowsGridBuilder.constraints(n, horizontalAlign, verticalAlign, bl, unscaledGaps, unscaledGaps2, string);
    }

    @NotNull
    public final Grid subGrid(int width, @NotNull HorizontalAlign horizontalAlign, @NotNull VerticalAlign verticalAlign, boolean baselineAlign, boolean resizableColumn, @NotNull UnscaledGaps gaps, @NotNull UnscaledGaps visualPaddings) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlign), (String)"horizontalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
        Intrinsics.checkNotNullParameter((Object)visualPaddings, (String)"visualPaddings");
        this.startFirstRow();
        if (resizableColumn) {
            this.addResizableColumn();
        }
        Constraints constraints = new Constraints(this.grid, this.x, this.y, width, 0, horizontalAlign, verticalAlign, baselineAlign, gaps, visualPaddings, null, 1040, null);
        this.skip(width);
        return this.layout.addLayoutSubGrid(constraints);
    }

    public static /* synthetic */ Grid subGrid$default(RowsGridBuilder rowsGridBuilder, int n, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, boolean bl, boolean bl2, UnscaledGaps unscaledGaps, UnscaledGaps unscaledGaps2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            horizontalAlign = rowsGridBuilder.defaultHorizontalAlign;
        }
        if ((n2 & 4) != 0) {
            verticalAlign = rowsGridBuilder.defaultVerticalAlign;
        }
        if ((n2 & 8) != 0) {
            bl = rowsGridBuilder.defaultBaselineAlign;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            unscaledGaps = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x40) != 0) {
            unscaledGaps2 = UnscaledGaps.EMPTY;
        }
        return rowsGridBuilder.subGrid(n, horizontalAlign, verticalAlign, bl, bl2, unscaledGaps, unscaledGaps2);
    }

    @NotNull
    public final RowsGridBuilder subGridBuilder(int width, @NotNull HorizontalAlign horizontalAlign, @NotNull VerticalAlign verticalAlign, boolean baselineAlign, boolean resizableColumn, @NotNull UnscaledGaps gaps, @NotNull UnscaledGaps visualPaddings) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlign), (String)"horizontalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
        Intrinsics.checkNotNullParameter((Object)visualPaddings, (String)"visualPaddings");
        return new RowsGridBuilder(this.panel, this.subGrid(width, horizontalAlign, verticalAlign, baselineAlign, resizableColumn, gaps, visualPaddings)).defaultHorizontalAlign(this.defaultHorizontalAlign).defaultVerticalAlign(this.defaultVerticalAlign).defaultBaselineAlign(this.defaultBaselineAlign);
    }

    public static /* synthetic */ RowsGridBuilder subGridBuilder$default(RowsGridBuilder rowsGridBuilder, int n, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, boolean bl, boolean bl2, UnscaledGaps unscaledGaps, UnscaledGaps unscaledGaps2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            horizontalAlign = rowsGridBuilder.defaultHorizontalAlign;
        }
        if ((n2 & 4) != 0) {
            verticalAlign = rowsGridBuilder.defaultVerticalAlign;
        }
        if ((n2 & 8) != 0) {
            bl = rowsGridBuilder.defaultBaselineAlign;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            unscaledGaps = UnscaledGaps.EMPTY;
        }
        if ((n2 & 0x40) != 0) {
            unscaledGaps2 = UnscaledGaps.EMPTY;
        }
        return rowsGridBuilder.subGridBuilder(n, horizontalAlign, verticalAlign, bl, bl2, unscaledGaps, unscaledGaps2);
    }

    @NotNull
    public final RowsGridBuilder skip(int count) {
        this.x += count;
        this.columnsCount = Math.max(this.columnsCount, this.x);
        return this;
    }

    public static /* synthetic */ RowsGridBuilder skip$default(RowsGridBuilder rowsGridBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return rowsGridBuilder.skip(n);
    }

    public final void setRowGaps(@NotNull UnscaledGapsY rowGaps) {
        Intrinsics.checkNotNullParameter((Object)rowGaps, (String)"rowGaps");
        this.startFirstRow();
        while (this.grid.getRowsGaps().size() <= this.y) {
            this.grid.getRowsGaps().add(UnscaledGapsY.EMPTY);
        }
        this.grid.getRowsGaps().set(this.y, rowGaps);
    }

    private final RowsGridBuilder defaultHorizontalAlign(HorizontalAlign defaultHorizontalAlign) {
        this.defaultHorizontalAlign = defaultHorizontalAlign;
        return this;
    }

    @NotNull
    public final RowsGridBuilder defaultVerticalAlign(@NotNull VerticalAlign defaultVerticalAlign) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultVerticalAlign), (String)"defaultVerticalAlign");
        this.defaultVerticalAlign = defaultVerticalAlign;
        return this;
    }

    @NotNull
    public final RowsGridBuilder defaultBaselineAlign(boolean defaultBaselineAlign) {
        this.defaultBaselineAlign = defaultBaselineAlign;
        return this;
    }

    @NotNull
    public final RowsGridBuilder resizableRow() {
        this.startFirstRow();
        ((Collection)this.grid.getResizableRows()).add(this.y);
        return this;
    }

    public final void addResizableColumn() {
        ((Collection)this.grid.getResizableColumns()).add(this.x);
    }

    private final void startFirstRow() {
        if (this.y == -1) {
            this.y = 0;
        }
    }
}

