/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(forRemoval=true)
public final class IdeaWideProxySelector
extends ProxySelector {
    private static final Logger LOG = Logger.getInstance(IdeaWideProxySelector.class);
    private static final String DOCUMENT_BUILDER_FACTORY_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static volatile long ourProxyAutoDetectDurationMs = -1L;
    private final HttpConfigurable myHttpConfigurable;
    private final AtomicReference<Pair<ProxySelector, String>> myPacProxySelector;

    public IdeaWideProxySelector(@NotNull HttpConfigurable configurable) {
        if (configurable == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(0);
        }
        this.myPacProxySelector = new AtomicReference();
        this.myHttpConfigurable = configurable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(@NotNull URI uri) {
        if (uri == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(1);
        }
        LOG.debug("IDEA-wide proxy selector asked for " + String.valueOf(uri));
        String scheme = uri.getScheme();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            LOG.debug("No proxy: not http/https scheme: " + scheme);
            return CommonProxy.NO_PROXY_LIST;
        }
        if (this.myHttpConfigurable.USE_HTTP_PROXY) {
            if (this.myHttpConfigurable.isProxyException(uri)) {
                LOG.debug("No proxy: URI '", new Object[]{uri, "' matches proxy exceptions [", this.myHttpConfigurable.PROXY_EXCEPTIONS, "]"});
                return CommonProxy.NO_PROXY_LIST;
            }
            if (this.myHttpConfigurable.PROXY_PORT < 0 || this.myHttpConfigurable.PROXY_PORT > 65535) {
                LOG.debug("No proxy: invalid port: " + this.myHttpConfigurable.PROXY_PORT);
                return CommonProxy.NO_PROXY_LIST;
            }
            Proxy.Type type = this.myHttpConfigurable.PROXY_TYPE_IS_SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
            Proxy proxy = new Proxy(type, new InetSocketAddress(this.myHttpConfigurable.PROXY_HOST, this.myHttpConfigurable.PROXY_PORT));
            LOG.debug("Defined proxy: ", new Object[]{proxy});
            this.myHttpConfigurable.LAST_ERROR = null;
            return Collections.singletonList(proxy);
        }
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            String oldDocumentBuilderFactory = System.setProperty(DOCUMENT_BUILDER_FACTORY_KEY, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            try {
                List<Proxy> proxy = this.selectUsingPac(uri);
                return proxy;
            }
            catch (Throwable e) {
                LOG.error("Cannot select using PAC", e);
            }
            finally {
                SystemProperties.setProperty((String)DOCUMENT_BUILDER_FACTORY_KEY, (String)oldDocumentBuilderFactory);
            }
        }
        return CommonProxy.NO_PROXY_LIST;
    }

    @NotNull
    private List<Proxy> selectUsingPac(@NotNull URI uri) {
        ProxySelector pacProxySelector;
        if (uri == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(2);
        }
        String pacUrlForUse = this.myHttpConfigurable.USE_PAC_URL && !StringUtil.isEmpty((String)this.myHttpConfigurable.PAC_URL) ? this.myHttpConfigurable.PAC_URL : null;
        Pair pair = this.myPacProxySelector.get();
        if (pair != null && !Objects.equals(pair.second, pacUrlForUse)) {
            pair = null;
        }
        if (pair == null) {
            long searchStartMs = System.currentTimeMillis();
            ProxySelector newProxySelector = NetUtils.getProxySelector((String)pacUrlForUse);
            if (pacUrlForUse == null) {
                ourProxyAutoDetectDurationMs = System.currentTimeMillis() - searchStartMs;
            }
            pair = Pair.create((Object)newProxySelector, (Object)pacUrlForUse);
            this.myPacProxySelector.lazySet((Pair<ProxySelector, String>)pair);
        }
        if ((pacProxySelector = (ProxySelector)pair.first) == null) {
            LOG.debug("No proxies detected");
        } else {
            List<Proxy> list;
            try {
                List<Proxy> select = pacProxySelector.select(uri);
                LOG.debug("Autodetected proxies: ", new Object[]{select});
                list = select;
            }
            catch (StackOverflowError ignore) {
                LOG.warn("Too large PAC script (JRE-247)");
            }
            if (list == null) {
                IdeaWideProxySelector.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = CommonProxy.NO_PROXY_LIST;
        if (list == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        InetSocketAddress isa;
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            this.myHttpConfigurable.removeGeneric(new CommonProxy.HostInfo(uri.getScheme(), uri.getHost(), uri.getPort()));
            LOG.debug("generic proxy credentials (if were saved) removed");
            return;
        }
        InetSocketAddress inetSocketAddress = isa = sa instanceof InetSocketAddress ? (InetSocketAddress)sa : null;
        if (this.myHttpConfigurable.USE_HTTP_PROXY && isa != null && Objects.equals(this.myHttpConfigurable.PROXY_HOST, isa.getHostString())) {
            LOG.debug("connection failed message passed to http configurable");
            this.myHttpConfigurable.LAST_ERROR = ioe.getMessage();
        }
    }

    @ApiStatus.Internal
    public static long getProxyAutoDetectDurationMs() {
        return ourProxyAutoDetectDurationMs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/IdeaWideProxySelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/IdeaWideProxySelector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "selectUsingPac";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectUsingPac";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

