/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.net.CustomizedPlatformJdkProxyProvider;
import com.intellij.util.net.HttpProxyConfigurable;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \n2\u00020\u0001:\u0001\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0001\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/net/JdkProxyProvider;", "", "proxySelector", "Ljava/net/ProxySelector;", "getProxySelector", "()Ljava/net/ProxySelector;", "authenticator", "Ljava/net/Authenticator;", "getAuthenticator", "()Ljava/net/Authenticator;", "Companion", "Lcom/intellij/util/net/CustomizedPlatformJdkProxyProvider;", "intellij.platform.ide"})
public sealed interface JdkProxyProvider
permits CustomizedPlatformJdkProxyProvider {
    @NotNull
    public static final Companion Companion = com.intellij.util.net.JdkProxyProvider$Companion.$$INSTANCE;

    @NotNull
    public ProxySelector getProxySelector();

    @NotNull
    public Authenticator getAuthenticator();

    @JvmStatic
    @NotNull
    public static JdkProxyProvider getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static void ensureDefault() {
        Companion.ensureDefault();
    }

    @JvmStatic
    @ApiStatus.Internal
    public static void showProxyAuthNotification() {
        Companion.showProxyAuthNotification();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0007H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/net/JdkProxyProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/util/net/JdkProxyProvider;", "ensureDefault", "", "javaProxyInstallationFlag", "", "proxyAuthNotificationActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ensureDefaultProxyProviderImpl", "showProxyAuthNotification", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nJdkProxyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkProxyProvider.kt\ncom/intellij/util/net/JdkProxyProvider$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,150:1\n13#2:151\n13#2:152\n*S KotlinDebug\n*F\n+ 1 JdkProxyProvider.kt\ncom/intellij/util/net/JdkProxyProvider$Companion\n*L\n68#1:151\n78#1:152\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static boolean javaProxyInstallationFlag;
        @NotNull
        private static final AtomicBoolean proxyAuthNotificationActive;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JdkProxyProvider getInstance() {
            return CustomizedPlatformJdkProxyProvider.INSTANCE;
        }

        @JvmStatic
        public final void ensureDefault() {
            this.ensureDefaultProxyProviderImpl();
        }

        private final synchronized void ensureDefaultProxyProviderImpl() {
            Authenticator defaultAuthenticator;
            JdkProxyProvider provider = this.getInstance();
            ProxySelector proxySelector = provider.getProxySelector();
            Authenticator authenticator2 = provider.getAuthenticator();
            if (!javaProxyInstallationFlag) {
                ProxySelector.setDefault(proxySelector);
                Authenticator.setDefault(authenticator2);
                javaProxyInstallationFlag = true;
                return;
            }
            ProxySelector defaultProxySelector = ProxySelector.getDefault();
            if (defaultProxySelector != proxySelector) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ProxySelector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(StringsKt.trimIndent((String)("\n      ProxySelector.setDefault() was changed to [" + defaultProxySelector + "] - other than [" + proxySelector + "].\n      This will make some " + ApplicationNamesInfo.getInstance().getProductName() + " network calls fail.\n      Instead, ProxyService.instance.proxySelector should be the default proxy selector.\n      ")));
                ProxySelector.setDefault(proxySelector);
            }
            if ((defaultAuthenticator = Authenticator.getDefault()) != authenticator2) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ProxySelector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(StringsKt.trimIndent((String)("\n      Authenticator.setDefault() was changed to [" + defaultAuthenticator + "] - other than [" + authenticator2 + "].\n      This may make some " + ApplicationNamesInfo.getInstance().getProductName() + " network calls fail.\n      Instead, ProxyService.instance.authenticator should be used as a default proxy authenticator.\n      ")));
                Authenticator.setDefault(authenticator2);
            }
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void showProxyAuthNotification() {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return;
            }
            Application app = application;
            if (proxyAuthNotificationActive.getAndSet(true)) {
                return;
            }
            String string = UIBundle.message("proxy.auth.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String string2 = UIBundle.message("proxy.auth.notification.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String content = string2;
            Notification notification = new Notification("proxy.auth.failed", title, content, NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)UIBundle.message("proxy.auth.notification.action", new Object[0]), Companion::showProxyAuthNotification$lambda$0)).whenExpired(Companion::showProxyAuthNotification$lambda$1);
            app.invokeLater(() -> Companion.showProxyAuthNotification$lambda$2(notification), ModalityState.nonModal());
        }

        private static final void showProxyAuthNotification$lambda$0(AnActionEvent e, Notification notification) {
            ShowSettingsUtil.getInstance().editConfigurable(e.getProject(), (Configurable)new HttpProxyConfigurable());
        }

        private static final void showProxyAuthNotification$lambda$1() {
            proxyAuthNotificationActive.set(false);
        }

        private static final void showProxyAuthNotification$lambda$2(Notification $notification) {
            $notification.notify(null);
        }

        static {
            $$INSTANCE = new Companion();
            proxyAuthNotificationActive = new AtomicBoolean(false);
        }
    }
}

