/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.DynamicBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.UtilBundle;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.text.SyncDateFormat;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance(DateFormatUtil.class);
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31536000000L;
    public static final String TIME_SHORT_12H = "h:mm\u202fa";
    public static final String TIME_SHORT_24H = "HH:mm";
    private static final String TIME_MEDIUM_12H = "h:mm:ss\u202fa";
    private static final String TIME_MEDIUM_24H = "HH:mm:ss";
    private static final long[] DENOMINATORS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
    private static final Period[] PERIODS = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};

    private DateFormatUtil() {
    }

    @Deprecated(forRemoval=true)
    public static long getDifferenceInDays(@NotNull Date startDate, @NotNull Date endDate) {
        if (startDate == null) {
            DateFormatUtil.$$$reportNull$$$0(0);
        }
        if (endDate == null) {
            DateFormatUtil.$$$reportNull$$$0(1);
        }
        return (endDate.getTime() - startDate.getTime() + 86400000L - 1000L) / 86400000L;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SyncDateFormat getDateFormat() {
        return new SyncDateFormat(DateFormatUtil.formats().dateFmt());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        return new SyncDateFormat(DateFormatUtil.formats().dateTimeFmt());
    }

    @NlsSafe
    @NotNull
    public static String formatTime(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(2);
        }
        String string = DateFormatUtil.formats().timeShort().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatTime(long time) {
        String string = DateFormatUtil.formats().timeShort().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(5);
        }
        String string = DateFormatUtil.formats().timeMedium().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatTimeWithSeconds(long time) {
        String string = DateFormatUtil.formats().timeMedium().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatDate(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(8);
        }
        String string = DateFormatUtil.formats().date().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatDate(long time) {
        String string = DateFormatUtil.formats().date().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(11);
        }
        return DateFormatUtil.formatPrettyDate(date.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDate(long time) {
        String pretty = DateFormatUtil.doFormatPretty(time, false);
        return pretty != null ? pretty : DateFormatUtil.formatDate(time);
    }

    @NlsSafe
    @NotNull
    public static String formatDateTime(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(12);
        }
        String string = DateFormatUtil.formats().dateTime().format(DateFormatUtil.toZoned(date));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatDateTime(long time) {
        String string = DateFormatUtil.formats().dateTime().format(DateFormatUtil.toZoned(time));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDateTime(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(15);
        }
        return DateFormatUtil.formatPrettyDateTime(date.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDateTime(long time) {
        String pretty = DateFormatUtil.doFormatPretty(time, true);
        return pretty != null ? pretty : DateFormatUtil.formatDateTime(time);
    }

    @Nullable
    private static String doFormatPretty(long time, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        long delta;
        if (!DateTimeFormatManager.getInstance().isPrettyFormattingAllowed()) {
            return null;
        }
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (LOG.isTraceEnabled()) {
            LOG.trace("now=" + currentTime + " t=" + time + " z=" + String.valueOf(c.getTimeZone()));
        }
        if (formatTime && (delta = currentTime - time) >= 0L && delta <= 3660000L) {
            return UtilBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result2 = UtilBundle.message("date.format.today", new Object[0]);
            return formatTime ? result2 + " " + DateFormatUtil.formatTime(time) : result2;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result3 = UtilBundle.message("date.format.yesterday", new Object[0]);
            return formatTime ? result3 + " " + DateFormatUtil.formatTime(time) : result3;
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static String formatFrequency(long time) {
        String string = UtilBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time, 0L));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            String string = UtilBundle.message("date.format.right.now", new Object[0]);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        int n = -1;
        for (i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            if (delta < denominator) continue;
            n = (int)(delta / denominator);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                String string = UtilBundle.message("date.format.a.few.moments.ago", new Object[0]);
                if (string == null) {
                    DateFormatUtil.$$$reportNull$$$0(18);
                }
                return string;
            }
            String string = DateFormatUtil.someTimeAgoMessage(PERIODS[i], n);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (d2 < d1) {
            if (n <= 0) {
                String string = UtilBundle.message("date.format.in.a.few.moments", new Object[0]);
                if (string == null) {
                    DateFormatUtil.$$$reportNull$$$0(20);
                }
                return string;
            }
            String string = DateFormatUtil.composeInSomeTimeMessage(PERIODS[i], n);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        return "";
    }

    @Deprecated(forRemoval=true)
    @NlsSafe
    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(22);
        }
        String string = DateFormat.getDateInstance(1, Locale.US).format(date);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static Date getSampleDateTime() {
        Date date = Date.from(LocalDateTime.of(2100, Month.DECEMBER, 31, 23, 59).atZone(ZoneId.systemDefault()).toInstant());
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(24);
        }
        return date;
    }

    @NotNull
    public static ZonedDateTime toZoned(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(25);
        }
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        if (zonedDateTime == null) {
            DateFormatUtil.$$$reportNull$$$0(26);
        }
        return zonedDateTime;
    }

    @NotNull
    public static ZonedDateTime toZoned(long date) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(date).atZone(ZoneId.systemDefault());
        if (zonedDateTime == null) {
            DateFormatUtil.$$$reportNull$$$0(27);
        }
        return zonedDateTime;
    }

    private static DateTimeFormatManager.Formats formats() {
        return DateTimeFormatManager.getInstance().getFormats();
    }

    private static String someTimeAgoMessage(Period period, int n) {
        return switch (period.ordinal()) {
            case 3 -> UtilBundle.message("date.format.n.days.ago", n);
            case 5 -> UtilBundle.message("date.format.n.minutes.ago", n);
            case 4 -> UtilBundle.message("date.format.n.hours.ago", n);
            case 1 -> UtilBundle.message("date.format.n.months.ago", n);
            case 2 -> UtilBundle.message("date.format.n.weeks.ago", n);
            default -> UtilBundle.message("date.format.n.years.ago", n);
        };
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        return switch (period.ordinal()) {
            case 3 -> UtilBundle.message("date.format.in.n.days", n);
            case 5 -> UtilBundle.message("date.format.in.n.minutes", n);
            case 4 -> UtilBundle.message("date.format.in.n.hours", n);
            case 1 -> UtilBundle.message("date.format.in.n.months", n);
            case 2 -> UtilBundle.message("date.format.in.n.weeks", n);
            default -> UtilBundle.message("date.format.in.n.years", n);
        };
    }

    @NotNull
    static DateTimeFormatManager.Formats getCustomFormats(DateTimeFormatManager settings) {
        String date = settings.getDateFormatPattern();
        String timeShort = settings.isUse24HourTime() ? TIME_SHORT_24H : TIME_SHORT_12H;
        String timeMedium = settings.isUse24HourTime() ? TIME_MEDIUM_24H : TIME_MEDIUM_12H;
        Locale locale = Objects.requireNonNullElse(DateFormatUtil.getDynamicLocale(), Locale.getDefault(Locale.Category.FORMAT));
        DateTimeFormatManager.Formats formats = DateFormatUtil.makeFormats(date, timeShort, timeMedium, locale);
        if (formats == null) {
            DateFormatUtil.$$$reportNull$$$0(28);
        }
        return formats;
    }

    @NotNull
    static DateTimeFormatManager.Formats getSystemFormats() {
        Locale locale = DateFormatUtil.getDynamicLocale();
        if (locale == null) {
            block7: {
                DateTimeFormatManager.Formats formats;
                block6: {
                    if (!SystemInfo.isMac || !JnaLoader.isLoaded()) break block6;
                    DateTimeFormatManager.Formats formats2 = DateFormatUtil.getMacFormats();
                    if (formats2 == null) {
                        DateFormatUtil.$$$reportNull$$$0(29);
                    }
                    return formats2;
                }
                try {
                    if (!SystemInfo.isWindows || !JnaLoader.isLoaded()) break block7;
                    formats = DateFormatUtil.getWindowsFormats();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                if (formats == null) {
                    DateFormatUtil.$$$reportNull$$$0(30);
                }
                return formats;
            }
            locale = Objects.requireNonNullElse(DateFormatUtil.getUnixLocale(), Locale.getDefault(Locale.Category.FORMAT));
        }
        return new DateTimeFormatManager.Formats(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale), DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale), DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(locale), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT).withLocale(locale), DateFormat.getDateInstance(3, locale), DateFormat.getDateTimeInstance(3, 3, locale));
    }

    @Nullable
    private static Locale getDynamicLocale() {
        Locale locale = DynamicBundle.getLocale();
        if (LOG.isTraceEnabled()) {
            LOG.trace("dyn.locale=" + String.valueOf(locale));
        }
        return locale.equals(Locale.ENGLISH) ? null : locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTimeFormatManager.Formats getMacFormats() {
        CF cf = (CF)Native.load((String)"CoreFoundation", CF.class);
        Pointer localeRef = cf.CFLocaleCopyCurrent();
        try {
            String date = DateFormatUtil.getMacFormat(cf, localeRef, 1L, 0L);
            String timeShort = DateFormatUtil.getMacFormat(cf, localeRef, 0L, 1L);
            String timeMedium = DateFormatUtil.getMacFormat(cf, localeRef, 0L, 2L);
            String dateTime = DateFormatUtil.getMacFormat(cf, localeRef, 1L, 1L);
            String localeId = DateFormatUtil.getMacString(cf, cf.CFLocaleGetIdentifier(localeRef));
            if (LOG.isTraceEnabled()) {
                LOG.trace("id=" + localeId);
            }
            Locale locale = DateFormatUtil.getLocaleById(localeId);
            DateTimeFormatManager.Formats formats = DateFormatUtil.makeFormats(date, timeShort, timeMedium, dateTime, locale);
            return formats;
        }
        finally {
            cf.CFRelease(localeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMacFormat(CF cf, Pointer localeRef, long dateStyle, long timeStyle) {
        Pointer formatter = cf.CFDateFormatterCreate(null, localeRef, dateStyle, timeStyle);
        if (formatter == null) {
            throw new IllegalStateException("CFDateFormatterCreate: null");
        }
        try {
            Pointer format = cf.CFDateFormatterGetFormat(formatter);
            String string = DateFormatUtil.getMacString(cf, format);
            return string;
        }
        finally {
            cf.CFRelease(formatter);
        }
    }

    private static String getMacString(CF cf, Pointer ref) {
        int length = (int)cf.CFStringGetLength(ref);
        char[] buffer = new char[length];
        cf.CFStringGetCharacters(ref, new CF.CFRange(0L, length), buffer);
        return new String(buffer);
    }

    @Nullable
    private static Locale getUnixLocale() {
        String localeStr = System.getenv("LC_TIME");
        if (LOG.isTraceEnabled()) {
            LOG.trace("LC_TIME=" + localeStr);
        }
        return localeStr == null ? null : DateFormatUtil.getLocaleById(localeStr.trim());
    }

    private static Locale getLocaleById(String localeStr) {
        int p = localeStr.indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        return (p = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
    }

    private static DateTimeFormatManager.Formats getWindowsFormats() {
        int bufferSize;
        char[] buffer;
        Kernel32 kernel32 = (Kernel32)Native.load((String)"Kernel32", Kernel32.class);
        int rv = kernel32.GetLocaleInfoEx(null, 31, buffer = new char[bufferSize = 128], bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortDate = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 121, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 4099, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        return DateFormatUtil.makeFormats(shortDate, shortTime, mediumTime, locale);
    }

    private static String fixWindowsFormat(String format) {
        return format.replace('g', 'G').replace("dddd", "EEEE").replace("ddd", "E").replace("tt", "a").replace("t", "a");
    }

    private static DateTimeFormatManager.Formats makeFormats(String date, String timeShort, String timeMedium, Locale locale) {
        return DateFormatUtil.makeFormats(date, timeShort, timeMedium, date + " " + timeShort, locale);
    }

    private static DateTimeFormatManager.Formats makeFormats(String date, String timeShort, String timeMedium, String dateTime, Locale locale) {
        return new DateTimeFormatManager.Formats(DateFormatUtil.formatFromString(date, locale), DateFormatUtil.formatFromString(timeShort, locale), DateFormatUtil.formatFromString(timeMedium, locale), DateFormatUtil.formatFromString(dateTime, locale), new SimpleDateFormat(date), new SimpleDateFormat(dateTime));
    }

    private static DateTimeFormatter formatFromString(String format, Locale locale) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("'" + format + "' in " + String.valueOf(locale));
            }
            return DateTimeFormatter.ofPattern(format.trim(), locale);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized format string '" + format + "'");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 9, 10, 13, 14, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endDate";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTimeWithSeconds";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrequency";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBetweenDates";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAboutDialogDate";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleDateTime";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toZoned";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFormats";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDifferenceInDays";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatTime";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeWithSeconds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatDateTime";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDateTime";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "formatAboutDialogDate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toZoned";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 9, 10, 13, 14, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }

    private static interface CF
    extends Library {
        public static final long kCFDateFormatterNoStyle = 0L;
        public static final long kCFDateFormatterShortStyle = 1L;
        public static final long kCFDateFormatterMediumStyle = 2L;

        public Pointer CFLocaleCopyCurrent();

        public Pointer CFLocaleGetIdentifier(Pointer var1);

        public Pointer CFDateFormatterCreate(Pointer var1, Pointer var2, long var3, long var5);

        public Pointer CFDateFormatterGetFormat(Pointer var1);

        public long CFStringGetLength(Pointer var1);

        public void CFStringGetCharacters(Pointer var1, CFRange var2, char[] var3);

        public void CFRelease(Pointer var1);

        @Structure.FieldOrder(value={"location", "length"})
        public static final class CFRange
        extends Structure
        implements Structure.ByValue {
            public long location;
            public long length;

            public CFRange(long location, long length) {
                this.location = location;
                this.length = length;
            }
        }
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, char[] var3, int var4);

        public int GetLastError();
    }
}

