/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.TipUiSettings;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/util/IconWithRoundedBorder;", "Ljavax/swing/Icon;", "delegate", "<init>", "(Ljavax/swing/Icon;)V", "getIconWidth", "", "getIconHeight", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "intellij.platform.tips"})
public final class IconWithRoundedBorder
implements Icon {
    @NotNull
    private final Icon delegate;

    public IconWithRoundedBorder(@NotNull Icon delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float arcSize = JBUIScale.scale((int)16);
        RoundRectangle2D.Float clipBounds = new RoundRectangle2D.Float(x, y, this.getIconWidth(), this.getIconHeight(), arcSize, arcSize);
        g2d.clip(clipBounds);
        this.delegate.paintIcon(c, g2d, x, y);
        g2d.setPaint(TipUiSettings.getImageBorderColor());
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(clipBounds);
        g2d.dispose();
    }
}

