/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stubs.visitors;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.stubs.checkers.PyPackageStubLink;
import com.jetbrains.python.codeInsight.stubs.checkers.PyStubsIncompatibilityChecker;
import com.jetbrains.python.codeInsight.stubs.fixes.IgnoreStubCompatibilityQuickFix;
import com.jetbrains.python.codeInsight.stubs.fixes.InstallStubQuickFix;
import com.jetbrains.python.codeInsight.stubs.visitors.PyStubVisitor;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.psi.PyFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/codeInsight/stubs/visitors/PyIncompatibleStubVisitor;", "Lcom/jetbrains/python/codeInsight/stubs/visitors/PyStubVisitor;", "ignoredStubPackages", "", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Ljava/util/List;Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getIgnoredStubPackages", "()Ljava/util/List;", "getSession", "()Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkImports", "", "file", "Lcom/jetbrains/python/psi/PyFile;", "importedPackages", "", "packageManager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyIncompatibleStubVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyIncompatibleStubVisitor.kt\ncom/jetbrains/python/codeInsight/stubs/visitors/PyIncompatibleStubVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n777#2:31\n873#2,2:32\n*S KotlinDebug\n*F\n+ 1 PyIncompatibleStubVisitor.kt\ncom/jetbrains/python/codeInsight/stubs/visitors/PyIncompatibleStubVisitor\n*L\n21#1:31\n21#1:32,2\n*E\n"})
public final class PyIncompatibleStubVisitor
extends PyStubVisitor {
    @NotNull
    private final List<String> ignoredStubPackages;
    @NotNull
    private final LocalInspectionToolSession session;

    public PyIncompatibleStubVisitor(@NotNull List<String> ignoredStubPackages, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter(ignoredStubPackages, (String)"ignoredStubPackages");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(holder, session);
        this.ignoredStubPackages = ignoredStubPackages;
        this.session = session;
    }

    @NotNull
    public final List<String> getIgnoredStubPackages() {
        return this.ignoredStubPackages;
    }

    @NotNull
    public final LocalInspectionToolSession getSession() {
        return this.session;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkImports(@NotNull PyFile file, @NotNull Set<String> importedPackages2, @NotNull PythonPackageManager packageManager2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(importedPackages2, (String)"importedPackages");
        Intrinsics.checkNotNullParameter((Object)packageManager2, (String)"packageManager");
        PyStubsIncompatibilityChecker checker = PyStubsIncompatibilityChecker.Companion.getInstance(packageManager2.getProject());
        Set<PyPackageStubLink> cached = checker.getCached(packageManager2.getSdk());
        Iterable $this$filter$iv = cached;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyPackageStubLink it = (PyPackageStubLink)element$iv$iv;
            boolean bl = false;
            if (!(!this.ignoredStubPackages.contains(it.getStubRequirement().getPresentableText()) && importedPackages2.contains(it.getPackageName-YChYU78()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stubs = (List)destination$iv$iv;
        for (PyPackageStubLink stub : stubs) {
            String message;
            Object[] objectArray = new Object[]{stub.getStubRequirement().getName()};
            Intrinsics.checkNotNullExpressionValue((Object)PyPsiBundle.message((String)"INSP.stub.packages.compatibility.incompatible.packages.message", (Object[])objectArray), (String)"message(...)");
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new InstallStubQuickFix(stub.getStubRequirement(), packageManager2.getSdk()), new IgnoreStubCompatibilityQuickFix(stub.getStubRequirement(), this.ignoredStubPackages)};
            this.registerProblem((PsiElement)file, message, localQuickFixArray);
        }
    }
}

