/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements.inspections.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUI;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.requirements.PackageUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/requirements/inspections/quickfixes/InstallRequirementQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "requirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "<init>", "(Lcom/jetbrains/python/packaging/PyRequirement;)V", "getRequirement", "()Lcom/jetbrains/python/packaging/PyRequirement;", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "startInWriteAction", "", "intellij.python.community.impl"})
public final class InstallRequirementQuickFix
implements LocalQuickFix {
    @NotNull
    private final PyRequirement requirement;

    public InstallRequirementQuickFix(@NotNull PyRequirement requirement) {
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        this.requirement = requirement;
    }

    @NotNull
    public final PyRequirement getRequirement() {
        return this.requirement;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.requirement.getPresentableText()};
        String string = PyBundle.message("QFIX.NAME.install.requirement", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile);
        if (sdk2 == null) {
            return;
        }
        Sdk pythonSdk = sdk2;
        PyPackageCoroutine.Companion.launch$default(PyPackageCoroutine.Companion, project, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, pythonSdk, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $pythonSdk;
            final /* synthetic */ InstallRequirementQuickFix this$0;
            {
                this.$project = $project;
                this.$pythonSdk = $pythonSdk;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = PythonPackageManagerUI.Companion.forSdk$default(PythonPackageManagerUI.Companion, this.$project, this.$pythonSdk, null, 4, null).installPyRequirementsWithConfirmation(CollectionsKt.listOf((Object)this.this$0.getRequirement()), (Continuation<? super List<? extends PythonPackage>>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 6, null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

