/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcommand;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ActionContext(@NotNull Project project, @NotNull PsiFile file, int offset, @NotNull TextRange selection, @Nullable PsiElement element) {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange selection;

    public ActionContext(@NotNull Project project, @NotNull PsiFile file, int offset, @NotNull TextRange selection, @Nullable PsiElement element) {
        if (project == null) {
            ActionContext.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ActionContext.$$$reportNull$$$0(1);
        }
        if (selection == null) {
            ActionContext.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public ActionContext withFile(@NotNull PsiFile file) {
        if (file == null) {
            ActionContext.$$$reportNull$$$0(3);
        }
        return new ActionContext(this.project, file, this.offset, this.selection, this.element);
    }

    public ActionContext withElement(@NotNull PsiElement element) {
        if (element == null) {
            ActionContext.$$$reportNull$$$0(4);
        }
        return new ActionContext(this.project, this.file, this.offset, this.selection, element);
    }

    public ActionContext withOffset(int offset) {
        return new ActionContext(this.project, this.file, offset, this.selection, this.element);
    }

    public ActionContext withSelection(TextRange selection) {
        return new ActionContext(this.project, this.file, this.offset, selection, this.element);
    }

    @Nullable
    public PsiElement findLeaf() {
        return this.file.findElementAt(this.offset);
    }

    @Nullable
    public PsiElement findLeafOnTheLeft() {
        return this.offset == 0 ? null : this.file.findElementAt(this.offset - 1);
    }

    @NotNull
    public static ActionContext from(@Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            ActionContext.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            return new ActionContext(file.getProject(), file, 0, TextRange.from((int)0, (int)0), null);
        }
        SelectionModel model = editor.getSelectionModel();
        int start = model.getSelectionStart();
        int end = model.getSelectionEnd();
        return new ActionContext(file.getProject(), file, editor.getCaretModel().getOffset(), TextRange.create((int)start, (int)Math.max(end, start)), null);
    }

    @NotNull
    public ActionContext mapToInjected(@NotNull PsiFile injectedFile) {
        Document document;
        if (injectedFile == null) {
            ActionContext.$$$reportNull$$$0(6);
        }
        if (!((document = injectedFile.getFileDocument()) instanceof DocumentWindow)) {
            throw new IllegalArgumentException("Not injected: " + String.valueOf(injectedFile));
        }
        DocumentWindow documentWindow = (DocumentWindow)document;
        int offset = this.offset >= 0 ? documentWindow.hostToInjected(this.offset) : this.offset;
        int start = this.selection.getStartOffset() >= 0 ? documentWindow.hostToInjected(this.selection.getStartOffset()) : this.selection.getStartOffset();
        int end = this.selection.getEndOffset() >= 0 ? documentWindow.hostToInjected(this.selection.getEndOffset()) : this.selection.getEndOffset();
        return new ActionContext(this.project, injectedFile, offset, new TextRange(start, end), this.element);
    }

    @NotNull
    public static ActionContext from(@NotNull ProblemDescriptor descriptor) {
        if (descriptor == null) {
            ActionContext.$$$reportNull$$$0(7);
        }
        PsiElement startElement = descriptor.getStartElement();
        PsiFile file = startElement.getContainingFile();
        PsiElement psiElement = descriptor.getPsiElement();
        TextRange range = descriptor.getTextRangeInElement();
        range = range != null ? range.shiftRight(psiElement.getTextRange().getStartOffset()) : psiElement.getTextRange();
        return new ActionContext(file.getProject(), file, range.getStartOffset(), range, startElement);
    }

    @NotNull
    public Project project() {
        Project project = this.project;
        if (project == null) {
            ActionContext.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public PsiFile file() {
        PsiFile psiFile = this.file;
        if (psiFile == null) {
            ActionContext.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    @NotNull
    public TextRange selection() {
        TextRange textRange = this.selection;
        if (textRange == null) {
            ActionContext.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/modcommand/ActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/modcommand/ActionContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "project";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "file";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withElement";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapToInjected";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

