/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.frontend.lang.editor;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOption;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.editorconfig.frontend.lang.editor.EditorConfigFoldingBuilderKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/editorconfig/frontend/lang/editor/EditorConfigFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "COMMENT_FOLD_LENGTH_LIMIT", "", "getPlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "isLineBreak", "element", "LINE_BREAK", "Lkotlin/text/Regex;", "intellij.editorconfig.frontend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigFoldingBuilder.kt\ncom/intellij/editorconfig/frontend/lang/editor/EditorConfigFoldingBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n37#2,2:111\n14060#3,2:113\n*S KotlinDebug\n*F\n+ 1 EditorConfigFoldingBuilder.kt\ncom/intellij/editorconfig/frontend/lang/editor/EditorConfigFoldingBuilder\n*L\n89#1:111,2\n83#1:113,2\n*E\n"})
public final class EditorConfigFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private final int COMMENT_FOLD_LENGTH_LIMIT;
    @NotNull
    private final Regex LINE_BREAK = new Regex("\\R");

    public EditorConfigFoldingBuilder() {
        this.COMMENT_FOLD_LENGTH_LIMIT = 40;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof EditorConfigPsiFile)) {
            EditorConfigFoldingBuilderKt.access$getLOG$p().warn("Folding builder was given unexpected element");
            return new FoldingDescriptor[0];
        }
        List descriptors = new ArrayList();
        EditorConfigFoldingBuilder.buildFoldRegions$findCommentFoldingInChildren(this, descriptors, root);
        EditorConfigFoldingBuilder.buildFoldRegions$findSectionFoldingInElement(descriptors, root);
        Collection $this$toTypedArray$iv = descriptors;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.LINE_COMMENT)) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            object = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)0, (int)Math.min(node.getTextLength(), this.COMMENT_FOLD_LENGTH_LIMIT))) + "...";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.SECTION)) {
            object = "...";
        } else {
            EditorConfigFoldingBuilderKt.access$getLOG$p().warn("Requested folding placeholder for unknown node (" + node.getElementType() + ")");
            object = "...";
        }
        return object;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLineBreak(PsiElement element) {
        if (element == null) return false;
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this.LINE_BREAK.matches((CharSequence)string)) return false;
        return true;
    }

    private static final void buildFoldRegions$add(List<FoldingDescriptor> descriptors, int start, int end, PsiElement element) {
        TextRange range = new TextRange(start, end);
        FoldingDescriptor descriptor = new FoldingDescriptor(element, range);
        descriptors.add(descriptor);
    }

    private static final void buildFoldRegions$findCommentFoldingInChildren(EditorConfigFoldingBuilder this$0, List<FoldingDescriptor> descriptors, PsiElement element) {
        PsiComment firstComment = null;
        int start = 0;
        int end = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment) {
                if (firstComment == null) {
                    start = ((PsiComment)child).getTextRange().getStartOffset();
                    firstComment = (PsiComment)child;
                }
                end = ((PsiComment)child).getTextRange().getEndOffset();
                PsiElement next = ((PsiComment)child).getNextSibling();
                if (this$0.isLineBreak(next)) {
                    child = next;
                    continue;
                }
                EditorConfigFoldingBuilder.buildFoldRegions$add(descriptors, start, end, (PsiElement)firstComment);
                firstComment = null;
                continue;
            }
            if (firstComment != null) {
                EditorConfigFoldingBuilder.buildFoldRegions$add(descriptors, start, end, (PsiElement)firstComment);
                firstComment = null;
            }
            EditorConfigFoldingBuilder.buildFoldRegions$findCommentFoldingInChildren(this$0, descriptors, child);
        }
        if (firstComment != null) {
            EditorConfigFoldingBuilder.buildFoldRegions$add(descriptors, start, end, (PsiElement)firstComment);
        }
    }

    private static final void buildFoldRegions$findSectionFoldingInElement(List<FoldingDescriptor> descriptors, PsiElement element) {
        if (element instanceof EditorConfigSection) {
            List list = ((EditorConfigSection)element).getOptionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptionList(...)");
            EditorConfigOption editorConfigOption = (EditorConfigOption)CollectionsKt.firstOrNull((List)list);
            if (editorConfigOption == null || (editorConfigOption = editorConfigOption.getTextRange()) == null) {
                return;
            }
            int start = editorConfigOption.getStartOffset();
            List list2 = ((EditorConfigSection)element).getOptionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptionList(...)");
            EditorConfigOption editorConfigOption2 = (EditorConfigOption)CollectionsKt.lastOrNull((List)list2);
            if (editorConfigOption2 == null || (editorConfigOption2 = editorConfigOption2.getTextRange()) == null) {
                return;
            }
            int end = editorConfigOption2.getEndOffset();
            TextRange range = new TextRange(start, end);
            FoldingDescriptor descriptor = new FoldingDescriptor(element, range);
            descriptors.add(descriptor);
        } else {
            PsiElement[] psiElementArray = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$forEach$iv = psiElementArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement p0 = (PsiElement)element$iv;
                boolean bl = false;
                EditorConfigFoldingBuilder.buildFoldRegions$findSectionFoldingInElement(descriptors, p0);
            }
        }
    }
}

