/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.json.JsonSchemaSpellcheckerClient;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLAnchorImpl;

public final class YAMLSpellcheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final Pattern CODE_LIKE_PATTERN = Pattern.compile("[\"']?" + String.valueOf(CODE_IDENTIFIER_LIKE) + "[\"']?");
    private final Tokenizer<YAMLQuotedText> myQuotedTextTokenizer = new Tokenizer<YAMLQuotedText>(this){

        public void tokenize(@NotNull YAMLQuotedText element, @NotNull TokenConsumer consumer) {
            TextRange range;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            if (!(range = ElementManipulators.getValueTextRange((PsiElement)element)).isEmpty()) {
                String text = ElementManipulators.getValueText((PsiElement)element);
                consumer.consumeToken((PsiElement)element, text, false, range.getStartOffset(), TextRange.allOf((String)text), (Splitter)PlainTextSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/yaml/YAMLSpellcheckerStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public Tokenizer<?> getTokenizer(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null) {
            IElementType type = node.getElementType();
            if (type == YAMLTokenTypes.SCALAR_TEXT || type == YAMLTokenTypes.SCALAR_LIST || type == YAMLTokenTypes.TEXT || type == YAMLTokenTypes.SCALAR_KEY || type == YAMLTokenTypes.COMMENT) {
                if (this.useTextLevelSpellchecking()) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(0);
                    }
                    return tokenizer;
                }
                if (YAMLSpellcheckerStrategy.isInjectedLanguageFragment((PsiElement)element.getParent())) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(1);
                    }
                    return tokenizer;
                }
                if (new JsonSchemaSpellcheckerClientForYaml(element).matchesNameFromSchema()) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(2);
                    }
                    return tokenizer;
                }
                Tokenizer tokenizer = TEXT_TOKENIZER;
                if (tokenizer == null) {
                    YAMLSpellcheckerStrategy.$$$reportNull$$$0(3);
                }
                return tokenizer;
            }
            if (element instanceof YAMLQuotedText) {
                if (this.useTextLevelSpellchecking()) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(4);
                    }
                    return tokenizer;
                }
                if (YAMLSpellcheckerStrategy.isInjectedLanguageFragment((PsiElement)element)) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(5);
                    }
                    return tokenizer;
                }
                if (new JsonSchemaSpellcheckerClientForYaml(element).matchesNameFromSchema()) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        YAMLSpellcheckerStrategy.$$$reportNull$$$0(6);
                    }
                    return tokenizer;
                }
                Tokenizer<YAMLQuotedText> tokenizer = this.myQuotedTextTokenizer;
                if (tokenizer == null) {
                    YAMLSpellcheckerStrategy.$$$reportNull$$$0(7);
                }
                return tokenizer;
            }
        }
        if (this.shouldBeIgnored(element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                YAMLSpellcheckerStrategy.$$$reportNull$$$0(8);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            YAMLSpellcheckerStrategy.$$$reportNull$$$0(9);
        }
        return tokenizer;
    }

    protected boolean isLiteral(@NotNull PsiElement element) {
        if (element == null) {
            YAMLSpellcheckerStrategy.$$$reportNull$$$0(10);
        }
        return super.isLiteral(element) || !super.isComment(element) && !CODE_LIKE_PATTERN.matcher(element.getText()).matches();
    }

    public boolean useTextLevelSpellchecking() {
        return Registry.is((String)"spellchecker.grazie.enabled", (boolean)false);
    }

    private boolean shouldBeIgnored(@NotNull PsiElement element) {
        if (element == null) {
            YAMLSpellcheckerStrategy.$$$reportNull$$$0(11);
        }
        if (element.getNode() == null) {
            return false;
        }
        IElementType type = element.getNode().getElementType();
        return this.useTextLevelSpellchecking() && (type == YAMLTokenTypes.SCALAR_DSTRING || type == YAMLTokenTypes.ANCHOR || element instanceof YAMLAnchorImpl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLSpellcheckerStrategy";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLSpellcheckerStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static class JsonSchemaSpellcheckerClientForYaml
    extends JsonSchemaSpellcheckerClient {
        @NotNull
        private final PsiElement element;

        public JsonSchemaSpellcheckerClientForYaml(@NotNull PsiElement element) {
            if (element == null) {
                JsonSchemaSpellcheckerClientForYaml.$$$reportNull$$$0(0);
            }
            this.element = element;
        }

        @NotNull
        protected PsiElement getElement() {
            PsiElement psiElement = this.element;
            if (psiElement == null) {
                JsonSchemaSpellcheckerClientForYaml.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @Nullable
        protected String getValue() {
            PsiElement parent = this.element.getParent();
            if (this.element.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY) {
                return ((YAMLKeyValue)parent).getKeyText();
            }
            if (parent instanceof YAMLKeyValue) {
                return ((YAMLKeyValue)parent).getValueText();
            }
            if (parent instanceof YAMLScalar) {
                return ((YAMLScalar)parent).getTextValue();
            }
            return null;
        }

        protected boolean isXIntellijInjection(@NotNull JsonSchemaService service, @NotNull JsonSchemaObject rootSchema) {
            if (service == null) {
                JsonSchemaSpellcheckerClientForYaml.$$$reportNull$$$0(2);
            }
            if (rootSchema == null) {
                JsonSchemaSpellcheckerClientForYaml.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/YAMLSpellcheckerStrategy$JsonSchemaSpellcheckerClientForYaml";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootSchema";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/YAMLSpellcheckerStrategy$JsonSchemaSpellcheckerClientForYaml";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isXIntellijInjection";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

