/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.util.system.OS;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.XAttachHost;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslAttachHost
implements XAttachHost {
    private final WSLDistribution myWsl;

    public WslAttachHost(@NotNull WSLDistribution wsl) {
        if (wsl == null) {
            WslAttachHost.$$$reportNull$$$0(0);
        }
        this.myWsl = wsl;
    }

    @NotNull
    public WSLDistribution getWsl() {
        WSLDistribution wSLDistribution = this.myWsl;
        if (wSLDistribution == null) {
            WslAttachHost.$$$reportNull$$$0(1);
        }
        return wSLDistribution;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        String user;
        String processOwnerOutput;
        String commandListOutput;
        String commListOutput = this.execAndCheckExitCode(ProcessListUtil.COMM_LIST_COMMAND);
        List processInfos = ProcessListUtil.parseLinuxOutputMacStyle((String)commListOutput, (String)(commandListOutput = this.execAndCheckExitCode(ProcessListUtil.COMMAND_LIST_COMMAND)), (String)(processOwnerOutput = this.execAndCheckExitCode(ProcessListUtil.PROCESS_OWNER_COMMAND)), (String)(user = this.getUser()));
        if (processInfos == null) {
            throw new ExecutionException(XDebuggerBundle.message((String)"dialog.message.error.parsing.ps.output", (Object[])new Object[0]));
        }
        List list = processInfos;
        if (list == null) {
            WslAttachHost.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private String execAndCheckExitCode(@NotNull List<String> command) throws ExecutionException {
        WSLCommandLineOptions options;
        ProcessOutput output;
        int exitCode;
        if (command == null) {
            WslAttachHost.$$$reportNull$$$0(3);
        }
        if ((exitCode = (output = this.myWsl.executeOnWsl(command, options = new WSLCommandLineOptions().setSleepTimeoutSec(0.1), 5000, null)).getExitCode()) != 0) {
            String exitCodeString = ProcessTerminatedListener.stringifyExitCode((OS)OS.Linux, (int)exitCode);
            throw new ExecutionException(XDebuggerBundle.message((String)"dialog.message.error.executing.ps", (Object[])new Object[]{exitCodeString}));
        }
        String string = output.getStdout();
        if (string == null) {
            WslAttachHost.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private String getUser() {
        try {
            return this.execAndCheckExitCode(List.of("whoami")).trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslAttachHost host = (WslAttachHost)o;
        return Objects.equals(this.myWsl, host.myWsl);
    }

    public int hashCode() {
        return Objects.hash(this.myWsl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/WslAttachHost";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/WslAttachHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWsl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execAndCheckExitCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execAndCheckExitCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

