/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.BuildViewSettingsProviderAdapter;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.WeakFilterableSupplier;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.externalSystem.service.execution.configuration.ExternalSystemRunConfigurationExtensionManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.trusted.ExternalSystemTrustedProjectDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunnableState
extends UserDataHolderBase
implements RunProfileState {
    private static final Logger LOG = Logger.getInstance(ExternalSystemRunnableState.class);
    @ApiStatus.Internal
    public static final Key<ProgressIndicator> PROGRESS_INDICATOR_KEY = Key.create((String)"PROGRESS_INDICATOR");
    @ApiStatus.Internal
    public static final Key<Integer> DEBUGGER_DISPATCH_PORT_KEY = Key.create((String)"DEBUGGER_DISPATCH_PORT");
    @ApiStatus.Internal
    public static final Key<String> DEBUGGER_PARAMETERS_KEY = Key.create((String)"DEBUGGER_PARAMETERS");
    @ApiStatus.Internal
    public static final Key<String> DEBUGGER_DISPATCH_ADDR_KEY = Key.create((String)"DEBUGGER_DISPATCH_ADDR");
    @ApiStatus.Internal
    public static final Key<Integer> BUILD_PROCESS_DEBUGGER_PORT_KEY = Key.create((String)"BUILD_PROCESS_DEBUGGER_PORT");
    @ApiStatus.Internal
    @NotNull
    public static final Key<ExternalSystemTaskNotificationListener> TASK_NOTIFICATION_LISTENER_KEY = Key.create((String)"TASK_NOTIFICATION_LISTENER");
    @ApiStatus.Internal
    public static final Key<ThreeState> NAVIGATE_TO_ERROR_KEY = Key.create((String)"NAVIGATE_TO_ERROR");
    @NotNull
    private static final String DEFAULT_TASK_PREFIX = ": ";
    @NotNull
    private static final String DEFAULT_TASK_POSTFIX = "";
    @NotNull
    private final ExternalSystemTaskExecutionSettings mySettings;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemRunConfiguration myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnv;
    @Nullable
    private RunContentDescriptor myContentDescriptor;
    private final int myDebugPort;
    private ServerSocket myForkSocket;

    public ExternalSystemRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
        int port;
        if (settings == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(2);
        }
        if (env == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(3);
        }
        this.myForkSocket = null;
        this.mySettings = settings;
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myEnv = env;
        if (debug) {
            try {
                port = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                LOG.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)e);
                port = 0;
            }
        } else {
            port = 0;
        }
        this.myDebugPort = port;
    }

    public int getDebugPort() {
        return this.myDebugPort;
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.myForkSocket == null && !Boolean.getBoolean("external.system.disable.fork.debugger")) {
            try {
                boolean isRemoteRun = ContainerUtil.exists(ExternalSystemExecutionAware.getExtensions(this.mySettings.getExternalSystemId()), aware -> aware.isRemoteRun(this.myConfiguration, this.myProject));
                this.myForkSocket = new ServerSocket(0, 0, ExternalSystemRunnableState.findAddress(isRemoteRun));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myForkSocket;
    }

    private static InetAddress findAddress(boolean remoteRun) throws UnknownHostException, SocketException {
        if (remoteRun) {
            String host = Registry.stringValue((String)"external.system.remote.debugger.dispatch.host");
            if (!StringUtil.isEmpty((String)host) && !"0".equals(host)) {
                return InetAddress.getByName(host);
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                try {
                    boolean isLoopbackInterface = networkInterface.isLoopback();
                    if (isLoopbackInterface) continue;
                    Enumeration<InetAddress> candidates = networkInterface.getInetAddresses();
                    while (candidates.hasMoreElements()) {
                        InetAddress candidate = candidates.nextElement();
                        if (!(candidate instanceof Inet4Address) || candidate.isLoopbackAddress()) continue;
                        return candidate;
                    }
                }
                catch (SocketException e) {
                    LOG.debug("Error while querying interface " + String.valueOf(networkInterface) + " for IP addresses", (Throwable)e);
                }
            }
        }
        return InetAddress.getByName("127.0.0.1");
    }

    public boolean isReattachDebugProcess() {
        return this.myConfiguration.isReattachDebugProcess();
    }

    public boolean isDebugServerProcess() {
        return this.myConfiguration.isDebugServerProcess();
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        RunConfigurationTaskState taskState;
        AnAction[] contextActions;
        AnAction[] restartActions;
        AnAction[] customActions;
        if (runner == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ProjectSystemId externalSystemId = this.mySettings.getExternalSystemId();
        if (!ExternalSystemTrustedProjectDialog.confirmLoadingUntrustedProject(this.myProject, externalSystemId)) {
            String externalSystemName = externalSystemId.getReadableName();
            throw new ExecutionException(ExternalSystemBundle.message((String)"untrusted.project.notification.execution.error", (Object[])new Object[]{externalSystemName}));
        }
        String jvmParametersSetup = this.getJvmAgentsSetup();
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalSystemExecuteTaskTask task = new ExternalSystemExecuteTaskTask(this.myProject, this.mySettings, jvmParametersSetup, this.myConfiguration);
        this.copyUserDataTo(task);
        this.addDebugUserDataTo(task);
        ExternalSystemTaskNotificationListener listener2 = (ExternalSystemTaskNotificationListener)this.myEnv.getUserData(TASK_NOTIFICATION_LISTENER_KEY);
        if (listener2 != null) {
            ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(task.getId(), listener2);
        }
        String executionName = this.getExecutionName(externalSystemId);
        ExternalSystemProcessHandler processHandler = new ExternalSystemProcessHandler(task, executionName);
        ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(task);
        ExecutionConsole consoleView = consoleManager.attachExecutionConsole(this.myProject, (ExternalSystemTask)task, this.myEnv, (ProcessHandler)processHandler);
        if (consoleView == null) {
            customActions = AnAction.EMPTY_ARRAY;
            restartActions = AnAction.EMPTY_ARRAY;
            contextActions = AnAction.EMPTY_ARRAY;
            Disposer.register((Disposable)this.myProject, (Disposable)processHandler);
        } else {
            Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
            Disposer.register((Disposable)consoleView, (Disposable)processHandler);
            customActions = consoleManager.getCustomActions(this.myProject, (ExternalSystemTask)task, this.myEnv);
            restartActions = consoleManager.getRestartActions(consoleView);
            contextActions = consoleManager.getCustomContextActions(this.myProject, (ExternalSystemTask)task, this.myEnv);
        }
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)task.getId(), executionName, task.getExternalProjectPath(), System.currentTimeMillis());
        ThreeState navigateToError = (ThreeState)this.myEnv.getUserData(NAVIGATE_TO_ERROR_KEY);
        if (navigateToError != null) {
            buildDescriptor.setNavigateToError(navigateToError);
        }
        Class progressListenerClazz = (Class)task.getUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY);
        Filter[] filters = consoleManager.getCustomExecutionFilters(this.myProject, (ExternalSystemTask)task, this.myEnv);
        Arrays.stream(filters).forEach(arg_0 -> ((DefaultBuildDescriptor)buildDescriptor).withExecutionFilter(arg_0));
        BuildView progressListener = progressListenerClazz != null ? (BuildProgressListener)this.myProject.getService(progressListenerClazz) : this.createBuildView(buildDescriptor, consoleView);
        RunnerSettings runnerSettings = this.myEnv.getRunnerSettings();
        ExternalSystemRunConfigurationExtensionManager runConfigurationExtensionManager = ExternalSystemRunConfigurationExtensionManager.getInstance();
        runConfigurationExtensionManager.attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)processHandler, runnerSettings);
        BackgroundTaskUtil.executeOnPooledThread((Disposable)processHandler, () -> this.lambda$execute$1(task, executionName, processHandler, (BuildProgressListener)progressListener, consoleManager, consoleView, buildDescriptor, customActions, restartActions, contextActions));
        ExecutionConsole executionConsole = progressListener instanceof ExecutionConsole ? (ExecutionConsole)progressListener : consoleView;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (executionConsole instanceof BuildView) {
            actionGroup.addAll(((BuildView)executionConsole).getSwitchActions());
            actionGroup.add((AnAction)BuildTreeFilters.createFilteringActionsGroup((Supplier)new WeakFilterableSupplier((Object)((BuildView)executionConsole))));
        }
        if ((taskState = (RunConfigurationTaskState)this.myConfiguration.getUserData(RunConfigurationTaskState.getKEY())) != null && consoleView != null) {
            actionGroup.addAll((Collection)taskState.createCustomActions((ProcessHandler)processHandler, consoleView, executor));
        }
        DefaultExecutionResult executionResult = new DefaultExecutionResult(executionConsole, (ProcessHandler)processHandler, actionGroup.getChildren(ActionManager.getInstance()));
        executionResult.setRestartActions(restartActions);
        return executionResult;
    }

    @NotNull
    @Nls
    private String getExecutionName(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)this.mySettings.getExecutionName())) {
            String string = this.mySettings.getExecutionName();
            if (string == null) {
                ExternalSystemRunnableState.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)this.myConfiguration.getName())) {
            String string = this.myConfiguration.getName();
            if (string == null) {
                ExternalSystemRunnableState.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(this.myProject, externalSystemId, this.mySettings.getExternalProjectPath(), this.mySettings.getTaskNames(), this.mySettings.getExecutionName(), DEFAULT_TASK_PREFIX, DEFAULT_TASK_POSTFIX);
        if (string == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void executeTask(final @NotNull ExternalSystemExecuteTaskTask task, final @Nls String executionName, @NotNull ProgressIndicator indicator, final @NotNull ExternalSystemProcessHandler processHandler, final @Nullable BuildProgressListener progressListener, final @NotNull ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager, final @Nullable ExecutionConsole consoleView, final @NotNull DefaultBuildDescriptor buildDescriptor, final AnAction[] customActions, final AnAction[] restartActions, final AnAction[] contextActions) {
        if (task == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(11);
        }
        if (consoleManager == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(12);
        }
        if (buildDescriptor == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(13);
        }
        if (indicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicatorEx = (ProgressIndicatorEx)indicator;
            indicatorEx.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    super.cancel();
                    task.cancel(new ExternalSystemTaskNotificationListener[0]);
                }
            });
        }
        String startDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        final String settingsDescription = StringUtil.isEmpty((String)this.mySettings.toString()) ? DEFAULT_TASK_POSTFIX : String.format(" '%s'", this.mySettings);
        final String greeting = ExternalSystemBundle.message((String)"run.text.starting.task", (Object[])new Object[]{startDateTime, settingsDescription}) + "\n";
        processHandler.notifyTextAvailable(greeting + "\n", ProcessOutputTypes.SYSTEM);
        try (final ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(task.getId(), progressListener, false);){
            ExternalSystemTaskNotificationListener taskListener = new ExternalSystemTaskNotificationListener(){

                public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (id == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (progressListener != null) {
                        ExternalSystemRunConfiguration.MyTaskRerunAction rerunTaskAction = new ExternalSystemRunConfiguration.MyTaskRerunAction(progressListener, ExternalSystemRunnableState.this.myEnv, ExternalSystemRunnableState.this.myContentDescriptor);
                        BuildViewSettingsProviderAdapter viewSettingsProvider = consoleView instanceof BuildViewSettingsProvider ? new BuildViewSettingsProviderAdapter((BuildViewSettingsProvider)consoleView) : null;
                        buildDescriptor.withProcessHandler((BuildProcessHandler)processHandler, view -> ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, greeting, true)).withContentDescriptor(() -> ExternalSystemRunnableState.this.myContentDescriptor).withActions(customActions).withRestartAction((AnAction)rerunTaskAction).withRestartActions(restartActions).withContextActions(contextActions).withExecutionEnvironment(ExternalSystemRunnableState.this.myEnv);
                        progressListener.onEvent((Object)id, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, BuildBundle.message((String)"build.status.running", (Object[])new Object[0])).withBuildViewSettingsProvider((BuildViewSettingsProvider)viewSettingsProvider));
                    }
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, @NotNull ProcessOutputType outputType) {
                    if (id == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (text == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    if (consoleView != null) {
                        consoleManager.onOutput(consoleView, (ProcessHandler)processHandler, text, (Key)outputType);
                    } else {
                        processHandler.notifyTextAvailable(text, (Key)outputType);
                    }
                    eventDispatcher.setStdOut(outputType.isStdout());
                    eventDispatcher.append((CharSequence)text);
                }

                public void onFailure(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull Exception exception) {
                    if (projectPath == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    if (id == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    if (exception == null) {
                        2.$$$reportNull$$$0(7);
                    }
                    if (progressListener != null) {
                        long eventTime = System.currentTimeMillis();
                        String eventMessage = BuildBundle.message((String)"build.status.failed", (Object[])new Object[0]);
                        String title = executionName + " " + BuildBundle.message((String)"build.status.failed", (Object[])new Object[0]);
                        ProjectSystemId externalSystemId = id.getProjectSystemId();
                        String externalProjectPath = ExternalSystemRunnableState.this.mySettings.getExternalProjectPath();
                        DataContext dataContext = BuildConsoleUtils.getDataContext((Object)id, (BuildProgressListener)progressListener, (ComponentContainer)consoleView);
                        FailureResultImpl eventResult = ExternalSystemUtil.createFailureResult(title, exception, externalSystemId, ExternalSystemRunnableState.this.myProject, externalProjectPath, dataContext);
                        eventDispatcher.onEvent((Object)id, (BuildEvent)new FinishBuildEventImpl((Object)id, null, eventTime, eventMessage, (EventResult)eventResult));
                    }
                    processHandler.notifyProcessTerminated(1);
                }

                public void onCancel(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        2.$$$reportNull$$$0(8);
                    }
                    if (id == null) {
                        2.$$$reportNull$$$0(9);
                    }
                    eventDispatcher.onEvent((Object)id, (BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), BuildBundle.message((String)"build.status.cancelled", (Object[])new Object[0]), (EventResult)new FailureResultImpl()));
                    processHandler.notifyProcessTerminated(1);
                }

                public void onSuccess(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        2.$$$reportNull$$$0(10);
                    }
                    if (id == null) {
                        2.$$$reportNull$$$0(11);
                    }
                    eventDispatcher.onEvent((Object)id, (BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), BuildBundle.message((String)"build.event.message.successful", (Object[])new Object[0]), (EventResult)new SuccessResultImpl()));
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(12);
                    }
                    if (consoleView != null) {
                        consoleManager.onStatusChange(consoleView, event);
                    }
                    if (event instanceof ExternalSystemBuildEvent) {
                        eventDispatcher.onEvent((Object)event.getId(), ((ExternalSystemBuildEvent)event).getBuildEvent());
                    } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                        eventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    }
                }

                public void onEnd(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        2.$$$reportNull$$$0(13);
                    }
                    if (id == null) {
                        2.$$$reportNull$$$0(14);
                    }
                    String endDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                    String farewell = ExternalSystemBundle.message((String)"run.text.ended.task", (Object[])new Object[]{endDateTime, settingsDescription});
                    processHandler.notifyTextAvailable(farewell + "\n", ProcessOutputTypes.SYSTEM);
                    ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, farewell, false);
                    processHandler.notifyProcessTerminated(0);
                }

                public void onEnvironmentPrepared(@NotNull ExternalSystemTaskId id) {
                    RunConfigurationTaskState taskState;
                    if (id == null) {
                        2.$$$reportNull$$$0(15);
                    }
                    if ((taskState = (RunConfigurationTaskState)ExternalSystemRunnableState.this.myConfiguration.getUserData(RunConfigurationTaskState.getKEY())) != null && consoleView != null) {
                        taskState.processExecutionResult((ProcessHandler)processHandler, consoleView);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectPath";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 6: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 15: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "id";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "exception";
                            break;
                        }
                        case 12: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStart";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTaskOutput";
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFailure";
                            break;
                        }
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCancel";
                            break;
                        }
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 12: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStatusChange";
                            break;
                        }
                        case 13: 
                        case 14: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEnd";
                            break;
                        }
                        case 15: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEnvironmentPrepared";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            task.execute(indicator, taskListener);
            Throwable taskError = task.getError();
            if (taskError != null && !(taskError instanceof Exception)) {
                FinishBuildEventImpl failureEvent = new FinishBuildEventImpl((Object)task.getId(), null, System.currentTimeMillis(), BuildBundle.message((String)"build.status.failed", (Object[])new Object[0]), (EventResult)new FailureResultImpl(taskError));
                eventDispatcher.onEvent(task.getId(), (BuildEvent)failureEvent);
            }
        }
    }

    private void addDebugUserDataTo(UserDataHolderBase holder) {
        if (this.myDebugPort > 0) {
            holder.putUserData(BUILD_PROCESS_DEBUGGER_PORT_KEY, (Object)this.myDebugPort);
            ServerSocket forkSocket = this.getForkSocket();
            if (forkSocket != null) {
                holder.putUserData(DEBUGGER_DISPATCH_ADDR_KEY, (Object)forkSocket.getInetAddress().getHostAddress());
                holder.putUserData(DEBUGGER_DISPATCH_PORT_KEY, (Object)forkSocket.getLocalPort());
            }
        }
    }

    @Nullable
    private String getJvmAgentsSetup() throws ExecutionException {
        SimpleJavaParameters extensionsJP = new SimpleJavaParameters();
        ExternalSystemRunConfigurationExtensionManager runConfigurationExtensionManager = ExternalSystemRunConfigurationExtensionManager.getInstance();
        runConfigurationExtensionManager.updateVMParameters(this.myConfiguration, extensionsJP, this.myEnv.getRunnerSettings(), this.myEnv.getExecutor());
        String jvmParametersSetup = DEFAULT_TASK_POSTFIX;
        ParametersList allVMParameters = new ParametersList();
        ParametersList data = (ParametersList)this.myEnv.getUserData(ExternalSystemTaskExecutionSettings.JVM_AGENT_SETUP_KEY);
        if (data != null) {
            for (String parameter : data.getList()) {
                if (parameter.startsWith("-agentlib:") || parameter.startsWith("-agentpath:") || parameter.startsWith("-javaagent:")) continue;
                throw new ExecutionException(ExternalSystemBundle.message((String)"run.invalid.jvm.agent.configuration", (Object[])new Object[]{parameter}));
            }
            allVMParameters.addAll(data.getParameters());
        }
        allVMParameters.addAll(extensionsJP.getVMParametersList().getParameters());
        jvmParametersSetup = allVMParameters.getParametersString();
        return StringUtil.nullize((String)jvmParametersSetup);
    }

    protected BuildView createBuildView(DefaultBuildDescriptor buildDescriptor, ExecutionConsole executionConsole) {
        final ExternalSystemRunConfigurationViewManager viewManager = (ExternalSystemRunConfigurationViewManager)this.myProject.getService(ExternalSystemRunConfigurationViewManager.class);
        return new BuildView(this.myProject, executionConsole, (BuildDescriptor)buildDescriptor, "build.toolwindow.run.selection.state", viewManager){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.onEvent(buildId, event);
                viewManager.onEvent(buildId, event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState$3";
                objectArray[2] = "onEvent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void setContentDescriptor(@Nullable RunContentDescriptor contentDescriptor) {
        this.myContentDescriptor = contentDescriptor;
        if (contentDescriptor != null) {
            contentDescriptor.setExecutionId(this.myEnv.getExecutionId());
            RunnerAndConfigurationSettings settings = this.myEnv.getRunnerAndConfigurationSettings();
            if (settings != null) {
                contentDescriptor.setActivateToolWindowWhenAdded(settings.isActivateToolWindowBeforeRun());
                contentDescriptor.setAutoFocusContent(settings.isFocusToolWindowBeforeRun());
            }
        }
    }

    private /* synthetic */ void lambda$execute$1(ExternalSystemExecuteTaskTask task, String executionName, ExternalSystemProcessHandler processHandler, BuildProgressListener progressListener, ExternalSystemExecutionConsoleManager consoleManager, ExecutionConsole consoleView, DefaultBuildDescriptor buildDescriptor, AnAction[] customActions, AnAction[] restartActions, AnAction[] contextActions) {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.myEnv.getUserData(PROGRESS_INDICATOR_KEY);
        if (progressIndicator == null) {
            progressIndicator = new EmptyProgressIndicator();
        }
        this.executeTask(task, executionName, progressIndicator, processHandler, progressListener, (ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler>)consoleManager, consoleView, buildDescriptor, customActions, restartActions, contextActions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

