/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.ClientHandlersDummy;
import com.jetbrains.cef.remote.ClientHandlersImpl;
import com.jetbrains.cef.remote.NativeServerManager;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.browser.RemoteBrowser;
import com.jetbrains.cef.remote.browser.RemoteClient;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.server.TServer;
import com.jetbrains.cef.remote.thrift.server.TThreadPoolServer;
import com.jetbrains.cef.remote.thrift.transport.TServerTransport;
import com.jetbrains.cef.remote.thrift_codegen.ClientHandlers;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.handler.CefAppHandler;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class CefServer {
    private static final int WAIT_FOR_SERVER_START_SEC = Utils.getInteger("JCEF_WAIT_FOR_SERVER_START_SEC", 60);
    private static final int WAIT_FOR_SERVER_EXIT_SEC = Utils.getInteger("JCEF_WAIT_FOR_SERVER_EXIT_SEC", 10);
    private static final boolean DONT_STOP_SERVER_MANUALLY = Utils.getBoolean("JCEF_DONT_STOP_SERVER_MANUALLY");
    private static HashSet<CefServer> ourInstances = new HashSet();
    private final ThriftTransport myThriftServer;
    private final ThriftTransport myThriftBackward;
    private final CefParams myParams;
    private CefApp myCefApp = null;
    private Thread myClientHandlersThread;
    private TServer myClientHandlersServer;
    private TServerTransport myClientHandlersTransport;
    private final RpcContext myRpc;
    private final Map<Integer, RemoteBrowser> myBid2Browser = new ConcurrentHashMap<Integer, RemoteBrowser>();
    private final ClientHandlersImpl myClientHandlersImpl;
    private volatile boolean myIsConnected = false;
    private volatile boolean myIsContextInitialized = false;
    private volatile boolean myIsDisconnected = false;
    private volatile boolean myIsCrashed = false;
    private final LinkedList<Runnable> myDelayedActions = new LinkedList();
    private Runnable myDisconnectionCallback = null;

    public CefServer(ThriftTransport thriftServer, ThriftTransport thriftBackward, String[] args, CefSettings settings) {
        this.myThriftServer = thriftServer;
        this.myThriftBackward = thriftBackward;
        this.myParams = new CefParams(settings, args);
        this.myRpc = new RpcContext(this);
        this.myClientHandlersImpl = new ClientHandlersImpl(this.myRpc, this.myBid2Browser);
        CefServer otherRunningInstance = CefServer.findInstance(this.myParams, true);
        if (otherRunningInstance != null) {
            CefLog.Error("Found running CefServer instance for params:\n%s", this.myParams);
        }
        ourInstances.add(this);
        CefLog.Debug("Created CefServer instance '%s'. Transport %s (backward %s). Params:\n%s", this.toStringShort(), thriftServer, thriftBackward, this.myParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CefServer findInstance(CefParams params, boolean onlyRunning) {
        if (params == null) {
            return null;
        }
        CefLog.Debug("Find for params: " + params, new Object[0]);
        HashSet<CefServer> hashSet = ourInstances;
        synchronized (hashSet) {
            for (CefServer s : ourInstances) {
                CefApp app;
                if (onlyRunning && (s.myIsDisconnected || (app = s.getCefApp()) != null && app.isShuttingDown()) || !s.myParams.isAlmostEqual(params)) continue;
                return s;
            }
            return null;
        }
    }

    public static CefServer findRunningInstance(String[] args, CefSettings settings) {
        return CefServer.findInstance(new CefParams(settings, args), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInstancesCount() {
        HashSet<CefServer> hashSet = ourInstances;
        synchronized (hashSet) {
            return ourInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logInstances() {
        if (CefLog.IsDebugEnabled()) {
            CefLog.Debug("Available CefServer instances: ", new Object[0]);
            HashSet<CefServer> hashSet = ourInstances;
            synchronized (hashSet) {
                for (CefServer s : ourInstances) {
                    CefLog.Debug(s.toStringDetailed(), new Object[0]);
                }
            }
        }
    }

    public ThriftTransport getThriftServer() {
        return this.myThriftServer;
    }

    public ThriftTransport getThriftBackward() {
        return this.myThriftBackward;
    }

    public String toStringShort() {
        return this.myThriftServer.toStringShort();
    }

    public String toStringDetailed() {
        return "CefServer_" + this.myThriftServer.toStringShort() + ", params: " + this.myParams.toString();
    }

    public CefApp getCefApp() {
        return this.myCefApp;
    }

    public void setCefApp(CefApp cefApp) {
        this.myCefApp = cefApp;
    }

    public void setDisconnectionCallback(Runnable disconnectionCallback) {
        this.myDisconnectionCallback = disconnectionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(CefAppHandler appHandler) {
        boolean bl;
        try {
            if (!CefApp.isRemoteEnabled()) {
                boolean bl2 = false;
                return bl2;
            }
            String runningRoot = NativeServerManager.isRunning(this.myThriftServer);
            if (runningRoot != null) {
                CefLog.Info("Going to connect with already running cef_server: transport '%s', root '%s'", this.myThriftServer, runningRoot);
            } else {
                boolean success = NativeServerManager.startProcessAndWait(this.myThriftServer, appHandler, this.myParams.args, this.myParams.settings, false, (long)WAIT_FOR_SERVER_START_SEC * 1000L);
                if (!success) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            if (!this.connect(appHandler == null ? null : appHandler::onContextInitialized)) {
                CefLog.Error("CefServer.connect() fails, can't initialize thrift client for native server.", new Object[0]);
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        catch (Throwable e) {
            CefLog.Error("RuntimeException in CefServer.start: %s", e.getMessage());
            bl = false;
            return bl;
        }
        finally {
            LinkedList<Runnable> linkedList = this.myDelayedActions;
            synchronized (linkedList) {
                this.myDelayedActions.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onConnected(Runnable r, String name, boolean first) {
        LinkedList<Runnable> linkedList = this.myDelayedActions;
        synchronized (linkedList) {
            if (this.myIsConnected) {
                if (r != null) {
                    r.run();
                }
                return true;
            }
            if (r != null) {
                if (first) {
                    this.myDelayedActions.addFirst(r);
                } else {
                    this.myDelayedActions.addLast(r);
                }
                CefLog.Debug("Delay action '%s' until server connected (first=%s).", name, String.valueOf(first));
            }
            return false;
        }
    }

    public RpcContext getRpcContext() {
        return this.myRpc;
    }

    public RemoteClient createClient() {
        return new RemoteClient(this.myRpc, this.myBid2Browser);
    }

    public String getVersion() {
        if (this.myIsConnected) {
            return this.myRpc.execObj(r -> r.getServerInfo("version"));
        }
        return "unknown(not connected)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Runnable onContextInitialized) {
        this.myClientHandlersImpl.setOnContextInitialized(() -> {
            this.myIsContextInitialized = true;
            if (onContextInitialized != null) {
                onContextInitialized.run();
            }
        });
        int cid = -1;
        try {
            try {
                CefLog.Debug("Initialize CefServer, open server transport.", new Object[0]);
                this.myRpc.openTransport(this.myThriftServer);
            }
            catch (TException x) {
                CefLog.Error("TException when opening server %s : %s", this.myThriftServer.isTcp() ? "tcp-socket" : "pipe", x.getMessage());
                boolean bl = false;
                LinkedList<Runnable> linkedList = this.myDelayedActions;
                synchronized (linkedList) {
                    if (cid != -1) {
                        this.myIsConnected = true;
                        this.myDelayedActions.forEach(r -> r.run());
                    }
                    this.myDelayedActions.clear();
                }
                return bl;
            }
            CefLog.Info("cef_server version: %s", this.myRpc.execObj(r -> r.getServerInfo("version")));
            try {
                this.myClientHandlersTransport = this.myThriftBackward.createServerTransport();
            }
            catch (Exception e) {
                CefLog.Error("Exception when opening client %s : %s", this.myThriftBackward.isTcp() ? "tcp-socket" : "pipe", e.getMessage());
                if (this.myThriftBackward.isTcp()) {
                    CefLog.Error("Port : %d", this.myThriftBackward.getPort());
                } else {
                    CefLog.Error("Pipe : %s", this.myThriftBackward.getPipe());
                }
                boolean bl = false;
                LinkedList<Runnable> linkedList = this.myDelayedActions;
                synchronized (linkedList) {
                    if (cid != -1) {
                        this.myIsConnected = true;
                        this.myDelayedActions.forEach(r -> r.run());
                    }
                    this.myDelayedActions.clear();
                }
                return bl;
            }
            ClientHandlers.Processor<ClientHandlersImpl> processor = new ClientHandlers.Processor<ClientHandlersImpl>(this.myClientHandlersImpl);
            TThreadPoolServer.Args serverArgs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args(this.myClientHandlersTransport).processor(processor)).executorService(new ThreadPoolExecutor(3, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
                final AtomicLong count = new AtomicLong();

                @Override
                public Thread newThread(Runnable r) {
                    String name = String.format("CefHandlers-execution-%d", this.count.getAndIncrement());
                    Thread thread = new Thread(() -> {
                        r.run();
                        CefServer.this.onCefHandlersThreadFinished();
                    }, name);
                    thread.setDaemon(true);
                    return thread;
                }
            }));
            this.myClientHandlersServer = new TThreadPoolServer(serverArgs);
            this.myClientHandlersThread = new Thread(() -> this.myClientHandlersServer.serve());
            this.myClientHandlersThread.setName("CefHandlers-listening");
            this.myClientHandlersThread.start();
            cid = this.myRpc.connect(this.myThriftBackward);
            if (cid == -1) {
                CefLog.Error("Can't connect to '%s', cid==-1", this.toStringDetailed());
                boolean bl = false;
                return bl;
            }
            CefLog.Debug("Connected to '%s', cid=%d", this.toStringDetailed(), cid);
        }
        catch (Throwable e) {
            CefLog.Error("RuntimeException in CefServer.connect: %s", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            LinkedList<Runnable> linkedList = this.myDelayedActions;
            synchronized (linkedList) {
                if (cid != -1) {
                    this.myIsConnected = true;
                    this.myDelayedActions.forEach(r -> r.run());
                }
                this.myDelayedActions.clear();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CefLog.Debug("Stop native server '%s'.", this.myThriftServer);
        if (!DONT_STOP_SERVER_MANUALLY) {
            this.myRpc.exec(r -> r.stop());
        }
        this.disconnect();
        if (WAIT_FOR_SERVER_EXIT_SEC > 0) {
            if (this.myIsCrashed) {
                CefLog.Debug("Server [%s] was crashed, will skip waiting for stop.", this.myThriftServer);
            } else {
                CefLog.Debug("Waiting for server [%s] stop (max %d sec).", this.myThriftServer, WAIT_FOR_SERVER_EXIT_SEC);
                long startMs = System.currentTimeMillis();
                Thread t = new Thread(() -> {
                    boolean stopped = NativeServerManager.waitForStopped(this.myThriftServer, WAIT_FOR_SERVER_EXIT_SEC * 1000);
                    if (stopped) {
                        CefLog.Info("Server [%s] was stopped in %d ms.", this.myThriftServer, System.currentTimeMillis() - startMs);
                    } else {
                        CefLog.Error("Can't stop server [%s] in %d seconds.", this.myThriftServer, WAIT_FOR_SERVER_EXIT_SEC);
                    }
                }, "CEF-shutdown-thread");
                t.setDaemon(false);
                t.start();
            }
        }
        HashSet<CefServer> hashSet = ourInstances;
        synchronized (hashSet) {
            ourInstances.remove(this);
        }
    }

    void onRpcThriftException(TException e) {
        this.onDisconnected(e);
    }

    void onCefHandlersThreadFinished() {
        this.onDisconnected(null);
    }

    private void disconnect() {
        this.myIsConnected = false;
        this.myIsDisconnected = true;
        this.myRpc.close();
        if (this.myClientHandlersTransport != null) {
            this.myClientHandlersTransport.close();
            this.myClientHandlersTransport = null;
        }
        if (this.myClientHandlersServer != null) {
            this.myClientHandlersServer.stop();
            this.myClientHandlersServer = null;
        }
        if (this.myThriftBackward != null) {
            this.myThriftBackward.close();
        }
    }

    private void onDisconnected(TException e) {
        if (!this.myIsConnected) {
            return;
        }
        CefApp app = this.myCefApp;
        if (app == null) {
            if (e == null) {
                CefLog.Error("CefApp of server '%s' is null when disconnection happened.", this.toStringShort());
            } else {
                CefLog.Error("CefApp of server '%s' is null, thrift exception: %s", this.toStringShort(), e.getMessage());
            }
        } else if (!app.isShuttingDown()) {
            this.myIsCrashed = true;
            if (e == null) {
                CefLog.Error("CefApp of server '%s' isn't shutting down, but java-client is disconnected", this.toStringShort());
            } else {
                CefLog.Error("CefApp of server '%s' isn't shutting down, but java-client is disconnected, thrift exception: %s", this.toStringShort(), e.getMessage());
            }
            if (this.myDisconnectionCallback != null) {
                this.myDisconnectionCallback.run();
            }
        }
        this.disconnect();
    }

    public static TServer startTestHandlersService(CountDownLatch finished) {
        TServerTransport transport;
        try {
            transport = ThriftTransport.ourDefaultClient.createServerTransport();
        }
        catch (Exception e) {
            CefLog.Error("Exception when opening test-client %s : %s", ThriftTransport.ourDefaultClient.isTcp() ? "tcp-socket" : "pipe", e.getMessage());
            if (ThriftTransport.ourDefaultClient.isTcp()) {
                CefLog.Error("Port : %d", ThriftTransport.ourDefaultClient.getPort());
            } else {
                CefLog.Error("Pipe : %s", ThriftTransport.ourDefaultClient.getPipe());
            }
            return null;
        }
        ClientHandlers.Processor<ClientHandlersDummy> processor = new ClientHandlers.Processor<ClientHandlersDummy>(new ClientHandlersDummy());
        TThreadPoolServer.Args serverArgs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args(transport).processor(processor)).executorService(new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format("CefHandlers(dummy)-execution-%d", this.count.getAndIncrement());
                Thread thread = new Thread(r, name);
                return thread;
            }
        }));
        TThreadPoolServer result = new TThreadPoolServer(serverArgs){

            @Override
            public void stop() {
                super.stop();
                transport.close();
            }
        };
        Thread t = new Thread(() -> {
            try {
                result.serve();
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (finished != null) {
                    finished.countDown();
                }
            }
        });
        t.setName("CefHandlers(dummy)-listening");
        t.start();
        return result;
    }

    public void exec(RpcExecutor.Rpc r) {
        this.myRpc.exec(r);
    }

    public <T> T execObj(RpcExecutor.RpcObj<T> r) {
        return this.myRpc.execObj(r);
    }

    public static class CefParams {
        final String[] args;
        final Set<String> argsSet = new HashSet<String>();
        final CefSettings settings;

        public CefParams(CefSettings settings, String[] args) {
            this.args = args == null ? new String[]{} : Arrays.copyOf(args, args.length);
            CefSettings cefSettings = this.settings = settings == null ? new CefSettings() : settings.clone();
            if (args != null && args.length > 0) {
                for (String arg : args) {
                    if (arg == null) continue;
                    this.argsSet.add(arg.trim());
                }
            }
        }

        public boolean isAlmostEqual(CefParams cp) {
            if (!this.argsSet.equals(cp.argsSet)) {
                return false;
            }
            return this.settings.isAlmostEqual(cp.settings);
        }

        public String toString() {
            return this.argsSet + "| " + this.settings.getDescription();
        }
    }
}

