/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyUnhashableInspectionKt;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeMember;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyUnhashableInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyUnhashableInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u001a\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001b2\b\b\u0001\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u001b\u0010*\u001a\u0004\u0018\u00010\u0019*\u00020)2\u0006\u0010+\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010,R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006-"}, d2={"Lcom/jetbrains/python/inspections/PyUnhashableInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getContext", "()Lcom/jetbrains/python/psi/types/TypeEvalContext;", "visitPyDictLiteralExpression", "", "node", "Lcom/jetbrains/python/psi/PyDictLiteralExpression;", "visitPyDictCompExpression", "Lcom/jetbrains/python/psi/PyDictCompExpression;", "visitPySetLiteralExpression", "Lcom/jetbrains/python/psi/PySetLiteralExpression;", "visitPySetCompExpression", "Lcom/jetbrains/python/psi/PySetCompExpression;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "isDict", "", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "isSet", "processDictKey", "element", "processSetElement", "processHashArgument", "registerIfUnhashable", "messageKey", "", "isHashable", "type", "Lcom/jetbrains/python/psi/types/PyType;", "isHashableClass", "classType", "Lcom/jetbrains/python/psi/types/PyClassType;", "definesMethod", "name", "(Lcom/jetbrains/python/psi/types/PyClassType;Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyUnhashableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyUnhashableInspection.kt\ncom/jetbrains/python/inspections/PyUnhashableInspection$Visitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n19#2:132\n19#2:133\n19#2:134\n19#2:142\n1786#3,3:135\n1786#3,3:138\n1#4:141\n*S KotlinDebug\n*F\n+ 1 PyUnhashableInspection.kt\ncom/jetbrains/python/inspections/PyUnhashableInspection$Visitor\n*L\n60#1:132\n75#1:133\n79#1:134\n122#1:142\n95#1:135,3\n96#1:138,3\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final TypeEvalContext context;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
            this.context = context;
        }

        @NotNull
        public final TypeEvalContext getContext() {
            return this.context;
        }

        public void visitPyDictLiteralExpression(@NotNull PyDictLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyKeyValueExpression[] pyKeyValueExpressionArray = node.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"getElements(...)");
            for (PyKeyValueExpression element : pyKeyValueExpressionArray) {
                PyExpression pyExpression = element.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getKey(...)");
                this.processDictKey(pyExpression);
            }
        }

        public void visitPyDictCompExpression(@NotNull PyDictCompExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyAstExpression pyAstExpression = node.getResultExpression();
            PyKeyValueExpression pyKeyValueExpression = pyAstExpression instanceof PyKeyValueExpression ? (PyKeyValueExpression)pyAstExpression : null;
            if (pyKeyValueExpression == null) {
                return;
            }
            PyKeyValueExpression expression = pyKeyValueExpression;
            PyExpression pyExpression = expression.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getKey(...)");
            this.processDictKey(pyExpression);
        }

        public void visitPySetLiteralExpression(@NotNull PySetLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyAstExpression[] pyAstExpressionArray = node.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
            for (PyExpression element : (PyExpression[])pyAstExpressionArray) {
                Intrinsics.checkNotNull((Object)element);
                this.processSetElement(element);
            }
        }

        public void visitPySetCompExpression(@NotNull PySetCompExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression pyExpression = (PyExpression)node.getResultExpression();
            if (pyExpression == null) {
                return;
            }
            PyExpression expression = pyExpression;
            this.processSetElement(expression);
        }

        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
            for (PyExpression target : pyExpressionArray) {
                if (!(target instanceof PySubscriptionExpression) || !this.isDict(((PySubscriptionExpression)target).getOperand())) continue;
                PyExpression pyExpression = ((PySubscriptionExpression)target).getIndexExpression();
                if (pyExpression == null) continue;
                this.processDictKey(pyExpression);
            }
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyExpression callee;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression $this$asSafely$iv = callee = node.getCallee();
            boolean $i$f$asSafely = false;
            PyExpression pyExpression = $this$asSafely$iv;
            if (!(pyExpression instanceof PyQualifiedExpression)) {
                pyExpression = null;
            }
            PyQualifiedExpression pyQualifiedExpression = (PyQualifiedExpression)pyExpression;
            PyExpression callParent = pyQualifiedExpression != null ? pyQualifiedExpression.getQualifier() : null;
            PyExpression[] pyExpressionArray = node.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
            PyExpression pyExpression2 = (PyExpression)ArraysKt.firstOrNull((Object[])pyExpressionArray);
            if (pyExpression2 == null) {
                return;
            }
            PyExpression firstArgument = pyExpression2;
            String[] stringArray = new String[]{"hash"};
            if (node.isCalleeText(stringArray)) {
                this.processHashArgument(firstArgument);
            }
            PyExpression pyExpression3 = callee;
            if (CollectionsKt.contains((Iterable)PyUnhashableInspectionKt.access$getDICT_KEY_METHODS$p(), (Object)(pyExpression3 != null ? pyExpression3.getName() : null)) && this.isDict(callParent)) {
                this.processDictKey(firstArgument);
            }
            PyExpression pyExpression4 = callee;
            if (CollectionsKt.contains((Iterable)PyUnhashableInspectionKt.access$getSET_ELEMENT_METHODS$p(), (Object)(pyExpression4 != null ? pyExpression4.getName() : null)) && this.isSet(callParent)) {
                this.processSetElement(firstArgument);
            }
        }

        private final boolean isDict(PyExpression expression) {
            String string;
            PyExpression pyExpression = expression;
            if (pyExpression != null) {
                PyExpression it = pyExpression;
                boolean bl = false;
                PyType $this$asSafely$iv = this.context.getType((PyTypedElement)expression);
                boolean $i$f$asSafely = false;
                PyType pyType = $this$asSafely$iv;
                if (!(pyType instanceof PyCollectionType)) {
                    pyType = null;
                }
                PyCollectionType pyCollectionType = (PyCollectionType)pyType;
                string = pyCollectionType != null ? pyCollectionType.getName() : null;
            } else {
                string = null;
            }
            return Intrinsics.areEqual(string, (Object)"dict");
        }

        private final boolean isSet(PyExpression expression) {
            String string;
            PyExpression pyExpression = expression;
            if (pyExpression != null) {
                PyExpression it = pyExpression;
                boolean bl = false;
                PyType $this$asSafely$iv = this.context.getType((PyTypedElement)expression);
                boolean $i$f$asSafely = false;
                PyType pyType = $this$asSafely$iv;
                if (!(pyType instanceof PyCollectionType)) {
                    pyType = null;
                }
                PyCollectionType pyCollectionType = (PyCollectionType)pyType;
                string = pyCollectionType != null ? pyCollectionType.getName() : null;
            } else {
                string = null;
            }
            return Intrinsics.areEqual(string, (Object)"set");
        }

        private final void processDictKey(PyExpression element) {
            this.registerIfUnhashable(element, "INSP.dict.key.not.hashable");
        }

        private final void processSetElement(PyExpression element) {
            this.registerIfUnhashable(element, "INSP.set.element.not.hashable");
        }

        private final void processHashArgument(PyExpression element) {
            this.registerIfUnhashable(element, "INSP.argument.not.hashable");
        }

        private final void registerIfUnhashable(PyExpression element, @PropertyKey(resourceBundle="messages.PyPsiBundle") String messageKey) {
            PyType type = this.context.getType((PyTypedElement)element);
            if (!this.isHashable(type)) {
                Object[] objectArray = new Object[1];
                PyType pyType = type;
                objectArray[0] = pyType != null ? pyType.getName() : null;
                this.registerProblem((PsiElement)element, PyPsiBundle.message(messageKey, objectArray));
            }
        }

        private final boolean isHashable(PyType type) {
            boolean bl;
            block10: {
                PyType pyType = type;
                if (pyType instanceof PyTupleType) {
                    List<PyType> list = ((PyTupleType)type).getElementTypes();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PyType it = (PyType)element$iv;
                            boolean bl2 = false;
                            if (this.isHashable(it)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                } else if (pyType instanceof PyUnionType) {
                    Collection<PyType> collection = ((PyUnionType)type).getMembers();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getMembers(...)");
                    Iterable $this$all$iv = collection;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PyType it = (PyType)element$iv;
                            boolean bl3 = false;
                            if (this.isHashable(it)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                } else {
                    bl = pyType instanceof PyClassType ? this.isHashableClass((PyClassType)type) : true;
                }
            }
            return bl;
        }

        private final boolean isHashableClass(PyClassType classType) {
            Boolean definesEq;
            Boolean definesHash;
            PyClass pyClass = classType.getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
            PyDataclassParameters dataclassParameters = PyDataclassesKt.parseDataclassParameters(pyClass, this.context);
            Boolean bl = this.definesMethod(classType, "__hash__");
            if (bl == null) {
                if (dataclassParameters != null) {
                    PyDataclassParameters $this$isHashableClass_u24lambda_u240 = dataclassParameters;
                    boolean bl2 = false;
                    Boolean bl3 = Intrinsics.areEqual((Object)$this$isHashableClass_u24lambda_u240.getFrozen(), (Object)true) || $this$isHashableClass_u24lambda_u240.getUnsafeHash();
                    boolean it = bl3;
                    boolean bl4 = false;
                    bl = it ? bl3 : null;
                } else {
                    bl = null;
                }
            }
            Boolean bl5 = definesHash = bl;
            if (bl5 != null) {
                return bl5;
            }
            Boolean bl6 = this.definesMethod(classType, "__eq__");
            if (bl6 == null) {
                PyDataclassParameters pyDataclassParameters = dataclassParameters;
                bl6 = pyDataclassParameters != null ? Boolean.valueOf(pyDataclassParameters.getEq()) : null;
            }
            return !Intrinsics.areEqual((Object)(definesEq = bl6), (Object)true);
        }

        private final Boolean definesMethod(PyClassType $this$definesMethod, String name) {
            PyPossibleClassMember pyPossibleClassMember;
            PyTypedElement member;
            List list = $this$definesMethod.findMember(name, this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findMember(...)");
            PyTypeMember pyTypeMember = (PyTypeMember)CollectionsKt.firstOrNull((List)list);
            PsiElement psiElement = pyTypeMember != null ? pyTypeMember.getElement() : null;
            PyTypedElement pyTypedElement = psiElement instanceof PyTypedElement ? (PyTypedElement)psiElement : null;
            if (pyTypedElement == null) {
                return null;
            }
            PyTypedElement $this$asSafely$iv = member = pyTypedElement;
            boolean $i$f$asSafely = false;
            PyTypedElement pyTypedElement2 = $this$asSafely$iv;
            if (!(pyTypedElement2 instanceof PyPossibleClassMember)) {
                pyTypedElement2 = null;
            }
            if ((pyPossibleClassMember = (PyPossibleClassMember)pyTypedElement2) == null || (pyPossibleClassMember = pyPossibleClassMember.getContainingClass()) == null) {
                return null;
            }
            PyPossibleClassMember containingClass = pyPossibleClassMember;
            if (PyUtil.isObjectClass((PyClass)containingClass)) {
                return null;
            }
            return !PyNoneTypeKt.isNoneType(this.context.getType(member));
        }
    }
}

